/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.dbpool.PostgreSqlDataSourceConfig;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestPostgreSqlDataSourceConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((PostgreSqlDataSourceConfig)((PostgreSqlDataSourceConfig)((PostgreSqlDataSourceConfig)ConfigAssertions.recordDefaults(PostgreSqlDataSourceConfig.class)).setDefaultFetchSize(100).setMaxConnections(10)).setMaxConnectionWait(new Duration(500.0, TimeUnit.MILLISECONDS))));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"db.fetch-size", (Object)"500").put((Object)"db.connections.max", (Object)"12").put((Object)"db.connections.wait", (Object)"42s").build();
        PostgreSqlDataSourceConfig expected = (PostgreSqlDataSourceConfig)((PostgreSqlDataSourceConfig)new PostgreSqlDataSourceConfig().setDefaultFetchSize(500).setMaxConnections(12)).setMaxConnectionWait(new Duration(42.0, TimeUnit.SECONDS));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

