/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs.testing;

import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StringResponseHandler;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.jaxrs.testing.JaxrsTestingHttpProcessor;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class TestJaxrsTestingHttpProcessor {
    private static final TestingHttpClient HTTP_CLIENT = new TestingHttpClient((TestingHttpClient.Processor)new JaxrsTestingHttpProcessor(URI.create("http://fake.invalid/"), new Object[]{new GetItResource()}));

    @Test
    public void test() {
        Request request = Request.Builder.prepareGet().setUri(URI.create("http://fake.invalid/get-it/get/xyz")).setHeader("X-Test", "abc").build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)HTTP_CLIENT.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK.code());
        Assert.assertEquals((String)response.getBody(), (String)"Got xyz");
        Assert.assertEquals((String)response.getHeader("X-Test-Out"), (String)"Got abc");
    }

    @Test
    public void testException() {
        Request request = Request.Builder.prepareGet().setUri(URI.create("http://fake.invalid/get-it/fail/testException")).build();
        try {
            HTTP_CLIENT.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
            Assert.fail((String)"expected exception");
        }
        catch (TestingException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"testException");
        }
    }

    @Test
    public void testUndefinedResource() {
        Request request = Request.Builder.prepareGet().setUri(URI.create("http://fake.invalid/unknown")).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)HTTP_CLIENT.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)404);
    }

    @Test
    public void testOptions() {
        Request request = new Request.Builder().setMethod("OPTIONS").setUri(URI.create("http://fake.invalid/get-it/get/xyz")).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)HTTP_CLIENT.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        Assertions.assertThat((String)response.getHeader("Content-Type")).isEqualTo("application/vnd.sun.wadl+xml");
        ((AbstractStringAssert)Assertions.assertThat((String)response.getBody()).startsWith((CharSequence)"<?xml ")).contains(new CharSequence[]{"<application "});
    }

    private static class TestingException
    extends RuntimeException {
        public TestingException(String message) {
            super(message);
        }
    }

    @Path(value="get-it")
    public static class GetItResource {
        @Path(value="get/{id}")
        @GET
        @Produces(value={"text/plain"})
        public Response getId(@HeaderParam(value="X-Test") String test, @PathParam(value="id") String id) {
            return Response.ok((Object)("Got " + id)).header("X-Test-Out", (Object)("Got " + test)).build();
        }

        @Path(value="fail/{message}")
        @GET
        @Produces(value={"text/plain"})
        public String fail(@PathParam(value="message") String errorMessage) {
            throw new TestingException(errorMessage);
        }
    }
}

