/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx.http.rpc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.http.server.TheServlet;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jmx.http.rpc.JmxHttpRpcModule;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;
import org.weakref.jmx.ObjectNames;

@Test(singleThreaded=true)
public class TestMBeanServerResource {
    private final MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
    private LifeCycleManager lifeCycleManager;
    private MBeanServerConnection mbeanServerConnection;
    private TestMBean testMBean;
    private ObjectName testMBeanName;

    @BeforeMethod
    public void setup() throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingHttpServerModule(), new JsonModule(), new JmxHttpRpcModule(TheServlet.class), binder -> {
            binder.bind(MBeanServer.class).toInstance((Object)this.platformMBeanServer);
            binder.bind(TestMBean.class).in(Scopes.SINGLETON);
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        TestingHttpServer server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
        this.testMBean = (TestMBean)injector.getInstance(TestMBean.class);
        this.testMBeanName = new ObjectName(ObjectNames.generatedNameOf(TestMBean.class));
        MBeanExporter exporter = new MBeanExporter(this.platformMBeanServer);
        exporter.export(this.testMBeanName.toString(), (Object)this.testMBean);
        JMXConnector connect = JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:" + server.getBaseUrl()), ImmutableMap.of((Object)"jmx.remote.credentials", (Object)new String[]{"foo", "bar"}));
        this.mbeanServerConnection = connect.getMBeanServerConnection();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        if (this.lifeCycleManager != null) {
            this.lifeCycleManager.stop();
            this.platformMBeanServer.unregisterMBean(this.testMBeanName);
        }
    }

    @Test
    public void testGetMBeanCount() throws Exception {
        Assert.assertEquals((Object)this.mbeanServerConnection.getMBeanCount(), (Object)this.platformMBeanServer.getMBeanCount());
    }

    @Test
    public void testIsRegistered() throws Exception {
        Assert.assertEquals((boolean)this.mbeanServerConnection.isRegistered(this.testMBeanName), (boolean)true);
        Assert.assertEquals((boolean)this.mbeanServerConnection.isRegistered(new ObjectName("fake", "fake", "fake")), (boolean)false);
    }

    @Test
    public void testIsInstanceOf() throws Exception {
        Assert.assertEquals((boolean)this.mbeanServerConnection.isInstanceOf(this.testMBeanName, TestMBean.class.getName()), (boolean)true);
        Assert.assertEquals((boolean)this.mbeanServerConnection.isInstanceOf(this.testMBeanName, Object.class.getName()), (boolean)true);
        Assert.assertEquals((boolean)this.mbeanServerConnection.isInstanceOf(this.testMBeanName, UUID.class.getName()), (boolean)false);
    }

    @Test
    public void testGetDefaultDomain() throws Exception {
        Assert.assertEquals((String)this.mbeanServerConnection.getDefaultDomain(), (String)this.platformMBeanServer.getDefaultDomain());
    }

    @Test
    public void testGetDomains() throws Exception {
        Assert.assertEquals((Object[])this.mbeanServerConnection.getDomains(), (Object[])this.platformMBeanServer.getDomains());
    }

    @Test
    public void testGetObjectInstance() throws Exception {
        Assert.assertEquals((Object)this.mbeanServerConnection.getObjectInstance(this.testMBeanName), (Object)this.platformMBeanServer.getObjectInstance(this.testMBeanName));
    }

    @Test
    public void testGetMBeanInfo() throws Exception {
        Assert.assertEquals((Object)this.mbeanServerConnection.getMBeanInfo(this.testMBeanName), (Object)this.platformMBeanServer.getMBeanInfo(this.testMBeanName));
    }

    @Test
    public void testGetQueryMBeanNames() throws Exception {
        Assert.assertEquals(this.mbeanServerConnection.queryNames(this.testMBeanName, null), this.platformMBeanServer.queryNames(this.testMBeanName, null));
        Assert.assertEquals(this.mbeanServerConnection.queryNames(new ObjectName("*:*"), null), this.platformMBeanServer.queryNames(new ObjectName("*:*"), null));
    }

    @Test
    public void testGetQueryMBeans() throws Exception {
        Assert.assertEquals(this.mbeanServerConnection.queryMBeans(this.testMBeanName, null), this.platformMBeanServer.queryMBeans(this.testMBeanName, null));
        Assert.assertEquals(this.mbeanServerConnection.queryMBeans(new ObjectName("*:*"), null), this.platformMBeanServer.queryMBeans(new ObjectName("*:*"), null));
    }

    @Test
    public void testGetAttribute() throws Exception {
        Assert.assertEquals((Object)this.mbeanServerConnection.getAttribute(this.testMBeanName, "Value"), null);
        this.testMBean.setValue("FOO");
        Assert.assertEquals((Object)this.mbeanServerConnection.getAttribute(this.testMBeanName, "Value"), (Object)"FOO");
        Assert.assertEquals((Object)this.mbeanServerConnection.getAttribute(this.testMBeanName, "ObjectValue"), null);
        this.testMBean.setObjectValue(UUID.randomUUID());
        Assert.assertEquals((Object)this.mbeanServerConnection.getAttribute(this.testMBeanName, "ObjectValue"), (Object)this.testMBean.getObjectValue());
    }

    @Test
    public void testGetAttributes() throws Exception {
        Assert.assertEquals((Collection)this.mbeanServerConnection.getAttributes(this.testMBeanName, new String[]{"Value", "ObjectValue"}), (Collection)new AttributeList((List<Attribute>)ImmutableList.of((Object)new Attribute("Value", null), (Object)new Attribute("ObjectValue", null))));
        this.testMBean.setValue("FOO");
        this.testMBean.setObjectValue(UUID.randomUUID());
        Assert.assertEquals((Collection)this.mbeanServerConnection.getAttributes(this.testMBeanName, new String[]{"Value", "ObjectValue"}), (Collection)new AttributeList((List<Attribute>)ImmutableList.of((Object)new Attribute("Value", "FOO"), (Object)new Attribute("ObjectValue", this.testMBean.getObjectValue()))));
    }

    @Test
    public void testSetAttribute() throws Exception {
        this.mbeanServerConnection.setAttribute(this.testMBeanName, new Attribute("Value", "Foo"));
        Assert.assertEquals((String)this.testMBean.getValue(), (String)"Foo");
        this.mbeanServerConnection.setAttribute(this.testMBeanName, new Attribute("Value", null));
        Assert.assertEquals((String)this.testMBean.getValue(), null);
        UUID uuid = UUID.randomUUID();
        this.mbeanServerConnection.setAttribute(this.testMBeanName, new Attribute("ObjectValue", uuid));
        Assert.assertEquals((Object)this.testMBean.getObjectValue(), (Object)uuid);
        this.mbeanServerConnection.setAttribute(this.testMBeanName, new Attribute("ObjectValue", null));
        Assert.assertEquals((Object)this.testMBean.getObjectValue(), null);
    }

    @Test
    public void testSetAttributes() throws Exception {
        UUID uuid = UUID.randomUUID();
        this.mbeanServerConnection.setAttributes(this.testMBeanName, new AttributeList((List<Attribute>)ImmutableList.of((Object)new Attribute("Value", "Foo"), (Object)new Attribute("ObjectValue", uuid))));
        Assert.assertEquals((String)this.testMBean.getValue(), (String)"Foo");
        Assert.assertEquals((Object)this.testMBean.getObjectValue(), (Object)uuid);
        this.mbeanServerConnection.setAttributes(this.testMBeanName, new AttributeList((List<Attribute>)ImmutableList.of((Object)new Attribute("Value", null), (Object)new Attribute("ObjectValue", null))));
        Assert.assertEquals((String)this.testMBean.getValue(), null);
        Assert.assertEquals((Object)this.testMBean.getObjectValue(), null);
    }

    @Test
    public void testInvoke() throws Exception {
        Assert.assertEquals((boolean)this.testMBean.noArgsMethodInvoked, (boolean)false);
        this.mbeanServerConnection.invoke(this.testMBeanName, "noArgsMethod", null, null);
        Assert.assertEquals((boolean)this.testMBean.noArgsMethodInvoked, (boolean)true);
        UUID uuid = UUID.randomUUID();
        Assert.assertEquals((Object)this.mbeanServerConnection.invoke(this.testMBeanName, "echo", new Object[]{uuid}, new String[]{Object.class.getName()}), (Object)uuid);
    }

    @Test
    public void testInvokeThrows() throws Exception {
        try {
            this.mbeanServerConnection.invoke(this.testMBeanName, "throwException", new Object[]{new Exception("exception-message")}, new String[]{Throwable.class.getName()});
            Assert.fail((String)"Expected exception");
        }
        catch (MBeanException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof Exception));
            Assert.assertEquals((String)e.getCause().getMessage(), (String)"exception-message");
        }
    }

    public static class TestMBean {
        private String value;
        private Object objectValue;
        public boolean noArgsMethodInvoked;

        @Managed
        public String getValue() {
            return this.value;
        }

        @Managed
        public void setValue(String value) {
            this.value = value;
        }

        @Managed
        public Object getObjectValue() {
            return this.objectValue;
        }

        @Managed
        public void setObjectValue(Object objectValue) {
            this.objectValue = objectValue;
        }

        @Managed
        public void noArgsMethod() {
            this.noArgsMethodInvoked = true;
        }

        @Managed
        public Object echo(Object object) {
            return object;
        }

        @Managed
        public void throwException(Throwable t) throws Throwable {
            throw t;
        }
    }
}

