/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.InetAddresses;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.node.NodeInfo;
import io.airlift.node.NodeModule;
import io.airlift.testing.Assertions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNodeModule {
    @Test
    public void testDefaultConfig() throws UnknownHostException {
        long testStartTime = System.currentTimeMillis();
        ConfigurationFactory configFactory = new ConfigurationFactory((Map)ImmutableMap.of((Object)"node.environment", (Object)"environment"));
        Injector injector = Guice.createInjector((Module[])new Module[]{new NodeModule(), new ConfigurationModule(configFactory)});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assert.assertNotNull((Object)nodeInfo);
        Assert.assertEquals((String)nodeInfo.getEnvironment(), (String)"environment");
        Assert.assertEquals((String)nodeInfo.getPool(), (String)"general");
        Assert.assertNotNull((Object)nodeInfo.getNodeId());
        Assert.assertNotNull((Object)nodeInfo.getLocation());
        Assert.assertNull((Object)nodeInfo.getBinarySpec());
        Assert.assertNull((Object)nodeInfo.getConfigSpec());
        Assert.assertNotNull((Object)nodeInfo.getInstanceId());
        Assertions.assertNotEquals((Object)nodeInfo.getNodeId(), (Object)nodeInfo.getInstanceId());
        Assert.assertNotNull((Object)nodeInfo.getInternalAddress());
        Assert.assertFalse((boolean)InetAddress.getByName(nodeInfo.getInternalAddress()).isAnyLocalAddress());
        Assert.assertNotNull((Object)nodeInfo.getBindIp());
        Assert.assertTrue((boolean)nodeInfo.getBindIp().isAnyLocalAddress());
        Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(nodeInfo.getStartTime()), (Comparable)Long.valueOf(testStartTime));
        Assert.assertNotNull((Object)nodeInfo.toString());
    }

    @Test
    public void testFullConfig() {
        long testStartTime = System.currentTimeMillis();
        String environment = "environment";
        String pool = "pool";
        String nodeId = "nodeId";
        String location = "location";
        String binarySpec = "binary";
        String configSpec = "config";
        String publicAddress = "public";
        ConfigurationFactory configFactory = new ConfigurationFactory((Map)ImmutableMap.builder().put((Object)"node.environment", (Object)environment).put((Object)"node.pool", (Object)pool).put((Object)"node.id", (Object)nodeId).put((Object)"node.internal-address", (Object)publicAddress).put((Object)"node.location", (Object)location).put((Object)"node.binary-spec", (Object)binarySpec).put((Object)"node.config-spec", (Object)configSpec).build());
        Injector injector = Guice.createInjector((Module[])new Module[]{new NodeModule(), new ConfigurationModule(configFactory)});
        NodeInfo nodeInfo = (NodeInfo)injector.getInstance(NodeInfo.class);
        Assert.assertNotNull((Object)nodeInfo);
        Assert.assertEquals((String)nodeInfo.getEnvironment(), (String)environment);
        Assert.assertEquals((String)nodeInfo.getPool(), (String)pool);
        Assert.assertEquals((String)nodeInfo.getNodeId(), (String)nodeId);
        Assert.assertEquals((String)nodeInfo.getLocation(), (String)location);
        Assert.assertEquals((String)nodeInfo.getBinarySpec(), (String)binarySpec);
        Assert.assertEquals((String)nodeInfo.getConfigSpec(), (String)configSpec);
        Assert.assertNotNull((Object)nodeInfo.getInstanceId());
        Assertions.assertNotEquals((Object)nodeInfo.getNodeId(), (Object)nodeInfo.getInstanceId());
        Assert.assertEquals((String)nodeInfo.getInternalAddress(), (String)publicAddress);
        Assert.assertEquals((Object)nodeInfo.getBindIp(), (Object)InetAddresses.forString((String)"0.0.0.0"));
        Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(nodeInfo.getStartTime()), (Comparable)Long.valueOf(testStartTime));
        Assert.assertNotNull((Object)nodeInfo.toString());
    }
}

