/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration.secrets;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.spi.secrets.SecretProvider;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SecretsResolver {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([a-zA-Z][a-zA-Z0-9_-]*):([a-zA-Z][a-zA-Z0-9_-]*)}");
    private final Map<String, SecretProvider> secretProviders;

    public SecretsResolver(Map<String, SecretProvider> secretProviders) {
        this.secretProviders = ImmutableMap.copyOf(Objects.requireNonNull(secretProviders, "secretProviders is null"));
    }

    public Map<String, String> getResolvedConfiguration(Map<String, String> properties) {
        return this.getResolvedConfiguration(properties, (propertyKey, throwable) -> {
            throw new RuntimeException(throwable.getMessage());
        });
    }

    public Map<String, String> getResolvedConfiguration(Map<String, String> properties, BiConsumer<String, Throwable> onError) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)properties.size());
        properties.forEach((propertyKey, propertyValue) -> {
            try {
                builder.put(propertyKey, (Object)this.resolveConfiguration((String)propertyValue));
            }
            catch (RuntimeException exception) {
                onError.accept((String)propertyKey, exception);
            }
        });
        return builder.buildOrThrow();
    }

    private String resolveConfiguration(String configurationValue) {
        StringBuilder replacedPropertyValue = new StringBuilder();
        Matcher matcher = PATTERN.matcher(configurationValue);
        while (matcher.find()) {
            String secretProviderName = matcher.group(1).toLowerCase(Locale.ENGLISH);
            SecretProvider secretProvider = this.secretProviders.get(secretProviderName);
            Preconditions.checkArgument((secretProvider != null ? 1 : 0) != 0, (String)"No secret provider for key '%s'", (Object)secretProviderName);
            String keyName = matcher.group(2);
            matcher.appendReplacement(replacedPropertyValue, Matcher.quoteReplacement(secretProvider.resolveSecretValue(keyName)));
        }
        matcher.appendTail(replacedPropertyValue);
        return replacedPropertyValue.toString();
    }
}

