#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package};

import com.google.inject.Guice;
import com.google.inject.Injector;
import ${groupId}.configuration.ConfigurationFactory;
import ${groupId}.configuration.ConfigurationModule;
import ${groupId}.jmx.JmxHttpModule;
import ${groupId}.http.client.ApacheHttpClient;
import ${groupId}.http.client.HttpClient;
import ${groupId}.http.client.StatusResponseHandler.StatusResponse;
import ${groupId}.http.server.testing.TestingHttpServer;
import ${groupId}.http.server.testing.TestingHttpServerModule;
import ${groupId}.jaxrs.JaxrsModule;
import ${groupId}.jmx.JmxModule;
import ${groupId}.json.JsonModule;
import ${groupId}.node.testing.TestingNodeModule;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.net.URI;
import java.util.Collections;

import static ${groupId}.http.client.Request.Builder.prepareGet;
import static ${groupId}.http.client.StatusResponseHandler.createStatusResponseHandler;
import static javax.ws.rs.core.Response.Status.OK;
import static org.testng.Assert.assertEquals;

public class TestServer
{
    private HttpClient client;
    private TestingHttpServer server;

    @BeforeMethod
    public void setup()
            throws Exception
    {
        // TODO: wrap all this stuff in a TestBootstrap class
        Injector injector = Guice.createInjector(
                new TestingNodeModule(),
                new TestingHttpServerModule(),
                new JsonModule(),
                new JaxrsModule(),
                new JmxHttpModule(),
                new JmxModule(),
                new MainModule(),
                new ConfigurationModule(new ConfigurationFactory(Collections.<String, String>emptyMap())));

        server = injector.getInstance(TestingHttpServer.class);

        server.start();
        client = new ApacheHttpClient();
    }

    @AfterMethod
    public void teardown()
            throws Exception
    {
        if (server != null) {
            server.stop();
        }
    }

    @Test
    public void testNothing()
            throws Exception
    {
        StatusResponse response = client.execute(
                prepareGet().setUri(uriFor("/v1/jmx/mbean")).build(),
                createStatusResponseHandler());

        assertEquals(response.getStatusCode(), OK.getStatusCode());
    }

    private URI uriFor(String path)
    {
        return server.getBaseUrl().resolve(path);
    }
}
