/*
 * Copyright 2010 Proofpoint, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ${package};

import com.google.inject.Injector;
import archetype.it.bootstrap.Bootstrap;
import archetype.it.discovery.client.Announcer;
import archetype.it.discovery.client.DiscoveryModule;
import archetype.it.event.client.HttpEventModule;
import archetype.it.jmx.JmxHttpModule;
import archetype.it.http.server.HttpServerModule;
import archetype.it.jaxrs.JaxrsModule;
import archetype.it.jmx.JmxModule;
import archetype.it.jmx.http.rpc.JmxHttpRpcModule;
import archetype.it.json.JsonModule;
import archetype.it.log.LogJmxModule;
import archetype.it.log.Logger;
import archetype.it.node.NodeModule;
import archetype.it.tracetoken.TraceTokenModule;
import org.weakref.jmx.guice.MBeanModule;

public class Main
{
    private final static Logger log = Logger.get(Main.class);

    public static void main(String[] args)
            throws Exception
    {
        Bootstrap app = new Bootstrap(
                new NodeModule(),
                new DiscoveryModule(),
                new HttpServerModule(),
                new JsonModule(),
                new JaxrsModule(),
                new MBeanModule(),
                new JmxModule(),
                new JmxHttpModule(),
                new JmxHttpRpcModule(),
                new LogJmxModule(),
                new HttpEventModule(),
                new TraceTokenModule(),
                new MainModule());

        try {
            Injector injector = app.strictConfig().initialize();
            injector.getInstance(Announcer.class).start();
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(1);
        }
    }
}
