package ${package};

import com.google.inject.Injector;
import archetype.it.bootstrap.Bootstrap;
import archetype.it.bootstrap.LifeCycleManager;
import archetype.it.http.client.ApacheHttpClient;
import archetype.it.http.client.HttpClient;
import archetype.it.http.client.StatusResponseHandler.StatusResponse;
import archetype.it.http.server.testing.TestingHttpServer;
import archetype.it.http.server.testing.TestingHttpServerModule;
import archetype.it.jaxrs.JaxrsModule;
import archetype.it.jmx.JmxHttpModule;
import archetype.it.jmx.JmxModule;
import archetype.it.json.JsonModule;
import archetype.it.node.testing.TestingNodeModule;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.net.URI;

import static archetype.it.http.client.Request.Builder.prepareGet;
import static archetype.it.http.client.StatusResponseHandler.createStatusResponseHandler;
import static javax.ws.rs.core.Response.Status.OK;
import static org.testng.Assert.assertEquals;

public class TestServer
{
    private HttpClient client;
    private TestingHttpServer server;
    private LifeCycleManager lifeCycleManager;

    @BeforeMethod
    public void setup()
            throws Exception
    {
        Bootstrap app = new Bootstrap(
                new TestingNodeModule(),
                new TestingHttpServerModule(),
                new JsonModule(),
                new JaxrsModule(),
                new JmxHttpModule(),
                new JmxModule(),
                new MainModule());

        Injector injector = app
                .strictConfig()
                .doNotInitializeLogging()
                .initialize();

        lifeCycleManager = injector.getInstance(LifeCycleManager.class);
        server = injector.getInstance(TestingHttpServer.class);
        client = new ApacheHttpClient();
    }

    @AfterMethod
    public void teardown()
            throws Exception
    {
        if (lifeCycleManager != null) {
            lifeCycleManager.stop();
        }
    }

    @Test
    public void testNothing()
            throws Exception
    {
        StatusResponse response = client.execute(
                prepareGet().setUri(uriFor("/v1/jmx/mbean")).build(),
                createStatusResponseHandler());

        assertEquals(response.getStatusCode(), OK.getStatusCode());
    }

    private URI uriFor(String path)
    {
        return server.getBaseUrl().resolve(path);
    }
}
