/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.airlift.slice;

import com.google.common.primitives.Ints;
import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;

public class TestSpookyHashV2
{
    @Test
    public void testHash32()
    {
        int[] expected = new int[] {
                0x6bf50919, 0x70de1d26, 0xa2b37298, 0x35bc5fbf, 0x8223b279, 0x5bcb315e, 0x53fe88a1, 0xf9f1a233, 0xee193982, 0x54f86f29, 0xc8772d36, 0x9ed60886, 0x5f23d1da,
                0x1ed9f474, 0xf2ef0c89, 0x83ec01f9, 0xf274736c, 0x7e9ac0df, 0xc7aed250, 0xb1015811, 0xe23470f5, 0x48ac20c4, 0xe2ab3cd5, 0x608f8363, 0xd0639e68, 0xc4e8e7ab,
                0x863c7c5b, 0x4ea63579, 0x99ae8622, 0x170c658b, 0x149ba493, 0x027bca7c, 0xe5cfc8b6, 0xce01d9d7, 0x11103330, 0x5d1f5ed4, 0xca720ecb, 0xef408aec, 0x733b90ec,
                0x855737a6, 0x9856c65f, 0x647411f7, 0x50777c74, 0xf0f1a8b7, 0x9d7e55a5, 0xc68dd371, 0xfc1af2cc, 0x75728d0a, 0x390e5fdc, 0xf389b84c, 0xfb0ccf23, 0xc95bad0e,
                0x5b1cb85a, 0x6bdae14f, 0x6deb4626, 0x93047034, 0x6f3266c6, 0xf529c3bd, 0x396322e7, 0x3777d042, 0x1cd6a5a2, 0x197b402e, 0xc28d0d2b, 0x09c1afb4, 0x069c8bb7,
                0x6f9d4e1e, 0xd2621b5c, 0xea68108d, 0x8660cb8f, 0xd61e6de6, 0x7fba15c7, 0xaacfaa97, 0xdb381902, 0x4ea22649, 0x5d414a1e, 0xc3fc5984, 0xa0fc9e10, 0x347dc51c,
                0x37545fb6, 0x8c84b26b, 0xf57efa5d, 0x56afaf16, 0xb6e1eb94, 0x9218536a, 0xe3cc4967, 0xd3275ef4, 0xea63536e, 0x6086e499, 0xaccadce7, 0xb0290d82, 0x4ebfd0d6,
                0x46ccc185, 0x2eeb10d3, 0x474e3c8c, 0x23c84aee, 0x3abae1cb, 0x1499b81a, 0xa2993951, 0xeed176ad, 0xdfcfe84c, 0xde4a961f, 0x4af13fe6, 0xe0069c42, 0xc14de8f5,
                0x6e02ce8f, 0x90d19f7f, 0xbca4a484, 0xd4efdd63, 0x780fd504, 0xe80310e3, 0x03abbc12, 0x90023849, 0xd6f6fb84, 0xd6b354c5, 0x5b8575f0, 0x758f14e4, 0x450de862,
                0x90704afb, 0x47209a33, 0xf226b726, 0xf858dab8, 0x7c0d6de9, 0xb05ce777, 0xee5ff2d4, 0x7acb6d5c, 0x2d663f85, 0x41c72a91, 0x82356bf2, 0x94e948ec, 0xd358d448,
                0xeca7814d, 0x78cd7950, 0xd6097277, 0x97782a5d, 0xf43fc6f4, 0x105f0a38, 0x9e170082, 0x4bfe566b, 0x4371d25f, 0xef25a364, 0x698eb672, 0x74f850e4, 0x4678ff99,
                0x4a290dc6, 0x3918f07c, 0x32c7d9cd, 0x9f28e0af, 0x0d3c5a86, 0x7bfc8a45, 0xddf0c7e1, 0xdeacb86b, 0x970b3c5c, 0x5e29e199, 0xea28346d, 0x6b59e71b, 0xf8a8a46a,
                0x862f6ce4, 0x3ccb740b, 0x08761e9e, 0xbfa01e5f, 0xf17cfa14, 0x2dbf99fb, 0x7a0be420, 0x06137517, 0xe020b266, 0xd25bfc61, 0xff10ed00, 0x42e6be8b, 0x029ef587,
                0x683b26e0, 0xb08afc70, 0x7c1fd59e, 0xbaae9a70, 0x98c8c801, 0xb6e35a26, 0x57083971, 0x90a6a680, 0x1b44169e, 0x1dce237c, 0x518e0a59, 0xccb11358, 0x7b8175fb,
                0xb8fe701a, 0x10d259bb, 0xe806ce10, 0x9212be79, 0x4604ae7b, 0x7fa22a84, 0xe715b13a, 0x0394c3b2, 0x11efbbae, 0xe13d9e19, 0x77e012bd, 0x2d05114c, 0xaecf2ddd,
                0xb2a2b4aa, 0xb9429546, 0x55dce815, 0xc89138f8, 0x46dcae20, 0x1f6f7162, 0x0c557ebc, 0x5b996932, 0xafbbe7e2, 0xd2bd5f62, 0xff475b9f, 0x9cec7108, 0xeaddcffb,
                0x5d751aef, 0xf68f7bdf, 0xf3f4e246, 0x00983fcd, 0x00bc82bb, 0xbf5fd3e7, 0xe80c7e2c, 0x187d8b1f, 0xefafb9a7, 0x8f27a148, 0x5c9606a9, 0xf2d2be3e, 0xe992d13a,
                0xe4bcd152, 0xce40b436, 0x63d6a1fc, 0xdc1455c4, 0x64641e39, 0xd83010c9, 0x2d535ae0, 0x5b748f3e, 0xf9a9146b, 0x80f10294, 0x2859acd4, 0x5fc846da, 0x56d190e9,
                0x82167225, 0x98e4daba, 0xbf7865f3, 0x00da7ae4, 0x9b7cd126, 0x644172f8, 0xde40c78f, 0xe8803efc, 0xdd331a2b, 0x48485c3c, 0x4ed01ddc, 0x9c0b2d9e, 0xb1c6e9d7,
                0xd797d43c, 0x274101ff, 0x3bf7e127, 0x91ebbc56, 0x7ffeb321, 0x4d42096f, 0xd6e9456a, 0x0bade318, 0x2f40ee0b, 0x38cebf03, 0x0cbc2e72, 0xbf03e704, 0x7b3e7a9a,
                0x8e985acd, 0x90917617, 0x413895f8, 0xf11dde04, 0xc66f8244, 0xe5648174, 0x6c420271, 0x2469d463, 0x2540b033, 0xdc788e7b, 0xe4140ded, 0x0990630a, 0xa54abed4,
                0x6e124829, 0xd940155a, 0x1c8836f6, 0x38fda06c, 0x5207ab69, 0xf8be9342, 0x774882a8, 0x56fc0d7e, 0x53a99d6e, 0x8241f634, 0x9490954d, 0x447130aa, 0x8cc4a81f,
                0x0868ec83, 0xc22c642d, 0x47880140, 0xfbff3bec, 0x0f531f41, 0xf845a667, 0x08c15fb7, 0x1996cd81, 0x86579103, 0xe21dd863, 0x513d7f97, 0x3984a1f1, 0xdfcdc5f4,
                0x97766a5e, 0x37e2b1da, 0x41441f3f, 0xabd9ddba, 0x23b755a9, 0xda937945, 0x103e650e, 0x3eef7c8f, 0x2760ff8d, 0x2493a4cd, 0x1d671225, 0x3bf4bd4c, 0xed6e1728,
                0xc70e9e30, 0x4e05e529, 0x928d5aa6, 0x164d0220, 0xb5184306, 0x4bd7efb3, 0x63830f11, 0xf3a1526c, 0xf1545450, 0xd41d5df5, 0x25a5060d, 0x77b368da, 0x4fe33c7e,
                0xeae09021, 0xfdb053c4, 0x2930f18d, 0xd37109ff, 0x8511a781, 0xc7e7cdd7, 0x6aeabc45, 0xebbeaeaa, 0x9a0c4f11, 0xda252cbb, 0x5b248f41, 0x5223b5eb, 0xe32ab782,
                0x8e6a1c97, 0x11d3f454, 0x3e05bd16, 0x0059001d, 0xce13ac97, 0xf83b2b4c, 0x71db5c9a, 0xdc8655a6, 0x9e98597b, 0x3fcae0a2, 0x75e63ccd, 0x076c72df, 0x4754c6ad,
                0x26b5627b, 0xd818c697, 0x998d5f3d, 0xe94fc7b2, 0x1f49ad1a, 0xca7ff4ea, 0x9fe72c05, 0xfbd0cbbf, 0xb0388ceb, 0xb76031e3, 0xd0f53973, 0xfb17907c, 0xa4c4c10f,
                0x9f2d8af9, 0xca0e56b0, 0xb0d9b689, 0xfcbf37a3, 0xfede8f7d, 0xf836511c, 0x744003fc, 0x89eba576, 0xcfdcf6a6, 0xc2007f52, 0xaaaf683f, 0x62d2f9ca, 0xc996f77f,
                0x77a7b5b3, 0x8ba7d0a4, 0xef6a0819, 0xa0d903c0, 0x01b27431, 0x58fffd4c, 0x4827f45c, 0x44eb5634, 0xae70edfc, 0x591c740b, 0x478bf338, 0x2f3b513b, 0x67bf518e,
                0x6fef4a0c, 0x1e0b6917, 0x5ac0edc5, 0x2e328498, 0x077de7d5, 0x5726020b, 0x2aeda888, 0x45b637ca, 0xcf60858d, 0x3dc91ae2, 0x3e6d5294, 0xe6900d39, 0x0f634c71,
                0x827a5fa4, 0xc713994b, 0x1c363494, 0x3d43b615, 0xe5fe7d15, 0xf6ada4f2, 0x472099d5, 0x04360d39, 0x7f2a71d0, 0x88a4f5ff, 0x2c28fac5, 0x4cd64801, 0xfd78dd33,
                0xc9bdd233, 0x21e266cc, 0x9bbf419d, 0xcbf7d81d, 0x80f15f96, 0x04242657, 0x53fb0f66, 0xded11e46, 0xf2fdba97, 0x8d45c9f1, 0x4eeae802, 0x17003659, 0xb9db81a7,
                0xe734b1b2, 0x9503c54e, 0xb7c77c3e, 0x271dd0ab, 0xd8b906b5, 0x0d540ec6, 0xf03b86e0, 0x0fdb7d18, 0x95e261af, 0xad9ec04e, 0x381f4a64, 0xfec798d7, 0x09ea20be,
                0x0ef4ca57, 0x1e6195bb, 0xfd0da78b, 0xcea1653b, 0x157d9777, 0xf04af50f, 0xad7baa23, 0xd181714a, 0x9bbdab78, 0x6c7d1577, 0x645eb1e7, 0xa0648264, 0x35839ca6,
                0x2287ef45, 0x32a64ca3, 0x26111f6f, 0x64814946, 0xb0cddaf1, 0x4351c59e, 0x1b30471c, 0xb970788a, 0x30e9f597, 0xd7e58df1, 0xc6d2b953, 0xf5f37cf4, 0x3d7c419e,
                0xf91ecb2d, 0x9c87fd5d, 0xb22384ce, 0x8c7ac51c, 0x62c96801, 0x57e54091, 0x964536fe, 0x13d3b189, 0x4afd1580, 0xeba62239, 0xb82ea667, 0xae18d43a, 0xbef04402,
                0x1942534f, 0xc54bf260, 0x3c8267f5, 0xa1020ddd, 0x112fcc8a, 0xde596266, 0xe91d0856, 0xf300c914, 0xed84478e, 0x5b65009e, 0x4764da16, 0xaf8e07a2, 0x4088dc2c,
                0x9a0cad41, 0x2c3f179b, 0xa67b83f7, 0xf27eab09, 0xdbe10e28, 0xf04c911f, 0xd1169f87, 0x8e1e4976, 0x17f57744, 0xe4f5a33f, 0x27c2e04b, 0x0b7523bd, 0x07305776,
                0xc6be7503, 0x918fa7c9, 0xaf2e2cd9, 0x82046f8e, 0xcc1c8250
        };

        validateHash32(expected, 0);
    }

    @Test
    public void testHash32WithSeed()
    {
        int[] expected = new int[] {
                0xfb177632, 0xda4d8a9f, 0xfee53a57, 0x5af3ddbb, 0x97508302, 0xb3a0ffcb, 0x76785418, 0x38e49648, 0x20ac2887, 0x0fe80a41, 0xe6af7bd1, 0xdee37fcc, 0xf434dd01,
                0x2f7ebfc0, 0x9ae1a640, 0x173108dc, 0x24e4150d, 0x973a2950, 0x5f979cc9, 0x40af1f8e, 0x2b1ce008, 0x8f6491c1, 0x36142767, 0x97cae4cf, 0x2454add1, 0x945d244c,
                0x40a3e042, 0x6c36fb02, 0xa9a66d71, 0xd94cb192, 0x6483021b, 0xe3b53316, 0xd02f7a27, 0x5faf9bd9, 0x5c698aee, 0x09a47ad6, 0x01cc2db5, 0x89a54712, 0x9f52f6b3,
                0xe29a3bbe, 0xafc50397, 0x8e57bcfd, 0x67b8699a, 0x764d8d92, 0xb81c75f3, 0x1e640952, 0x550adc9b, 0xb5d456dc, 0x8e539cb6, 0x26529f2e, 0xb9163da3, 0x7c6dc935,
                0xc66091f1, 0xfd4a2658, 0xb7b2a5d9, 0xc4712e75, 0x2e0b9e27, 0x49afe13d, 0x5ddc4811, 0x61451bb9, 0xe5696a74, 0x8639648b, 0xd2682dd7, 0x2f863493, 0xd4036320,
                0xab38b2f2, 0x2321d1a0, 0x2adc4275, 0x60b0dfee, 0x54ff7029, 0x20254933, 0x5a0dcb00, 0x40a94ea4, 0x60d023fd, 0x9278303b, 0x862caa0a, 0x72e3c526, 0x0eb2b23e,
                0x33d3be67, 0x64f8c555, 0x2c767096, 0x08f8fb30, 0x8dbdc60d, 0xbb208cb5, 0x945d477d, 0x53c46298, 0x67441817, 0x885b4351, 0x0b83c7c0, 0xa831451f, 0x9d810548,
                0x6e530be6, 0x565b504c, 0x14f73d8c, 0x5d6b30f8, 0x9eb91167, 0xa95092cc, 0xd82d1cf5, 0x4eee20fb, 0x83c29a75, 0x7c2afff8, 0x7c0c0524, 0x29fdfb72, 0x709d20a6,
                0xe753da20, 0x6a4dc7e8, 0x2d3e7676, 0xae5eb662, 0x87844290, 0x013ccfb7, 0xc56a62ea, 0x46949c15, 0x7b488193, 0x4941f481, 0x9bba35c0, 0xbaeb3fb5, 0x8b9b539f,
                0xd91dd560, 0x72769a00, 0x30b155cd, 0xd8f151fe, 0x85ad1b13, 0xfa7450fa, 0x3d8046f2, 0x9e21beb9, 0xf9b2aabb, 0xeebaa854, 0xa8ea0c39, 0x8c5859db, 0x11d6988c,
                0xbb891856, 0x2039c310, 0xe0ae62c0, 0xf784b9af, 0x56580bee, 0x70e4a632, 0x44e98dc9, 0xe76d82af, 0xacbe3d4e, 0x13106bce, 0x77f4046b, 0xd601ced1, 0xe8aa7c76,
                0xe916d020, 0xf1910de3, 0xf7060792, 0x777a823f, 0xad1cb6a6, 0x99616d90, 0x10d8eb98, 0x9812ea7f, 0x330001a8, 0xde2f95ff, 0xcb2ecf71, 0x93571196, 0x98264ba7,
                0xa2594356, 0x5c11ef8e, 0xe1d7fdf1, 0xe3b532df, 0xdd645082, 0xee44d696, 0x74ead1bb, 0x11d9d764, 0x29f1f84b, 0x15f2c437, 0x5fc38ad2, 0x82523caa, 0x89df71da,
                0x55135041, 0xa8ced1c9, 0x556607e9, 0x23f04f9d, 0x72467bc3, 0x22970034, 0xb6f34038, 0xdc7ddb1a, 0xdb7c1ed5, 0x94fccd37, 0x09ee42ab, 0xe930745d, 0x2a4ad82d,
                0xca697cf0, 0xfa279e0d, 0x0a8cb961, 0x38b2cbd1, 0x8ac482d4, 0x3d454ecc, 0x59bf939e, 0xa7b58687, 0x3faad4fb, 0x7f189e9c, 0x1e328acd, 0xdf8e7994, 0xfc255764,
                0xb02bbc74, 0x40c4c7fc, 0x6cd725a8, 0x64fefc5a, 0x739d9c18, 0xf53d615d, 0xe3ad8577, 0xb8950f3f, 0x254e6f57, 0x0bfb2cc5, 0xbbe16134, 0xb6d8e47a, 0x57c54e73,
                0xdbbd0f8a, 0x9899d3de, 0x775f1c91, 0xc7fb88aa, 0xf5f60c34, 0xc3578cf9, 0x6903f0ea, 0x87f1c460, 0xcd11509c, 0x2bec09b8, 0x1c4959d9, 0xa0fe0fcb, 0xa74bc3da,
                0x73197fe7, 0x4ec4e50b, 0x3db9767a, 0x9552c85f, 0x9f9f70eb, 0x8ef86426, 0x67aa6234, 0xeb69d903, 0xaf9fe6d7, 0xb580a982, 0x99e3a4c4, 0xb49b4449, 0x914cc8ff,
                0x4c3ae722, 0x39e2d69b, 0x9c73bf4f, 0xb0f6b6a4, 0x86e12738, 0x76cd8950, 0x8b30883e, 0x6b2558c2, 0x9aecab67, 0xd411439b, 0x01d474fa, 0x3cd8f3e2, 0x12e2423b,
                0x4584df33, 0x1a60ce68, 0x0fca952a, 0xd6c0bcc5, 0x197a441c, 0x9256797f, 0xe259d2c2, 0x5f4872c1, 0xe6704ead, 0x1c493fd7, 0x8232d068, 0xb49b9881, 0x1f9312da,
                0xd144030c, 0x7ff9ff12, 0x18df6e01, 0x81b308c0, 0xa22ce691, 0x24a4dc2b, 0xb868506a, 0xdd65e9a9, 0xe62f810b, 0x6f8a0978, 0xbb854700, 0xa406e9a6, 0x9e3e9c3e,
                0xd26de839, 0x9948be55, 0xe310141b, 0x3cd795d1, 0x1e3b3d7c, 0x7f88090c, 0x71ca1282, 0x6936aa75, 0x55b5341e, 0x36bcc1c8, 0x203b05cd, 0x22001b40, 0x5432a6e6,
                0x8463157e, 0x2420c917, 0x4999bab1, 0xf210727c, 0x373f042f, 0x9821d082, 0xc7d09ecd, 0x421b9d72, 0xefd6bdcf, 0x47e547c9, 0x3499d3e3, 0x85452b3c, 0xc451d780,
                0x012b3c02, 0x9fa234ed, 0xa9fbc74a, 0x42dff729, 0x911dfb4b, 0x6539a0d2, 0x7c2e4695, 0x7238ab8f, 0xb37eb923, 0xf02c09d1, 0x8da2f695, 0xd587ee5d, 0xb9139f99,
                0x609160b7, 0xfd9903e3, 0xa8943310, 0xe1941dc3, 0x848527b0, 0x8229fc54, 0x69402c72, 0xda722c18, 0xc91897e4, 0x492687a0, 0x166f1f3a, 0x571ad444, 0x975012e3,
                0xfee5a1ea, 0xf9b616f5, 0x32112d9b, 0x901fecaf, 0x4e51312d, 0x83166da3, 0x067df7a0, 0x382d9fe5, 0xf10bb353, 0xe8199bf5, 0x67160b19, 0xd1112322, 0x85d97e59,
                0x6ce63ad5, 0x0267099d, 0xe4af0e7e, 0xe2d70d11, 0x7b2d2581, 0x8d7c15e5, 0x5d6d20ea, 0x468efec7, 0xfce82cf0, 0x96c160ba, 0x2e954643, 0x2cb59152, 0x80201d6d,
                0xd10b3df6, 0xef4f362a, 0x46379342, 0xb1ae2e7c, 0xa2044230, 0x3c2aa60a, 0x84809d74, 0x0b9d32e1, 0xa9a2c517, 0x7e968a30, 0xa9c9d010, 0x58f3a4e7, 0x7a9ad425,
                0x076523f9, 0x43994057, 0x60c1beb0, 0x726f9834, 0x6ab75319, 0x15f73159, 0x6f5b8f83, 0xe92a26c2, 0xef9d6de0, 0xd6ad8e67, 0x0c835c16, 0x61844f73, 0x9eb3c40e,
                0x19b25979, 0x1beace0c, 0xedeb14d5, 0x98d992c1, 0x95013907, 0x3444e791, 0x1eff986f, 0x94b6fe52, 0x95b4af2c, 0x2d4f49d8, 0xae5fe1fe, 0x2d47532a, 0x4a5f1893,
                0x26daa303, 0x171aa8c8, 0xfeefb890, 0x7efda8e9, 0x23585d18, 0xc39cda60, 0xa5b3bcdc, 0x2d22b0c0, 0x226b7f65, 0x832ee309, 0xcc085b00, 0x89bc0f0a, 0xc01dfe82,
                0xe6fc335f, 0x170ce4cc, 0xd5b22d36, 0x75366483, 0x8faf85c7, 0xb45f44d5, 0x70d04dab, 0xb8bf750c, 0x7f7685ce, 0x75df3a2a, 0xd8c89181, 0x84d94245, 0x4f1aeb93,
                0x8600fa3f, 0xceb47945, 0xbceef461, 0x9e1c7ca0, 0xea0cd1eb, 0xc1adb42c, 0x7f074ca7, 0x68d39968, 0x104e3641, 0x8b1f8377, 0xe03df20e, 0x1daede80, 0xd90a2636,
                0xfb125fc1, 0x31a893c7, 0x29974d98, 0x15be022c, 0x5ee14b15, 0xab6c2f74, 0x79ae2e00, 0x4bd5dc38, 0x486f17be, 0x03020ef8, 0x6febdcf1, 0xfd306a58, 0x27276982,
                0x99c563c7, 0xfc93bf99, 0x594cd36c, 0xb53878fd, 0x82e57a13, 0x27393fb7, 0xe1cb44db, 0x0940f966, 0xb52e7d1f, 0x68bff38f, 0x364cb948, 0x17555dda, 0xf5cdafb4,
                0xe910cc8e, 0xd9473c96, 0x1d8305c5, 0x1b70bb92, 0x3143a733, 0xe06de52f, 0x3ad84b9c, 0x9e5ddbbb, 0x88fe7064, 0x23741b7c, 0x7dfdb906, 0x4d3f332d, 0x225362f0,
                0xcd5755e9, 0xab6d2e7b, 0x9640053d, 0x370cfde0, 0xf7e30abd, 0x862a5736, 0x12bff052, 0x729512f9, 0x0cad3b3e, 0x1abd381d, 0x49d17b62, 0x616549c2, 0xfa7c1883,
                0x3c2d11ca, 0x467d4fb2, 0xf14b6390, 0xedcbddb6, 0x4d614615, 0xbcb2ed21, 0x6b13e6fa, 0xc501a1fc, 0x24292c27, 0x6f1a5c48, 0xbbb2fc68, 0x8a6769a9, 0x6b6ba3cf,
                0xdc124fca, 0x39db8da2, 0xb37e7d50, 0x93c21edf, 0x18000b7e, 0x5331e90d, 0x687b8c93, 0xca90a4f4, 0xfa7f102c, 0x1d2fd68c, 0x65afb511, 0xa07cbd8d, 0xba215df2,
                0x1454ce74, 0x1322a968, 0x7c1dc707, 0x3c70037d, 0xb91abd3b
        };

        validateHash32(expected, -91085370);
    }

    @Test
    public void testHash64()
    {
        long[] expected = new long[] {
                0x232706fc6bf50919L, 0xa3bf77d970de1d26L, 0x46bb8f57a2b37298L, 0x9451e1c935bc5fbfL, 0x4dae92af8223b279L, 0x5d7d79cd5bcb315eL, 0x1571db5353fe88a1L,
                0x1db2ef15f9f1a233L, 0x65314472ee193982L, 0x4a11d26e54f86f29L, 0xce0a42b1c8772d36L, 0xaca7c8509ed60886L, 0xa8f791b35f23d1daL, 0x8bbb937f1ed9f474L,
                0x3ca0977ff2ef0c89L, 0x68e09c3383ec01f9L, 0x8d4789b8f274736cL, 0x2f996eab7e9ac0dfL, 0xd253e043c7aed250L, 0x74e26e30b1015811L, 0x576f8c30e23470f5L,
                0x3680a30748ac20c4L, 0xf5eb0fafe2ab3cd5L, 0xb6eda0ce608f8363L, 0x99906c52d0639e68L, 0x9d8103bac4e8e7abL, 0xe229e4b8863c7c5bL, 0x8eff68634ea63579L,
                0xbcd45e7f99ae8622L, 0x9f79bdab170c658bL, 0x4b199abb149ba493L, 0xf99c41b7027bca7cL, 0x8382f14fe5cfc8b6L, 0x423ca0e2ce01d9d7L, 0xc40137ee11103330L,
                0x61ba1bc75d1f5ed4L, 0xbe0cf2e6ca720ecbL, 0x5511eb0cef408aecL, 0x202b87f4733b90ecL, 0x02c2865b855737a6L, 0xe17837629856c65fL, 0x14f19e89647411f7L,
                0x7d30437550777c74L, 0x023c13f5f0f1a8b7L, 0x27def0ca9d7e55a5L, 0xbc8381e1c68dd371L, 0x68344b71fc1af2ccL, 0x9429e36775728d0aL, 0x39abf3dd390e5fdcL,
                0x0aaf66fbf389b84cL, 0xd366630bfb0ccf23L, 0x524297bcc95bad0eL, 0xf2fa00a45b1cb85aL, 0x96a7cf526bdae14fL, 0xe0d9c1836deb4626L, 0x4429b16f93047034L,
                0x120a211f6f3266c6L, 0x4a962445f529c3bdL, 0x5c67beae396322e7L, 0xa82873023777d042L, 0x03b83b671cd6a5a2L, 0xb1dcccb4197b402eL, 0x5e1c6420c28d0d2bL,
                0x80b5f47809c1afb4L, 0xa9833e20069c8bb7L, 0x9ddf04f36f9d4e1eL, 0x68d24600d2621b5cL, 0xb22dd0acea68108dL, 0x06742c758660cb8fL, 0x8872690fd61e6de6L,
                0xb596349e7fba15c7L, 0xad82c2f7aacfaa97L, 0x79a2a1fadb381902L, 0x17ddc77e4ea22649L, 0xfb3f95ce5d414a1eL, 0x871bb9fbc3fc5984L, 0x3d02e67da0fc9e10L,
                0x2e3250a2347dc51cL, 0x0493236437545fb6L, 0x1bac57f18c84b26bL, 0xe5ca2e1cf57efa5dL, 0x73590c9356afaf16L, 0xf17c378bb6e1eb94L, 0x0c608a799218536aL,
                0x238e6aefe3cc4967L, 0x863fc11cd3275ef4L, 0x42268b66ea63536eL, 0xe753905b6086e499L, 0x956f0569accadce7L, 0x77fda8c9b0290d82L, 0x2bc2139a4ebfd0d6L,
                0xf8b1ba1246ccc185L, 0x55445a7e2eeb10d3L, 0x0535e9eb474e3c8cL, 0x8d88bb6923c84aeeL, 0x792b56723abae1cbL, 0x37d30c651499b81aL, 0xd0d4c35da2993951L,
                0x7266f3e6eed176adL, 0x545aa155dfcfe84cL, 0xd9368b96de4a961fL, 0x0ce877484af13fe6L, 0xaf170b6be0069c42L, 0xdc3fc1a9c14de8f5L, 0x5aad043a6e02ce8fL,
                0x60b7932890d19f7fL, 0xb46aa102bca4a484L, 0xc731f1ebd4efdd63L, 0xbb261e48780fd504L, 0x5695385be80310e3L, 0x83c40d7803abbc12L, 0x7325be6d90023849L,
                0x8327c811d6f6fb84L, 0x3089180bd6b354c5L, 0xadc2867b5b8575f0L, 0x9ec4f60a758f14e4L, 0xebf0ccc3450de862L, 0x47e17e0790704afbL, 0x6a13090047209a33L,
                0x2c4b051cf226b726L, 0x4f348360f858dab8L, 0x142a631b7c0d6de9L, 0x419591fdb05ce777L, 0x49e6501cee5ff2d4L, 0xc8d8644e7acb6d5cL, 0x93ef353e2d663f85L,
                0xcb8085f641c72a91L, 0x56f4b50e82356bf2L, 0xfd8efb8c94e948ecL, 0x06024704d358d448L, 0x902b4809eca7814dL, 0x71199c2f78cd7950L, 0x0d4176b7d6097277L,
                0x774748b997782a5dL, 0xd2e2b0c5f43fc6f4L, 0x87133126105f0a38L, 0xcb09045e9e170082L, 0xcbee01ba4bfe566bL, 0xafa8d98a4371d25fL, 0xed6f8c7aef25a364L,
                0x76c6a15d698eb672L, 0x9616b59d74f850e4L, 0x05b4264a4678ff99L, 0x6ac9d9144a290dc6L, 0x38af3b2b3918f07cL, 0x1cdf6bf132c7d9cdL, 0x32b7f8f59f28e0afL,
                0x7838ca620d3c5a86L, 0x44672ee57bfc8a45L, 0x266ed382ddf0c7e1L, 0xfe25bfc1deacb86bL, 0xacbb14d7970b3c5cL, 0x2b4145095e29e199L, 0x07a2590fea28346dL,
                0x01a7f3726b59e71bL, 0xba180624f8a8a46aL, 0xc8e0f7b3862f6ce4L, 0x003a30163ccb740bL, 0x934195f608761e9eL, 0x9783e971bfa01e5fL, 0xb94b69b2f17cfa14L,
                0x25b68e432dbf99fbL, 0x49e4a7157a0be420L, 0x127c72be06137517L, 0x7913ea84e020b266L, 0xd0dbe3fcd25bfc61L, 0x71abfe7bff10ed00L, 0x1df6e05b42e6be8bL,
                0x631ebb1c029ef587L, 0x59a05cc6683b26e0L, 0x88d645d8b08afc70L, 0x3a662d917c1fd59eL, 0xca13603abaae9a70L, 0xcda8c28698c8c801L, 0x3fa7e501b6e35a26L,
                0x25701ccf57083971L, 0x8c8d0d9b90a6a680L, 0x0aa7a9611b44169eL, 0x442ebf271dce237cL, 0x54e3f879518e0a59L, 0x604435bcccb11358L, 0xd54083487b8175fbL,
                0x696713c5b8fe701aL, 0x911df04110d259bbL, 0x1b5131c3e806ce10L, 0xe30088889212be79L, 0xbb2054c34604ae7bL, 0x058c29c67fa22a84L, 0xe875379ae715b13aL,
                0x794d8a380394c3b2L, 0xda45f72511efbbaeL, 0x57067b56e13d9e19L, 0x246ed6ee77e012bdL, 0x2cc90c582d05114cL, 0xdd006304aecf2dddL, 0x0e306c64b2a2b4aaL,
                0x13a96f9cb9429546L, 0xd542154755dce815L, 0x58bfcf68c89138f8L, 0xc88af6d446dcae20L, 0x60a579a81f6f7162L, 0xf36d48cc0c557ebcL, 0x59f359535b996932L,
                0x51ac3844afbbe7e2L, 0xde47f2edd2bd5f62L, 0xaafd7953ff475b9fL, 0xc2c390e09cec7108L, 0x1622c15eeaddcffbL, 0x4b8bd9d15d751aefL, 0xc8bc0cfef68f7bdfL,
                0x89835b3df3f4e246L, 0xc18216b100983fcdL, 0x451a7abe00bc82bbL, 0x4e24dbebbf5fd3e7L, 0x51f9195fe80c7e2cL, 0x5b34fe79187d8b1fL, 0xfd698fb0efafb9a7L,
                0x112317fd8f27a148L, 0xa1bdb3b85c9606a9L, 0x355b2291f2d2be3eL, 0x424a05d7e992d13aL, 0xffe657ade4bcd152L, 0x3ca1405dce40b436L, 0x2dc8068663d6a1fcL,
                0x272d7fc2dc1455c4L, 0x499ffa5764641e39L, 0x0e73b7e5d83010c9L, 0xcdbd1e2a2d535ae0L, 0x59137aa85b748f3eL, 0x604092bbf9a9146bL, 0x57abae0880f10294L,
                0xd17fb2d72859acd4L, 0x103048275fc846daL, 0x171646e256d190e9L, 0x88a133a682167225L, 0xc8c01c4d98e4dabaL, 0x70d732fabf7865f3L, 0x0a657f4f00da7ae4L,
                0x419b22eb9b7cd126L, 0x1826a034644172f8L, 0x6060c694de40c78fL, 0x6ce6f751e8803efcL, 0x99529da1dd331a2bL, 0x442ee84648485c3cL, 0x08e2cfe64ed01ddcL,
                0x478eb5ea9c0b2d9eL, 0x53ec0155b1c6e9d7L, 0x017ec9fbd797d43cL, 0x84f86a84274101ffL, 0x61ea59bb3bf7e127L, 0x3ca34b6c91ebbc56L, 0x5b3270257ffeb321L,
                0x54389f924d42096fL, 0x579336b9d6e9456aL, 0x18a8a95b0bade318L, 0xe45ac5f92f40ee0bL, 0x5e31555038cebf03L, 0xbec984b30cbc2e72L, 0x678f8841bf03e704L,
                0x5472bd947b3e7a9aL, 0xc67decde8e985acdL, 0x3bb4e2ac90917617L, 0xac7a5604413895f8L, 0x12ad5ef0f11dde04L, 0x7ac5579cc66f8244L, 0x52fa4c47e5648174L,
                0xe0b706c56c420271L, 0x773f03e42469d463L, 0xb3ad04972540b033L, 0x8f9802ecdc788e7bL, 0x93900c44e4140dedL, 0xfecbc9390990630aL, 0x373d25afa54abed4L,
                0xf68467576e124829L, 0x00001842d940155aL, 0x6886e95b1c8836f6L, 0x701acba938fda06cL, 0x2e003b165207ab69L, 0x6b2630f1f8be9342L, 0x0002856d774882a8L,
                0x2742841956fc0d7eL, 0x6b7012d953a99d6eL, 0x0c2cd9d08241f634L, 0xea409b489490954dL, 0xb760cac9447130aaL, 0xc28f04cf8cc4a81fL, 0x9aa33c100868ec83L,
                0xae8b1714c22c642dL, 0x4371099947880140L, 0x610e479efbff3becL, 0xfedecc620f531f41L, 0xbf332676f845a667L, 0xb0180ea208c15fb7L, 0xb479e6f61996cd81L,
                0x4c39008b86579103L, 0xcd21b32ce21dd863L, 0x5e8980f4513d7f97L, 0x86fc76833984a1f1L, 0xe5a892a9dfcdc5f4L, 0x4e5807c397766a5eL, 0x5442ec1537e2b1daL,
                0x84c67bfb41441f3fL, 0x45e8f1f8abd9ddbaL, 0x51960b8123b755a9L, 0x4727977ada937945L, 0xfaee93a8103e650eL, 0xf1f587a83eef7c8fL, 0x01431a8b2760ff8dL,
                0xef62e3462493a4cdL, 0x64b27eac1d671225L, 0x1e9413463bf4bd4cL, 0x25d03820ed6e1728L, 0x9c463f27c70e9e30L, 0x4a21e4cd4e05e529L, 0x4eb82ca7928d5aa6L,
                0x91d5ff22164d0220L, 0x676563f6b5184306L, 0x313e73234bd7efb3L, 0xd5f0da1563830f11L, 0xb94c9ffdf3a1526cL, 0x60636187f1545450L, 0x0f874de6d41d5df5L,
                0x21ae44a525a5060dL, 0x7a728eef77b368daL, 0xb56fb7364fe33c7eL, 0x44dfe48aeae09021L, 0x6c731903fdb053c4L, 0x115b33792930f18dL, 0x7702eb15d37109ffL,
                0x36118e4a8511a781L, 0x51897d6fc7e7cdd7L, 0x4f8c310a6aeabc45L, 0x45f997c9ebbeaeaaL, 0x0dcdc2209a0c4f11L, 0xf9f57be1da252cbbL, 0x47b53ab35b248f41L,
                0x6c478c875223b5ebL, 0xf30873e1e32ab782L, 0x668bf6ed8e6a1c97L, 0x0ac8c49a11d3f454L, 0xcc9736a43e05bd16L, 0x83236c2f0059001dL, 0x53223253ce13ac97L,
                0x0f31b1caf83b2b4cL, 0x3d4c6df471db5c9aL, 0x76804461dc8655a6L, 0xa31aafea9e98597bL, 0x1127493c3fcae0a2L, 0x6185d65e75e63ccdL, 0x9defbc89076c72dfL,
                0x4cead7f34754c6adL, 0xfb1b508f26b5627bL, 0x24a57b98d818c697L, 0x322aee35998d5f3dL, 0xe8ffc323e94fc7b2L, 0x9421f40a1f49ad1aL, 0xa96a90bdca7ff4eaL,
                0x190431d19fe72c05L, 0x56cbcdbbfbd0cbbfL, 0x3ac3ed39b0388cebL, 0x037d1fc9b76031e3L, 0x63f9535dd0f53973L, 0x2b8c2d6dfb17907cL, 0xffa8c882a4c4c10fL,
                0xe13a333f9f2d8af9L, 0xa8e5c88eca0e56b0L, 0xe1f36f71b0d9b689L, 0x2652a617fcbf37a3L, 0xf44482bdfede8f7dL, 0x642f0ef9f836511cL, 0x7001e31e744003fcL,
                0x3ea8edb889eba576L, 0x15515126cfdcf6a6L, 0x779d0c8dc2007f52L, 0xd753d24aaaaf683fL, 0x6c75431162d2f9caL, 0x070ace20c996f77fL, 0x9eac95d777a7b5b3L,
                0x92b175238ba7d0a4L, 0xffefc29cef6a0819L, 0xf29a8950a0d903c0L, 0x1f22635901b27431L, 0x603b2be058fffd4cL, 0x8f58873f4827f45cL, 0x15c74e1944eb5634L,
                0x1ea5ec4cae70edfcL, 0xa3973eec591c740bL, 0x97cf2290478bf338L, 0xc20745ab2f3b513bL, 0x0db7f22b67bf518eL, 0x55244a456fef4a0cL, 0xe7fdbcba1e0b6917L,
                0x78a3a6de5ac0edc5L, 0xb315b8062e328498L, 0x6ec2dc80077de7d5L, 0xd2bcef2a5726020bL, 0xbbf8a6a52aeda888L, 0xb1f4c97945b637caL, 0x42d7b719cf60858dL,
                0x860f14df3dc91ae2L, 0xeb92085d3e6d5294L, 0x03c72354e6900d39L, 0xb39e21210f634c71L, 0x8c064a7f827a5fa4L, 0x2a8bdc27c713994bL, 0x7e60fbd91c363494L,
                0xaa43ab0d3d43b615L, 0x0605f962e5fe7d15L, 0x1cb9dc98f6ada4f2L, 0x1a166f6a472099d5L, 0x5c551a6004360d39L, 0x4d7e115b7f2a71d0L, 0x06d46fd088a4f5ffL,
                0x14ff44be2c28fac5L, 0x10e5fd9e4cd64801L, 0xafdf3a86fd78dd33L, 0x7daa40a7c9bdd233L, 0xc196af9c21e266ccL, 0x69cc16629bbf419dL, 0xa45f0d4acbf7d81dL,
                0x31f26b1080f15f96L, 0x3a6e1c9a04242657L, 0xa086da0453fb0f66L, 0x9abebad9ded11e46L, 0xde4b47e7f2fdba97L, 0x708ba83d8d45c9f1L, 0x294291994eeae802L,
                0x7bd9106d17003659L, 0xb9fc9762b9db81a7L, 0x8c2543e0e734b1b2L, 0xbf214bc79503c54eL, 0xda64ec67b7c77c3eL, 0x4f39a472271dd0abL, 0xb1891cf6d8b906b5L,
                0xdebc0d6e0d540ec6L, 0x19d725def03b86e0L, 0xe39955820fdb7d18L, 0xc1150a4995e261afL, 0xd257bb64ad9ec04eL, 0x6acea384381f4a64L, 0xc050d087fec798d7L,
                0xbc088de909ea20beL, 0xb5b7143e0ef4ca57L, 0xdb2549161e6195bbL, 0x4cfa16f6fd0da78bL, 0x0b2233ffcea1653bL, 0xafb1ec37157d9777L, 0x216c4a1ef04af50fL,
                0xeceb3651ad7baa23L, 0x226720bad181714aL, 0x158fbbf29bbdab78L, 0x62018c546c7d1577L, 0x05d3dcef645eb1e7L, 0xb6dc976ea0648264L, 0x100753ec35839ca6L,
                0x994062e72287ef45L, 0x3061715c32a64ca3L, 0x0986792526111f6fL, 0x47333c4564814946L, 0x256aa973b0cddaf1L, 0x449a873e4351c59eL, 0x74d26f4b1b30471cL,
                0x059aa806b970788aL, 0xf776569430e9f597L, 0x88dd1e1bd7e58df1L, 0x6bb76146c6d2b953L, 0x6dc2a1d5f5f37cf4L, 0xbb231ec43d7c419eL, 0x1516f7e5f91ecb2dL,
                0xcf75daf79c87fd5dL, 0x05d319fab22384ceL, 0x516d57fe8c7ac51cL, 0xfcba48d562c96801L, 0xca87ab7e57e54091L, 0x7499fc4f964536feL, 0x0c09437813d3b189L,
                0x4a9070084afd1580L, 0x072f87dbeba62239L, 0x53add40cb82ea667L, 0x9a89888eae18d43aL, 0xb1b0933abef04402L, 0x9ca3400b1942534fL, 0x850b21e0c54bf260L,
                0xefda6c573c8267f5L, 0xc9095e25a1020dddL, 0x1347e7d2112fcc8aL, 0x9ad1b487de596266L, 0x9c145758e91d0856L, 0xfc71ffccf300c914L, 0xd3dad04ced84478eL,
                0xa5d953355b65009eL, 0x2bbde4be4764da16L, 0x125b5639af8e07a2L, 0xa247dd4c4088dc2cL, 0x620f83cd9a0cad41L, 0x7250533d2c3f179bL, 0xa96f747ba67b83f7L,
                0xdacfb135f27eab09L, 0x85070b18dbe10e28L, 0x179941d2f04c911fL, 0x14b28c74d1169f87L, 0x156af1048e1e4976L, 0xfeadb09a17f57744L, 0xb354e598e4f5a33fL,
                0x1dde4d3727c2e04bL, 0xec539a9d0b7523bdL, 0x51a13c7107305776L, 0x59d5d03ac6be7503L, 0x5d2e6ba4918fa7c9L, 0x0ddc087eaf2e2cd9L, 0x2761838882046f8eL,
                0x7195ceb7cc1c8250L
        };

        validateHash64(expected, 0);
    }

    @Test
    public void testHash64WithSeed()
    {
        long[] expected = new long[] {
                0x405135088e86fd8aL, 0xa93b1ca7a5a43df9L, 0xb2d39a5371ed9b62L, 0x66f3ec93f69a8476L, 0x470c73c05cd6c91eL, 0x5982b5ed6ce02008L, 0x694ea23a13a62c37L,
                0xe98beac911ac4c8bL, 0x21e68706a7086877L, 0x8e92bf9e6a6855f4L, 0xaa3679a4aae226f3L, 0x9f0616570da4532bL, 0xcabecd7735c9ee75L, 0xe9187214bade4dccL,
                0xb8c20e7cb4a887bdL, 0x0508eb5faaf62520L, 0xf55c0cbeb6330ff2L, 0x4035ca044c7e5277L, 0x5ed901825365c2f8L, 0x2270a1c85208b8ccL, 0xafe0a7c5008f8c1aL,
                0xab2b338168c16c44L, 0x253119adfbebec26L, 0x7cc6337b53ef7e9bL, 0x335570998e70a6b3L, 0xf92fa77d74f23358L, 0x1f0d3aede3551877L, 0x01cf9e038a8c89f6L,
                0xa7206c624f277be6L, 0xfa5404a40eeadfa3L, 0x83048b8ad7653d63L, 0xfbcb57e4bbf126c7L, 0x20cc07081ea31ac3L, 0xde1f1180fba0ea12L, 0x1b89bcf2ece5b689L,
                0xc25222dcfeef4eb3L, 0xcd3a15ba1452e2d8L, 0x8b7c089a1f42e54bL, 0xde89a0b5041c878eL, 0xe6e17aae1f9bebe1L, 0x2dd8cac622a1569dL, 0x46c33ad73c2978c2L,
                0xed4838de31d03155L, 0x09c1218d1f9ad7f4L, 0x4f20b72cc6a5f16bL, 0x9ac6205bf1b387a4L, 0x6bcc38a7cc4725f2L, 0xbaca085f4e9b95eeL, 0xb79b6acdfc04d741L,
                0xbe94fba90f2f62bfL, 0x992254963f92a56eL, 0x132dfe55f2e9d447L, 0xc69ed8eda97f5213L, 0xdf8aab21415ca7c2L, 0x678a40344f8ab17cL, 0x4c026d3129a37b51L,
                0xe5fba1210b60cddbL, 0x13af9e2b094f4fdbL, 0x6c8e683d8ce32fedL, 0x5bd20bf89131bcacL, 0xd5fd16f70f79dcbeL, 0x49165db707bf6972L, 0xa9f543bac0513ae1L,
                0xf66e0f27c9975155L, 0x277f8592b2b13ab6L, 0x0f1e8f5f99b7d73bL, 0x6d27c8c2a101316aL, 0x3329f55c46245f4dL, 0x0d331afcefe23dc8L, 0x975c577ef80bd39fL,
                0xad0ac87c7e35fddbL, 0xdae1248bf8e87427L, 0xb3695cf5def13dbdL, 0x4b774e99d95ea70aL, 0xd40b7fd3b45f8fecL, 0xa654e3a6c8a531d2L, 0x0849f0a509b9d362L,
                0xf2319bfa20647690L, 0xca360dfd5947d3c5L, 0x0605c380057be141L, 0x3095256605acde82L, 0x70103681accb1952L, 0xe5ee93393dafeb68L, 0x252da82daf1ee866L,
                0xa6bbc68016e6ac4cL, 0x2986eb8f69b918d3L, 0x4bcedf42ff377889L, 0x6550f5fa4f7dd995L, 0x0a636254297f0a30L, 0x37db59eb8a6bbbf5L, 0xa2358e527c632ea1L,
                0x449cdbc7058d53a7L, 0x49d17346b9ecfaa2L, 0xfce93dba08faddf4L, 0xf7a1d8e2d62187dfL, 0x9be8a196d64b1f58L, 0x79e8b917963e8d3cL, 0x53f947f88bf7f370L,
                0x5381cd574d6cd4f5L, 0x4ba653381bdc5d4eL, 0xaec9d5820ad489b0L, 0x60d2631d18671579L, 0xae617f09c5e0583bL, 0x4412738940b61659L, 0xc1c58971c74e3758L,
                0x1310377be8531b44L, 0x1acae56bdb0645ceL, 0x954d056efd8ff1d3L, 0x9120ec77e463ebcaL, 0x7996b0a29f955774L, 0x8ebd340f0039a312L, 0xdfc878fc7a295a63L,
                0x4728323031bd5808L, 0x0bf804d9a83e8df2L, 0x2d91fe6532d78607L, 0x7757e8c3093c9a76L, 0x0fdd8cc2c17adbaaL, 0x582a68be4815a0d0L, 0x456174a64cfe505bL,
                0x8888ff4be95514b5L, 0x6bafdc9b3a929963L, 0x011ce6f86abb42fbL, 0x795c9449155d1398L, 0xfa911e109841e39bL, 0x29321ba184e632baL, 0xa4fe971480e4996dL,
                0x2f6bff6378a73924L, 0xbdcab4a1739bc227L, 0x0a69245abc894edeL, 0x00c30421eb96235bL, 0x48f74858795fa856L, 0x6ded1b375acb62abL, 0x485cf309e60917a1L,
                0xd3dcb88a7743cf58L, 0xb58957981a22c977L, 0xbc95844346353d8bL, 0xbda513e50a9413d7L, 0x048ddc1d290491cbL, 0x537e0dc3e4093353L, 0x3ee3dcfe087a191eL,
                0xe6121a3313046febL, 0xa7bab536815ae112L, 0xcb11205e20516ccaL, 0x2218df4017919cdbL, 0xd905f98441ae0902L, 0x53eee3396cb6d277L, 0xd2c7d1c8248dc270L,
                0x5a97939e4edceda2L, 0xe233cb90a648ed93L, 0x6186be8da78b4eddL, 0xfe421643103587a1L, 0xb57d106eb14cf093L, 0xe7ff7cf4b667dee8L, 0x1f1cb8b227597ca0L,
                0x2e5a4af946af93a9L, 0x89ca5a7084760523L, 0xa7ee7b57b2b2318cL, 0xe44fec574dd564f4L, 0x683ba005c15c2bbbL, 0xfb6bd6e1acd630bfL, 0x91bdc2f695a34590L,
                0xf61f41c2b79baf1fL, 0xde47143ebda5c7e9L, 0x8bdf945faac6d181L, 0x827c53a6137f8589L, 0xfa2e4924c0db94bcL, 0x4f8176d46c670caaL, 0x714b490d30ea97e4L,
                0x7893d9ee140f5683L, 0xf2234bc767d9923aL, 0x4bdd900a12eaf533L, 0xde718553559be2f0L, 0x0ff5805b47d22937L, 0x712db5b93d1acc1bL, 0xd99787cfa0c5a4abL,
                0x687f9767024d05f6L, 0x34a92204fbdf03f5L, 0xd42eec72d50ffb3cL, 0xb95a44777dd0d2c4L, 0xf74533930d6f96ebL, 0xbe71f1e17d4bb247L, 0x891cc2eca848f736L,
                0x34bb56f9984163a5L, 0x772079540a219603L, 0xcaac08abc5092875L, 0x3df18ed44d21282fL, 0xf1b5fb96c5b831bcL, 0x620df8551429dde1L, 0x341d1476d22dd433L,
                0x1d388ba41793f62fL, 0x050217151f4eca2bL, 0x8a1dba84505643bdL, 0xff3b4bd61d1b8806L, 0x64a117838691a327L, 0x46b3985c44ff6619L, 0x7a638a468cd970e6L,
                0x2e4b21b98aa380e2L, 0x0ee3cb69f9cb2cf9L, 0x4d475de422b370edL, 0x33aa28235ad0811dL, 0x4edaf04cebeaca43L, 0xeff6ef0933e5958dL, 0xdd516d11571c0901L,
                0x0fa07e7705517c0aL, 0x30b866843292525bL, 0x136bd17527653d57L, 0x52a2ef03ce45aeb2L, 0x88e14596796d2726L, 0x5b5976f8b24cc37bL, 0x1d52ad2efcd90254L,
                0xa9723762362ce2e2L, 0x1b983da2b80947e2L, 0x396850dd1c99c2b2L, 0x3dca11ff35d2b457L, 0xa08b0e4de87759dcL, 0x69eeffe9087bc0c2L, 0xcbee609f2945a223L,
                0x0b03aadeac456518L, 0xf6ec002eb9b1fb4aL, 0xf5726927f55b56c8L, 0x138767de554a8fc7L, 0xa20eaf414f6eca69L, 0xe02084dd532cbdf5L, 0x996c98498e7cd119L,
                0x6d1ae742faa975b6L, 0xc35b1950119d73f8L, 0x3bee8789cbe7427eL, 0x9be2f29b68ae73bbL, 0x4854326878aeb72fL, 0xc38991fd67c92a72L, 0x0f65b647a3ffc827L,
                0x3ee8b40cf01f090bL, 0x601ece4d6f6e8739L, 0x9a1586912bc57c72L, 0xa771270cbda85818L, 0x6f5a0fa7f555025bL, 0xb2ba3eecb4e0f9f4L, 0x5ae9ca91dc97e441L,
                0xff8bb82cae35fabcL, 0xf71aa1996ed611d6L, 0x4899826f23b9ae8dL, 0x3eab1cbe7d2f618bL, 0xb83ef13bcc6f7f58L, 0xec947b9ff4ce2ed1L, 0xb2ba6032743daa69L,
                0xd80d9d4ce9a071ffL, 0x7bb0e37df18a22e1L, 0x35e607b64be359d5L, 0xa9a9f25a2a119cbcL, 0xf659daefc937fcadL, 0xdbf7433392a85836L, 0x39657f28d4ccaf79L,
                0xe035a4637cb22d38L, 0xe78f5047c301ead3L, 0x18b83d1e24f1e558L, 0x67a60dc9bb81c11cL, 0xa8ccad3195b8145aL, 0xf0c072ef2c107d13L, 0x64ed65047f5ab714L,
                0x98ff8c22cca7fc52L, 0x58c0cc5bff75a096L, 0x979f488ae90e9552L, 0x81afd0dd0c0cb3faL, 0x94bbb39508331604L, 0x8cb941ab1465ded2L, 0xd449564bc35a57f7L,
                0xa2078cbeede0f03fL, 0x99d92e01b20718c2L, 0x095041c7f66e2fd8L, 0xe51c584207c0d0c4L, 0x6e6995afcef793e8L, 0x4fc4697dd97d4168L, 0x4bc5725e34e0be67L,
                0xbe920670343aca15L, 0x7ed7cb936b052010L, 0xdb394067f136122dL, 0x00e4c2440cc2c281L, 0xf7daedd5109493d3L, 0xea5335e4c78c00a8L, 0x4c13e202dfcbbe2aL,
                0x42ae23c27fc84316L, 0x7f5fe15349f9bb53L, 0x28b3e8d406ae16ecL, 0xef1859ceae34eec9L, 0x0eb5f6d9e13f1191L, 0x1c854ba3a5d93fd7L, 0x59333e67e60828b6L,
                0x657fe68e0419c23dL, 0x108b290610c3aabcL, 0xf97c051edc7c383bL, 0xc42f3343d9470d1bL, 0xf297bc7b72f54a55L, 0xe4d434fe50c86cd2L, 0x711e06129dd241b4L,
                0x0144f32dbc325d3eL, 0x23f92f288fc43127L, 0x03a26bd7d380ed3bL, 0xab66ca31ba6c4886L, 0x3dfa803ef0f2602bL, 0x73b244e21e1b3fd7L, 0xe04ec0139c935e72L,
                0xa6c8f2201d32a48bL, 0x87cb47843960a298L, 0x6f7c3953d8d7581fL, 0x2d90786e3dd6f092L, 0x9a37d063af9f12adL, 0xd55772d4caeb3f19L, 0x92848ed8288ecd0dL,
                0x38965d5cca923cf5L, 0xef8e49c3e4c7f8a5L, 0xd8727f55f4a6328cL, 0xf065a71bf8321dbeL, 0x8cb73e4b42c5db8eL, 0xc23a044b2f5601ddL, 0x82f2d2b1637b5d75L,
                0xe16370f07125d153L, 0xbff70b0629c41245L, 0xd467347eaf44edbeL, 0xf37df9ce33805b69L, 0x777a371f0352a371L, 0x033e6d07eebeb795L, 0x33f50c8d228e3b5dL,
                0x24907b74729c1c1fL, 0xec7e8ba6f9039571L, 0x9fb9e19e73814b74L, 0xebcd995bafd6f5e9L, 0x030f81d116a02c00L, 0x36d062a80e4a97ccL, 0x96c6ef6e56394ec4L,
                0x35f5a4549fe21a82L, 0x74fe636c13cefb64L, 0x7a7e3d666738895cL, 0x2ef7c6c2a19d8f19L, 0xc8d25283f8f5cf15L, 0x0f1b57dcef11c9fdL, 0xf6095c68461604e0L,
                0xc75de22497b7f887L, 0xbf0aa48cde19f4e7L, 0x1229ebec749b9ee5L, 0x0bea2e86ea1e43c0L, 0x085078f4bcd251e1L, 0x3f041b843811107bL, 0xcf2a81784d3144d4L,
                0x106af31f5dfb2fd0L, 0x371832b647c8a145L, 0x9a32d9347515348dL, 0x7f5cb245915be232L, 0x2ced0ab8ac84ec30L, 0x3049e12172578cfeL, 0x795bd6d4bee5c572L,
                0x0c195fa5d52a5dbcL, 0x8a93d2fc6b816be4L, 0x1939317913ef8a82L, 0x816d88c7311fddb8L, 0xe161780b05639c32L, 0x5957f02484b8c745L, 0xf35e8a447568b322L,
                0xd171a2b7c2892e8aL, 0x2e5a8053b866c259L, 0xd3b84dc73c9f38d8L, 0x87b7fcf9833bc0eaL, 0x33ea0b8b0c7ed266L, 0x12c2ab0e12e36fc0L, 0x1e90604ecd3e645dL,
                0xf4c920454d46a90aL, 0x0fe2643d38ff6eb6L, 0x102859cce4785e70L, 0xc48ee9dd4b169f2dL, 0xd0e527b2a7aaef51L, 0x998934af608ce1caL, 0xf4d26213dd5637c4L,
                0x72c86a627784975aL, 0x3dd71408e45e3f63L, 0xb6710ac2bebddc17L, 0xf94fc422cd4f4341L, 0xd259cb6b305dfd80L, 0xff0f3a83b3bf9f2aL, 0xee9e4bd6f911baeaL,
                0x60ebf087b089032cL, 0xd36088800450ec9eL, 0x2af986499f1d61efL, 0x9b771551aa270f84L, 0x66710dd5e2139b2cL, 0x90c6e13a7b3e1afdL, 0x3e80594c04fcca49L,
                0x9e7983e854aef34eL, 0xb6024417de06274bL, 0x21b954585ac26d91L, 0xa8226928d63170beL, 0xf8958d22dda98320L, 0x07bb09df70c881bbL, 0xc970b7bfd87921e8L,
                0x16f245e59145d4d3L, 0x94195f0174a2691eL, 0x0e6255ec353421b1L, 0x614a3069058b7f42L, 0x2e87d446be4808eaL, 0xa0dbb88708062434L, 0x2c88cfb2e537d98dL,
                0xa39498ae9c43f7daL, 0xd2fc508be8800572L, 0xe10d567857dbcd87L, 0xf94fd25557e4da9bL, 0xe1c5af547ecd227eL, 0x626b165a11e1ffe5L, 0x49d0d1e1abeefa13L,
                0x346f4ffe4da2dfd4L, 0xd1dd74d27489106fL, 0x32cff780ce44c871L, 0x27d541ffd6d5c705L, 0x4b9659b78aed0b43L, 0x9b4a152fa7e43bfcL, 0x2540a4588217a574L,
                0x4de3b456eef96f15L, 0xfe985ccc0706605eL, 0xda9bf0e4f2040faaL, 0xdb0cdaa07f33a283L, 0x3e700226a7236226L, 0x066627d028300ff5L, 0x80c5546dfdb43dc5L,
                0x415d8137f5278415L, 0xced8ab5f595c74edL, 0x8df126cd076cf1ceL, 0x67c16346b72ea1f6L, 0x771cfe5d72726557L, 0xc4aa7852cea80507L, 0xa24d9985b7e7aa48L,
                0xdc24305f247939ccL, 0xca5d453c1b129433L, 0x89cdff77e7f6c341L, 0xaccde841ebd46af5L, 0x1a66ca8fab2f2b2eL, 0x2056cf32dc1c80cfL, 0xb111e51f5606dbeaL,
                0xd2d3c22d35ccdcb7L, 0x8d0bd8854af4d15cL, 0xfba26c59e5a67c0aL, 0x0a59c4104bd5919dL, 0xde7b689b470db246L, 0xe1403fbe540256a3L, 0xe073059bb03c3a80L,
                0xb99fe54afc7890fdL, 0xdec55169909b3524L, 0x47ca35af91079022L, 0x07f281434a0a3a81L, 0xff2c574521d04006L, 0x481b31396c496b2dL, 0x53c1158e3792a9c5L,
                0x6370b298c99ceb66L, 0x6dba8d3ce8ba8ed1L, 0x4ae7aea8b6f4e2c7L, 0x3c5b2ceaaf01dbfeL, 0x7b051804a92452d5L, 0x14586edb53da5c71L, 0x0c400e3037028fc7L,
                0xb1d4ea3612a8656dL, 0xb6560a7a59b2d969L, 0x6c468ebc7098d4ecL, 0xc3874084fa933a49L, 0xf63182f2f00450b4L, 0xdb3c73c455e67319L, 0x78dd30cbe64701acL,
                0x44d2a729dc0eb63eL, 0xbab09e95f70df860L, 0x6e6df0daa9b7bd58L, 0x373cf96dfad3714eL, 0xbcf73fa3f39268a0L, 0x7bf675e19d65b312L, 0x4a489fdc9a396301L,
                0x8e4636efde6005d7L, 0x9187865c1f5755e3L, 0xe4b34287a738c0c0L, 0x1167a125dd3924d0L, 0x5d93b1c989480973L, 0x267c0861472e3f41L, 0x292627e2b8223658L,
                0x12af9c1361fd6237L, 0xc0c029db879afc65L, 0xf1d34012c299a05aL, 0x027a5ee3955eba3bL, 0xf9b9747df5e8d8f7L, 0x95cb2eb1e630f4e0L, 0xf2b00cfb429dea13L,
                0x1e20408844543367L, 0x631a373e8a3c43a5L, 0xae18edcc9d62f838L, 0xb7e0960208ddc11cL, 0x5fe15b7267c7d676L, 0xd80e78ba32b42812L, 0x20ff8c6ea3b109faL,
                0x71ae811270001fddL, 0xecdf70a01ff0d1c6L, 0x403a163c5c5dc0d1L, 0x7eee67f1e0f5bca0L, 0x049b7006bd1657e4L, 0x2af9751ca900b4caL, 0x1d9d0c6a6d5a366fL,
                0xd555ff6ceb8b23afL, 0x6375bb5391e14591L, 0xa197ffccfbc3a237L, 0x3a7830b2e7796716L, 0x57c9d47b330f9c3eL, 0x4e92c80595ff7386L, 0xc7a81c34ea5416e7L,
                0x5bdcbe3bdeb30ff1L, 0xf72f8fd563d6ec31L, 0x4ce8faa201f99c68L, 0x37e09ded33ec7236L, 0xb5d8b2f19ad0c656L, 0x7256f1c2ec925631L, 0x643178add8156330L,
                0x579709a5018f4fb1L
        };

        validateHash64(expected, -6871704374924842416L);
    }

    private void validateHash32(int[] expected, int seed)
    {
        for (int offset : Ints.asList(0, 100)) {
            Slice data = makeData(offset, expected.length);

            for (int i = 0; i < expected.length; ++i) {
                assertEquals(SpookyHashV2.hash32(data, offset, i, seed), expected[i], String.format("size: %s", i));
            }
        }
    }

    private void validateHash64(long[] expected, long seed)
    {
        for (int offset : Ints.asList(0, 100)) {
            Slice data = makeData(offset, expected.length);

            for (int i = 0; i < expected.length; ++i) {
                assertEquals(SpookyHashV2.hash64(data, offset, i, seed), expected[i], String.format("size: %s", i));
            }
        }
    }

    private Slice makeData(int start, int length)
    {
        byte[] data = new byte[start + length];
        for (int i = 0; i < length; i++) {
            data[start + i] = (byte) (i + 128);
        }
        return Slices.wrappedBuffer(data);
    }
}
