/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.JvmUtils;
import java.util.Objects;
import sun.misc.Unsafe;

public final class ByteArrays {
    private ByteArrays() {
    }

    public static short getShort(byte[] bytes, int index) {
        Objects.checkFromIndexSize(index, 2, bytes.length);
        return JvmUtils.unsafe.getShort(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static int getInt(byte[] bytes, int index) {
        Objects.checkFromIndexSize(index, 4, bytes.length);
        return JvmUtils.unsafe.getInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static long getLong(byte[] bytes, int index) {
        Objects.checkFromIndexSize(index, 8, bytes.length);
        return JvmUtils.unsafe.getLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static float getFloat(byte[] bytes, int index) {
        Objects.checkFromIndexSize(index, 4, bytes.length);
        return JvmUtils.unsafe.getFloat(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static double getDouble(byte[] bytes, int index) {
        Objects.checkFromIndexSize(index, 8, bytes.length);
        return JvmUtils.unsafe.getDouble(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static void setShort(byte[] bytes, int index, short value) {
        Objects.checkFromIndexSize(index, 2, bytes.length);
        JvmUtils.unsafe.putShort(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static void setInt(byte[] bytes, int index, int value) {
        Objects.checkFromIndexSize(index, 4, bytes.length);
        JvmUtils.unsafe.putInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static void setLong(byte[] bytes, int index, long value) {
        Objects.checkFromIndexSize(index, 8, bytes.length);
        JvmUtils.unsafe.putLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static void setFloat(byte[] bytes, int index, float value) {
        Objects.checkFromIndexSize(index, 4, bytes.length);
        JvmUtils.unsafe.putFloat(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static void setDouble(byte[] bytes, int index, double value) {
        Objects.checkFromIndexSize(index, 8, bytes.length);
        JvmUtils.unsafe.putDouble(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }
}

