/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tracetoken;

import io.airlift.tracetoken.TraceTokenManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTraceTokenManager {
    @Test
    public void testNoToken() {
        TraceTokenManager manager = new TraceTokenManager();
        Assertions.assertThat((String)manager.getCurrentRequestToken()).isNull();
    }

    @Test
    public void testCreateToken() {
        TraceTokenManager manager = new TraceTokenManager();
        String token = manager.createAndRegisterNewRequestToken();
        Assertions.assertThat((String)manager.getCurrentRequestToken()).isEqualTo(token);
        Assertions.assertThat((String)manager.getCurrentRequestToken()).isEqualTo(token);
        String token2 = manager.createAndRegisterNewRequestToken();
        Assertions.assertThat((String)manager.getCurrentRequestToken()).isEqualTo(token2);
        Assertions.assertThat((String)token2).isNotEqualTo((Object)token);
    }

    @Test
    public void testRegisterCustomToken() {
        TraceTokenManager manager = new TraceTokenManager();
        manager.registerRequestToken("abc");
        Assertions.assertThat((String)manager.getCurrentRequestToken()).isEqualTo("abc");
    }

    @Test
    public void testOverrideRequestToken() {
        TraceTokenManager manager = new TraceTokenManager();
        String oldToken = manager.createAndRegisterNewRequestToken();
        Assertions.assertThat((String)manager.getCurrentRequestToken()).isEqualTo(oldToken);
        manager.registerRequestToken("abc");
        Assertions.assertThat((String)manager.getCurrentRequestToken()).isEqualTo("abc");
    }
}

