/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.grouper;

import io.aiven.kafka.connect.common.config.TimestampSource;
import io.aiven.kafka.connect.common.grouper.RecordGrouper;
import io.aiven.kafka.connect.common.grouper.TopicPartitionRecordGrouper;
import io.aiven.kafka.connect.common.templating.Template;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.SchemaProjectorException;
import org.apache.kafka.connect.sink.SinkRecord;

final class SchemaBasedTopicPartitionRecordGrouper
extends TopicPartitionRecordGrouper {
    private final SchemaBasedRotator schemaBasedRotator = new SchemaBasedRotator();

    SchemaBasedTopicPartitionRecordGrouper(Template filenameTemplate, Integer maxRecordsPerFile, TimestampSource tsSource) {
        super(filenameTemplate, maxRecordsPerFile, tsSource);
    }

    @Override
    protected String resolveRecordKeyFor(SinkRecord record) {
        if (this.schemaBasedRotator.rotate(record)) {
            return this.generateNewRecordKey(record);
        }
        return super.resolveRecordKeyFor(record);
    }

    @Override
    public void clear() {
        this.schemaBasedRotator.clear();
        super.clear();
    }

    private static final class SchemaBasedRotator
    implements RecordGrouper.Rotator<SinkRecord> {
        private final Map<TopicPartition, KeyValueSchema> keyValueSchemas = new HashMap<TopicPartition, KeyValueSchema>();

        private SchemaBasedRotator() {
        }

        @Override
        public boolean rotate(SinkRecord record) {
            boolean schemaChanged;
            if (Objects.isNull(record.valueSchema()) || Objects.isNull(record.keySchema())) {
                throw new SchemaProjectorException("Record must have schemas for key and value");
            }
            TopicPartition tp = new TopicPartition(record.topic(), record.kafkaPartition().intValue());
            KeyValueSchema keyValueVersion = this.keyValueSchemas.computeIfAbsent(tp, ignored -> new KeyValueSchema(record.keySchema(), record.valueSchema()));
            boolean bl = schemaChanged = !keyValueVersion.keySchema.equals((Object)record.keySchema()) || !keyValueVersion.valueSchema.equals((Object)record.valueSchema());
            if (schemaChanged) {
                this.keyValueSchemas.put(tp, new KeyValueSchema(record.keySchema(), record.valueSchema()));
            }
            return schemaChanged;
        }

        void clear() {
            this.keyValueSchemas.clear();
        }

        private static class KeyValueSchema {
            final Schema keySchema;
            final Schema valueSchema;

            KeyValueSchema(Schema keySchema, Schema valueSchema) {
                this.keySchema = keySchema;
                this.valueSchema = valueSchema;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                KeyValueSchema that = (KeyValueSchema)o;
                return this.keySchema.equals((Object)that.keySchema) && this.valueSchema.equals((Object)that.valueSchema);
            }

            public int hashCode() {
                return Objects.hash(this.keySchema, this.valueSchema);
            }
        }
    }
}

