/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.config.OutputFieldType;
import io.confluent.connect.avro.AvroData;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkRecordConverter {
    private final Logger logger = LoggerFactory.getLogger(SinkRecordConverter.class);
    private final Collection<OutputField> fields;
    private final AvroData avroData;
    private final boolean envelopeEnabled;

    public SinkRecordConverter(Collection<OutputField> fields, AvroData avroData, boolean envelopeEnabled) {
        this.fields = fields;
        this.avroData = avroData;
        this.envelopeEnabled = envelopeEnabled;
    }

    public SinkRecordConverter(Collection<OutputField> fields, AvroData avroData) {
        this.fields = fields;
        this.avroData = avroData;
        this.envelopeEnabled = true;
    }

    public GenericRecord convert(SinkRecord record, Schema schema) {
        this.logger.debug("Convert record {} for schema {}", (Object)record, (Object)schema);
        return this.createRecord(schema, record);
    }

    private GenericRecord createRecord(Schema schema, SinkRecord record) {
        if (this.envelopeEnabled) {
            GenericData.Record avroRecord = new GenericData.Record(schema);
            for (OutputField f : this.fields) {
                Object fieldValue = this.getRecordValueFor(f.getFieldType(), record);
                avroRecord.put(f.getFieldType().name, fieldValue);
            }
            return avroRecord;
        }
        return this.tryUnwrapEnvelope(schema, record);
    }

    private GenericData.Record tryUnwrapEnvelope(Schema schema, SinkRecord record) {
        OutputField field = this.fields.iterator().next();
        Object fieldValue = this.getRecordValueFor(field.getFieldType(), record);
        Schema.Type originalValueSchemaType = this.avroData.fromConnectSchema(record.valueSchema()).getType();
        if (originalValueSchemaType == Schema.Type.MAP) {
            Set entries = ((Map)fieldValue).entrySet();
            GenericData.Record avroRecord = new GenericData.Record(schema);
            for (Map.Entry entry : entries) {
                avroRecord.put((String)entry.getKey(), entry.getValue());
            }
            return avroRecord;
        }
        if (originalValueSchemaType == Schema.Type.RECORD) {
            return (GenericData.Record)fieldValue;
        }
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put(field.getFieldType().name, fieldValue);
        return avroRecord;
    }

    private Object getRecordValueFor(OutputFieldType fieldType, SinkRecord record) {
        switch (fieldType) {
            case KEY: {
                return this.fromConnectData(record.keySchema(), record.key());
            }
            case VALUE: {
                return this.fromConnectData(record.valueSchema(), record.value());
            }
            case OFFSET: {
                return record.kafkaOffset();
            }
            case TIMESTAMP: {
                return record.timestamp();
            }
            case HEADERS: {
                HashMap<String, Object> headers = new HashMap<String, Object>();
                for (Header h : record.headers()) {
                    String k = h.key();
                    Object v = this.fromConnectData(h.schema(), h.value());
                    headers.put(k, v);
                }
                return headers;
            }
        }
        throw new ConnectException("Unsupported output field: " + String.valueOf((Object)fieldType));
    }

    private Object fromConnectData(org.apache.kafka.connect.data.Schema schema, Object value) {
        Object avroDataValue = this.avroData.fromConnectData(schema, value);
        if (avroDataValue instanceof NonRecordContainer) {
            return ((NonRecordContainer)avroDataValue).getValue();
        }
        return avroDataValue;
    }
}

