/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.jsonwriter;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.config.OutputFieldType;
import io.aiven.kafka.connect.common.output.jsonwriter.HeaderBuilder;
import io.aiven.kafka.connect.common.output.jsonwriter.KeyBuilder;
import io.aiven.kafka.connect.common.output.jsonwriter.OffsetBuilder;
import io.aiven.kafka.connect.common.output.jsonwriter.OutputFieldBuilder;
import io.aiven.kafka.connect.common.output.jsonwriter.TimestampBuilder;
import io.aiven.kafka.connect.common.output.jsonwriter.ValueBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.errors.ConnectException;

public class JsonOutputFieldComposer {
    public final Map<String, OutputFieldBuilder> fieldBuilders = new HashMap<String, OutputFieldBuilder>();

    public final JsonOutputFieldComposer addFields(Collection<OutputField> fields) {
        Objects.requireNonNull(fields, "fields cannot be null");
        for (OutputField field : fields) {
            this.fieldBuilders.put(field.getFieldType().name, this.resolveBuilderFor(field.getFieldType()));
        }
        return this;
    }

    private OutputFieldBuilder resolveBuilderFor(OutputFieldType fieldType) {
        switch (fieldType) {
            case KEY: {
                return new KeyBuilder();
            }
            case VALUE: {
                return new ValueBuilder();
            }
            case OFFSET: {
                return new OffsetBuilder();
            }
            case TIMESTAMP: {
                return new TimestampBuilder();
            }
            case HEADERS: {
                return new HeaderBuilder();
            }
        }
        throw new ConnectException("Unknown output field type " + String.valueOf((Object)fieldType));
    }
}

