/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.parquet;

import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.output.OutputStreamWriter;
import io.aiven.kafka.connect.common.output.OutputWriter;
import io.aiven.kafka.connect.common.output.SinkRecordConverter;
import io.aiven.kafka.connect.common.output.parquet.ParquetConfig;
import io.aiven.kafka.connect.common.output.parquet.ParquetPositionOutputStream;
import io.aiven.kafka.connect.common.output.parquet.ParquetSchemaBuilder;
import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParquetOutputWriter
extends OutputWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParquetOutputWriter.class);
    private final SinkRecordConverter sinkRecordConverter;
    private final ParquetSchemaBuilder parquetSchemaBuilder;

    public ParquetOutputWriter(Collection<OutputField> fields, OutputStream out, Map<String, String> externalConfig, boolean envelopeEnabled) {
        super((OutputStream)((Object)new ParquetPositionOutputStream(out)), new OutputStreamWriterStub(), externalConfig);
        AvroData avroData = new AvroData(new AvroDataConfig(externalConfig));
        this.sinkRecordConverter = new SinkRecordConverter(fields, avroData, envelopeEnabled);
        this.parquetSchemaBuilder = new ParquetSchemaBuilder(fields, avroData, envelopeEnabled);
    }

    @Override
    public void writeRecords(Collection<SinkRecord> sinkRecords) throws IOException {
        ParquetConfig parquetConfig = new ParquetConfig(this.externalConfiguration);
        Schema parquetSchema = this.parquetSchemaBuilder.buildSchema(sinkRecords.iterator().next());
        LOGGER.debug("Record schema is: {}", (Object)parquetSchema);
        try (ParquetWriter parquetWriter = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)new ParquetOutputFile()).withSchema(parquetSchema).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withDictionaryEncoding(true)).withConf(parquetConfig.parquetConfiguration())).withCompressionCodec(parquetConfig.compressionCodecName())).build();){
            for (SinkRecord record : sinkRecords) {
                parquetWriter.write((Object)this.sinkRecordConverter.convert(record, parquetSchema));
            }
        }
    }

    @Override
    public void writeRecord(SinkRecord record) throws IOException {
        this.writeRecords(List.of(record));
    }

    private static final class OutputStreamWriterStub
    implements OutputStreamWriter {
        private OutputStreamWriterStub() {
        }

        @Override
        public void writeOneRecord(OutputStream outputStream, SinkRecord record) throws IOException {
        }
    }

    private class ParquetOutputFile
    implements OutputFile {
        private ParquetOutputFile() {
        }

        public PositionOutputStream create(long blockSizeHint) throws IOException {
            return (ParquetPositionOutputStream)((Object)ParquetOutputWriter.this.outputStream);
        }

        public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
            return this.create(blockSizeHint);
        }

        public boolean supportsBlockSize() {
            return false;
        }

        public long defaultBlockSize() {
            return 0L;
        }
    }
}

