/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.plainwriter;

import io.aiven.kafka.connect.common.output.plainwriter.OutputFieldPlainWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;

public final class KeyPlainWriter
implements OutputFieldPlainWriter {
    @Override
    public void write(SinkRecord record, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(record, "record cannot be null");
        Objects.requireNonNull(record.keySchema(), "key schema cannot be null");
        Objects.requireNonNull(outputStream, "outputStream cannot be null");
        if (record.keySchema().type() != Schema.Type.BYTES && record.keySchema().type() != Schema.Type.STRING) {
            String msg = String.format("Record key schema type must be %s or %s, %s given", Schema.Type.BYTES, Schema.Type.STRING, record.keySchema().type());
            throw new DataException(msg);
        }
        if (record.key() == null) {
            return;
        }
        if (record.key() instanceof byte[]) {
            outputStream.write(Base64.getEncoder().encode((byte[])record.key()));
        } else if (record.key() instanceof String) {
            outputStream.write(Base64.getEncoder().encode(((String)record.key()).getBytes()));
        } else {
            throw new DataException("Key is not byte[] or String");
        }
    }
}

