/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client.dsl.internal;

import io.alauda.devops.client.AlaudaAPIGroups;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.DefaultAlaudaDevOpsClient;
import io.alauda.kubernetes.api.model.Doneable;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.KubernetesResourceList;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.dsl.Resource;
import io.alauda.kubernetes.client.dsl.base.ConfigAndApiGroupsInfo;
import io.alauda.kubernetes.client.dsl.base.HasMetadataOperation;
import io.alauda.kubernetes.client.utils.URLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import okhttp3.OkHttpClient;

public class AlaudaOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    protected AlaudaOperation(OkHttpClient client, ConfigAndApiGroupsInfo config, String resourceT, String namespace, String name, Boolean cascading, T item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config.getConfig(), config.getApiGroup(), config.getApiGroupVersion(), resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.apiGroupVersion = config.getApiGroupVersion();
    }

    public static ConfigAndApiGroupsInfo withApiGroup(AlaudaDevOpsClient alaudaDevOpsClient, String apiGroupName, String apiVersion, AlaudaDevOpsConfig config) {
        String oapiVersion = config.getAlaudaAPIVersion();
        if (apiVersion == null) {
            apiVersion = oapiVersion;
        }
        if (config.isAlaudaAPIGroups(alaudaDevOpsClient)) {
            String apiGroupUrl = URLUtils.join((String[])new String[]{config.getMasterUrl(), "apis", apiGroupName, apiVersion});
            String apiGroupVersion = URLUtils.join((String[])new String[]{apiGroupName, apiVersion});
            return new ConfigAndApiGroupsInfo((Config)new AlaudaDevOpsConfig(config, apiGroupUrl), apiGroupName, apiGroupVersion);
        }
        if (apiVersion == null) {
            apiVersion = oapiVersion;
        }
        return new ConfigAndApiGroupsInfo((Config)config, apiGroupName, apiVersion);
    }

    public static ConfigAndApiGroupsInfo withApiGroup(OkHttpClient httpClient, String apiGroupName, String apiVersion, AlaudaDevOpsConfig config) {
        DefaultAlaudaDevOpsClient alaudaDevOpsClient = new DefaultAlaudaDevOpsClient(httpClient, config);
        String defaultApiVersion = AlaudaAPIGroups.getVersionByAPIGroup(apiGroupName);
        if (defaultApiVersion != null && (apiVersion == null || apiVersion.isEmpty()) && defaultApiVersion != apiVersion) {
            apiVersion = defaultApiVersion;
        }
        return AlaudaOperation.withApiGroup(alaudaDevOpsClient, apiGroupName, apiVersion, config);
    }

    public URL getRootUrl() {
        try {
            return new URL(AlaudaDevOpsConfig.wrap(this.getConfig()).getKubernetesUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public AlaudaOperation<T, L, D, R> inNamespace(String namespace) {
        try {
            return (AlaudaOperation)((Object)((Object)((Object)this)).getClass().getConstructor(OkHttpClient.class, AlaudaDevOpsConfig.class, String.class, String.class, String.class, Boolean.class, this.getType(), String.class, Boolean.class, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class).newInstance(new Object[]{this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields()}));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    public AlaudaDevOpsConfig getConfig() {
        return AlaudaDevOpsConfig.wrap(super.getConfig());
    }

    protected Class<? extends Config> getConfigType() {
        return AlaudaDevOpsConfig.class;
    }
}

