/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.client.dsl.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mifmif.common.regex.Generex;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.ParameterValue;
import io.alauda.devops.client.dsl.TemplateOperation;
import io.alauda.devops.client.dsl.TemplateResource;
import io.alauda.devops.client.dsl.internal.AlaudaOperation;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.KubernetesList;
import io.alauda.kubernetes.api.model.KubernetesListBuilder;
import io.alauda.kubernetes.api.model.KubernetesResourceList;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.OperationInfo;
import io.alauda.kubernetes.client.dsl.MixedOperation;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import io.alauda.kubernetes.client.utils.Serialization;
import io.alauda.kubernetes.client.utils.URLUtils;
import io.alauda.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.TemplateList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class TemplateOperationsImpl
extends AlaudaOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>>
implements TemplateOperation {
    private static final String EXPRESSION = "expression";
    private static final TypeReference<HashMap<String, String>> MAPS_REFERENCE = new TypeReference<HashMap<String, String>>(){};
    private final Map<String, String> parameters;

    public TemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String namespace) {
        this(client, config, null, namespace, null, (Boolean)true, null, null, (Boolean)false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public TemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, Template item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, "templates", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, null);
    }

    public TemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String namespace, String name, Boolean cascading, Template item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Map<String, String> parameters) {
        this(client, config, apiVersion, "templates", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, parameters);
    }

    public TemplateOperationsImpl(OkHttpClient client, AlaudaDevOpsConfig config, String apiVersion, String resourceT, String namespace, String name, Boolean cascading, Template item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Map<String, String> parameters) {
        super(client, AlaudaOperation.withApiGroup(client, "template.devops.io", apiVersion, config), resourceT, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.parameters = parameters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KubernetesList process(File f) {
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesList kubernetesList = this.process(is);
            return kubernetesList;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("process"), (Throwable)e);
        }
    }

    @Override
    public KubernetesList process(InputStream is) {
        return this.process((Map<String, String>)((Map)TemplateOperationsImpl.unmarshal((InputStream)is, MAPS_REFERENCE)));
    }

    @Override
    public KubernetesList process(Map<String, String> valuesMap) {
        Template t = (Template)this.get();
        try {
            List parameters = t.getParameters();
            if (parameters != null) {
                for (Parameter p : parameters) {
                    String v = valuesMap.get(p.getName());
                    if (v == null) continue;
                    p.setGenerate(null);
                    p.setValue(v);
                }
            }
            RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString((Object)t));
            Request.Builder requestBuilder = new Request.Builder().post(body).url(this.getProcessUrl());
            t = (Template)this.handleResponse(requestBuilder);
            KubernetesList l = new KubernetesList();
            l.setItems(t.getObjects());
            return l;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("process"), (Throwable)e);
        }
    }

    @Override
    public KubernetesList process(ParameterValue ... values) {
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        return this.process(valuesMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KubernetesList processLocally(File f) {
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesList kubernetesList = this.processLocally(is);
            return kubernetesList;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("processLocally"), (Throwable)e);
        }
    }

    @Override
    public KubernetesList processLocally(InputStream is) {
        return this.processLocally((Map<String, String>)((Map)TemplateOperationsImpl.unmarshal((InputStream)is, MAPS_REFERENCE)));
    }

    @Override
    public KubernetesList processLocally(ParameterValue ... values) {
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        return this.processLocally(valuesMap);
    }

    public MixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> withParameters(Map<String, String> parameters) {
        return new TemplateOperationsImpl(this.client, AlaudaDevOpsConfig.wrap(this.config), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (Template)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), parameters);
    }

    @Override
    public KubernetesList processLocally(Map<String, String> valuesMap) {
        String namespace;
        String string = namespace = this.getItem() != null ? ((Template)this.getItem()).getMetadata().getNamespace() : this.getNamespace();
        if (namespace == null) {
            namespace = this.getConfig().getNamespace();
        }
        String name = this.getItem() != null ? ((Template)this.getItem()).getMetadata().getName() : this.getName();
        Template t = (Template)((TemplateResource)((NonNamespaceOperation)this.withParameters(valuesMap).inNamespace(namespace)).withName(name)).get();
        List parameters = t != null ? t.getParameters() : null;
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(t != null && t.getObjects() != null ? t.getObjects() : Collections.emptyList())).build();
        try {
            String json = JSON_MAPPER.writeValueAsString((Object)list);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    for (Parameter parameter : parameters) {
                        String parameterValue;
                        String parameterName = parameter.getName();
                        String regex = "${" + parameterName + "}";
                        if (valuesMap.containsKey(parameterName)) {
                            parameterValue = valuesMap.get(parameterName);
                        } else if (Utils.isNotNullOrEmpty((String)parameter.getValue())) {
                            parameterValue = parameter.getValue();
                        } else if (EXPRESSION.equals(parameter.getGenerate())) {
                            Generex generex = new Generex(parameter.getFrom());
                            parameterValue = generex.random();
                        } else if (parameter.getRequired() == null || !parameter.getRequired().booleanValue()) {
                            parameterValue = "";
                        } else {
                            throw new IllegalArgumentException("No value available for parameter name: " + parameterName);
                        }
                        json = json.replace(regex, parameterValue);
                    }
                }
            }
            list = (KubernetesList)JSON_MAPPER.readValue(json, KubernetesList.class);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return list;
    }

    private URL getProcessUrl() throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.getNamespace() != null) {
            requestUrl = new URL(URLUtils.join((String[])new String[]{requestUrl.toString(), "namespaces", this.getNamespace()}));
        }
        requestUrl = new URL(URLUtils.join((String[])new String[]{requestUrl.toString(), "processedtemplates"}));
        return requestUrl;
    }

    public TemplateResource<Template, KubernetesList, DoneableTemplate> load(InputStream is) {
        String generatedName = Utils.randomString((String)"template-", (int)10);
        Template template = null;
        Object item = Serialization.unmarshal((InputStream)is, this.parameters);
        if (item instanceof Template) {
            template = (Template)item;
        } else if (item instanceof HasMetadata) {
            HasMetadata h = (HasMetadata)item;
            template = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).withNamespace(h != null && h.getMetadata() != null ? h.getMetadata().getNamespace() : null)).endMetadata()).withObjects(new HasMetadata[]{h})).build();
        } else if (item instanceof KubernetesResourceList) {
            List list = ((KubernetesResourceList)item).getItems();
            template = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).endMetadata()).withObjects(list.toArray(new HasMetadata[list.size()]))).build();
        } else if (item instanceof HasMetadata[]) {
            template = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).endMetadata()).withObjects((HasMetadata[])item)).build();
        } else if (item instanceof Collection) {
            ArrayList<HasMetadata> items = new ArrayList<HasMetadata>();
            for (Object o : (Collection)item) {
                if (!(o instanceof HasMetadata)) continue;
                items.add((HasMetadata)o);
            }
            template = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).endMetadata()).withObjects(items.toArray(new HasMetadata[items.size()]))).build();
        }
        return new TemplateOperationsImpl(this.client, AlaudaDevOpsConfig.wrap(this.config), null, this.namespace, null, false, template, null, false, 0L, null, null, null, null, null, null);
    }

    public TemplateResource<Template, KubernetesList, DoneableTemplate> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new TemplateOperationsImpl(this.client, AlaudaDevOpsConfig.wrap(this.config), this.getAPIVersion(), this.namespace, name, this.isCascading(), (Template)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.parameters);
    }

    @Override
    public AlaudaOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> inNamespace(String namespace) {
        return new TemplateOperationsImpl(this.client, AlaudaDevOpsConfig.wrap(this.config), this.getAPIVersion(), namespace, this.name, this.isCascading(), (Template)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.parameters);
    }

    protected Template handleGet(URL resourceUrl) throws InterruptedException, ExecutionException, IOException {
        return (Template)super.handleGet(resourceUrl, this.getType(), this.parameters);
    }

    protected <T> T handleResponse(Request.Builder requestBuilder, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return (T)this.handleResponse(requestBuilder, type, this.parameters);
    }
}

