/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.kubernetes.client;

import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.ConfigBuilder;
import io.alauda.kubernetes.client.DefaultKubernetesClient;
import io.alauda.kubernetes.client.utils.Serialization;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigTest {
    private static final String TEST_KUBECONFIG_FILE = ConfigTest.decodeUrl(ConfigTest.class.getResource("/test-kubeconfig").getFile());
    private static final String TEST_NAMESPACE_FILE = ConfigTest.decodeUrl(ConfigTest.class.getResource("/test-namespace").getFile());
    private static final String TEST_CONFIG_YML_FILE = ConfigTest.decodeUrl(ConfigTest.class.getResource("/test-config.yml").getFile());

    @Before
    public void setUp() {
        System.getProperties().remove("kubernetes.master");
        System.getProperties().remove("kubernetes.namespace");
        System.getProperties().remove("kubernetes.auth.token");
        System.getProperties().remove("kubernetes.auth.basic.username");
        System.getProperties().remove("kubernetes.auth.basic.password");
        System.getProperties().remove("kubernetes.trust.certificates");
        System.getProperties().remove("kubernetes.certs.ca.file");
        System.getProperties().remove("kubernetes.certs.ca.data");
        System.getProperties().remove("kubernetes.certs.client.file");
        System.getProperties().remove("kubernetes.certs.client.data");
        System.getProperties().remove("kubernetes.certs.client.key.file");
        System.getProperties().remove("kubernetes.certs.client.key.data");
        System.getProperties().remove("kubernetes.certs.client.key.algo");
        System.getProperties().remove("kubernetes.certs.client.key.passphrase");
        System.getProperties().remove("kubernetes.certs.client.key.file");
        System.getProperties().remove("kubernetes.watch.reconnectInterval");
        System.getProperties().remove("kubernetes.watch.reconnectLimit");
        System.getProperties().remove("kubernetes.request.timeout");
        System.getProperties().remove("http.proxy");
        System.getProperties().remove("kubeconfig");
        System.getProperties().remove("kubenamespace");
        System.getProperties().remove("kubernetes.tls.versions");
        System.getProperties().remove("kubernetes.truststore.file");
        System.getProperties().remove("kubernetes.truststore.passphrase");
        System.getProperties().remove("kubernetes.keystore.file");
        System.getProperties().remove("kubernetes.keystore.passphrase");
    }

    @After
    public void tearDown() {
        this.setUp();
    }

    @Test
    public void testWithSystemProperties() {
        System.setProperty("kubernetes.master", "http://somehost:80");
        System.setProperty("kubernetes.namespace", "testns");
        System.setProperty("kubernetes.auth.token", "token");
        System.setProperty("kubernetes.auth.basic.username", "user");
        System.setProperty("kubernetes.auth.basic.password", "pass");
        System.setProperty("kubernetes.trust.certificates", "true");
        System.setProperty("kubernetes.certs.ca.file", "/path/to/cert");
        System.setProperty("kubernetes.certs.ca.data", "cacertdata");
        System.setProperty("kubernetes.certs.client.file", "/path/to/clientcert");
        System.setProperty("kubernetes.certs.client.data", "clientcertdata");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.certs.client.key.data", "clientkeydata");
        System.setProperty("kubernetes.certs.client.key.algo", "algo");
        System.setProperty("kubernetes.certs.client.key.passphrase", "passphrase");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.watch.reconnectInterval", "5000");
        System.setProperty("kubernetes.watch.reconnectLimit", "5");
        System.setProperty("kubernetes.request.timeout", "5000");
        System.setProperty("http.proxy", "httpProxy");
        System.setProperty("kubernetes.tls.versions", "TLSv1.2,TLSv1.1");
        System.setProperty("kubernetes.truststore.file", "/path/to/truststore");
        System.setProperty("kubernetes.truststore.passphrase", "truststorePassphrase");
        System.setProperty("kubernetes.keystore.file", "/path/to/keystore");
        System.setProperty("kubernetes.keystore.passphrase", "keystorePassphrase");
        Config config = new Config();
        this.assertConfig(config);
        config = new ConfigBuilder().build();
        this.assertConfig(config);
    }

    @Test
    public void testWithBuilder() {
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost:80")).withApiVersion("v1")).withNamespace("testns")).withOauthToken("token")).withUsername("user")).withPassword("pass")).withTrustCerts(true)).withCaCertFile("/path/to/cert")).withCaCertData("cacertdata")).withClientCertFile("/path/to/clientcert")).withClientCertData("clientcertdata")).withClientKeyFile("/path/to/clientkey")).withClientKeyData("clientkeydata")).withClientKeyAlgo("algo")).withClientKeyPassphrase("passphrase")).withWatchReconnectInterval(5000)).withWatchReconnectLimit(5)).withRequestTimeout(5000)).withHttpProxy("httpProxy")).withTlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1})).withTrustStoreFile("/path/to/truststore")).withTrustStorePassphrase("truststorePassphrase")).withKeyStoreFile("/path/to/keystore")).withKeyStorePassphrase("keystorePassphrase")).build();
        this.assertConfig(config);
    }

    @Test
    public void testWithBuilderAndSystemProperties() {
        System.setProperty("kubernetes.master", "http://tobeoverriden:80");
        System.setProperty("kubernetes.namespace", "tobeoverriden");
        System.setProperty("kubernetes.auth.token", "token");
        System.setProperty("kubernetes.auth.basic.username", "user");
        System.setProperty("kubernetes.auth.basic.password", "pass");
        System.setProperty("kubernetes.trust.certificates", "true");
        System.setProperty("kubernetes.certs.ca.file", "/path/to/cert");
        System.setProperty("kubernetes.certs.ca.data", "cacertdata");
        System.setProperty("kubernetes.certs.client.file", "/path/to/clientcert");
        System.setProperty("kubernetes.certs.client.data", "clientcertdata");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.certs.client.key.data", "clientkeydata");
        System.setProperty("kubernetes.certs.client.key.algo", "algo");
        System.setProperty("kubernetes.certs.client.key.passphrase", "passphrase");
        System.setProperty("kubernetes.certs.client.key.file", "/path/to/clientkey");
        System.setProperty("kubernetes.watch.reconnectInterval", "5000");
        System.setProperty("kubernetes.watch.reconnectLimit", "5");
        System.setProperty("kubernetes.request.timeout", "5000");
        System.setProperty("http.proxy", "httpProxy");
        System.setProperty("kubernetes.tls.versions", "TLSv1.2,TLSv1.1");
        System.setProperty("kubernetes.truststore.file", "/path/to/truststore");
        System.setProperty("kubernetes.truststore.passphrase", "truststorePassphrase");
        System.setProperty("kubernetes.keystore.file", "/path/to/keystore");
        System.setProperty("kubernetes.keystore.passphrase", "keystorePassphrase");
        Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl("http://somehost:80")).withNamespace("testns")).build();
        this.assertConfig(config);
    }

    private static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testWithKubeConfig() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
        Config config = new Config();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"https://172.28.128.4:8443/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assert.assertEquals((Object)"token", (Object)config.getOauthToken());
        Assert.assertTrue((boolean)config.getCaCertFile().endsWith("testns/ca.pem"));
        Assert.assertTrue((boolean)new File(config.getCaCertFile()).isAbsolute());
    }

    @Test
    public void testWithKubeConfigAndOverrideContext() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
        Config config = Config.autoConfigure((String)"production/172-28-128-4:8443/root");
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"https://172.28.128.4:8443/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"production", (Object)config.getNamespace());
        Assert.assertEquals((Object)"supertoken", (Object)config.getOauthToken());
        Assert.assertTrue((boolean)config.getCaCertFile().endsWith("testns/ca.pem"));
        Assert.assertTrue((boolean)new File(config.getCaCertFile()).isAbsolute());
    }

    @Test
    public void testWithKubeConfigAndSystemProperties() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = new Config();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assert.assertEquals((Object)"token", (Object)config.getOauthToken());
    }

    @Test
    public void testWithKubeConfigAndSytemPropertiesAndBuilder() {
        System.setProperty("kubeconfig", TEST_KUBECONFIG_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = ((ConfigBuilder)new ConfigBuilder().withNamespace("testns2")).build();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"token", (Object)config.getOauthToken());
        Assert.assertEquals((Object)"testns2", (Object)config.getNamespace());
    }

    @Test
    public void testWithNamespacePath() {
        System.setProperty("kubeconfig", "nokubeconfigfile");
        System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = new Config();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testnsfrompath", (Object)config.getNamespace());
    }

    @Test
    public void testWithNonExistingNamespacePath() {
        System.setProperty("kubeconfig", "nokubeconfigfile");
        System.setProperty("kubenamespace", "nonamespace");
        System.setProperty("kubernetes.master", "http://somehost:80");
        Config config = new Config();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals(null, (Object)config.getNamespace());
    }

    @Test
    public void testWithNamespacePathAndSystemProperties() {
        System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        System.setProperty("kubernetes.namespace", "testns");
        Config config = new Config();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns", (Object)config.getNamespace());
    }

    @Test
    public void testWithNamespacePathAndSytemPropertiesAndBuilder() {
        System.setProperty("kubenamespace", TEST_NAMESPACE_FILE);
        System.setProperty("kubernetes.master", "http://somehost:80");
        System.setProperty("kubernetes.namespace", "tobeoverriden");
        Config config = ((ConfigBuilder)new ConfigBuilder().withNamespace("testns2")).build();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns2", (Object)config.getNamespace());
    }

    @Test
    public void shouldInstantiateClientUsingYaml() throws MalformedURLException {
        File configYml = new File(TEST_CONFIG_YML_FILE);
        try (FileInputStream is = new FileInputStream(configYml);){
            DefaultKubernetesClient client = DefaultKubernetesClient.fromConfig((InputStream)is);
            Assert.assertEquals((Object)"http://some.url", (Object)client.getMasterUrl().toString());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void shouldInstantiateClientUsingSerializeDeserialize() throws MalformedURLException {
        DefaultKubernetesClient original = new DefaultKubernetesClient();
        String json = Serialization.asJson((Object)original.getConfiguration());
        DefaultKubernetesClient copy = DefaultKubernetesClient.fromConfig((String)json);
        Assert.assertEquals((Object)original.getConfiguration().getMasterUrl(), (Object)copy.getConfiguration().getMasterUrl());
        Assert.assertEquals((Object)original.getConfiguration().getOauthToken(), (Object)copy.getConfiguration().getOauthToken());
        Assert.assertEquals((Object)original.getConfiguration().getNamespace(), (Object)copy.getConfiguration().getNamespace());
        Assert.assertEquals((Object)original.getConfiguration().getUsername(), (Object)copy.getConfiguration().getUsername());
        Assert.assertEquals((Object)original.getConfiguration().getPassword(), (Object)copy.getConfiguration().getPassword());
    }

    @Test
    public void shouldRespectMaxRequests() {
        Config config = ((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequests(120)).build();
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        Assert.assertEquals((long)64L, (long)((OkHttpClient)client.adapt(OkHttpClient.class)).dispatcher().getMaxRequests());
        client = new DefaultKubernetesClient(config);
        Assert.assertEquals((long)120L, (long)((OkHttpClient)client.adapt(OkHttpClient.class)).dispatcher().getMaxRequests());
    }

    @Test
    public void shouldRespectMaxRequestsPerHost() {
        Config config = ((ConfigBuilder)new ConfigBuilder().withMaxConcurrentRequestsPerHost(20)).build();
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        Assert.assertEquals((long)5L, (long)((OkHttpClient)client.adapt(OkHttpClient.class)).dispatcher().getMaxRequestsPerHost());
        client = new DefaultKubernetesClient(config);
        Assert.assertEquals((long)20L, (long)((OkHttpClient)client.adapt(OkHttpClient.class)).dispatcher().getMaxRequestsPerHost());
    }

    private void assertConfig(Config config) {
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)config.isTrustCerts());
        Assert.assertEquals((Object)"http://somehost:80/", (Object)config.getMasterUrl());
        Assert.assertEquals((Object)"testns", (Object)config.getNamespace());
        Assert.assertEquals((Object)"token", (Object)config.getOauthToken());
        Assert.assertEquals((Object)"user", (Object)config.getUsername());
        Assert.assertEquals((Object)"pass", (Object)config.getPassword());
        Assert.assertEquals((Object)"/path/to/cert", (Object)config.getCaCertFile());
        Assert.assertEquals((Object)"cacertdata", (Object)config.getCaCertData());
        Assert.assertEquals((Object)"/path/to/clientcert", (Object)config.getClientCertFile());
        Assert.assertEquals((Object)"clientcertdata", (Object)config.getClientCertData());
        Assert.assertEquals((Object)"/path/to/clientkey", (Object)config.getClientKeyFile());
        Assert.assertEquals((Object)"clientkeydata", (Object)config.getClientKeyData());
        Assert.assertEquals((Object)"algo", (Object)config.getClientKeyAlgo());
        Assert.assertEquals((Object)"passphrase", (Object)config.getClientKeyPassphrase());
        Assert.assertEquals((Object)"httpProxy", (Object)config.getHttpProxy());
        Assert.assertEquals((long)5000L, (long)config.getWatchReconnectInterval());
        Assert.assertEquals((long)5L, (long)config.getWatchReconnectLimit());
        Assert.assertEquals((long)5000L, (long)config.getRequestTimeout());
        Assert.assertArrayEquals((Object[])new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1}, (Object[])config.getTlsVersions());
        Assert.assertEquals((Object)"/path/to/truststore", (Object)config.getTrustStoreFile());
        Assert.assertEquals((Object)"truststorePassphrase", (Object)config.getTrustStorePassphrase());
        Assert.assertEquals((Object)"/path/to/keystore", (Object)config.getKeyStoreFile());
        Assert.assertEquals((Object)"keystorePassphrase", (Object)config.getKeyStorePassphrase());
    }
}

