/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.kubernetes.client.utils;

import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.KubernetesList;
import io.alauda.kubernetes.api.model.KubernetesListBuilder;
import io.alauda.kubernetes.api.model.Pod;
import io.alauda.kubernetes.api.model.PodBuilder;
import io.alauda.kubernetes.api.model.PodFluent;
import io.alauda.kubernetes.api.model.ReplicationController;
import io.alauda.kubernetes.api.model.ReplicationControllerBuilder;
import io.alauda.kubernetes.api.model.ReplicationControllerFluent;
import io.alauda.kubernetes.api.model.Service;
import io.alauda.kubernetes.api.model.ServiceBuilder;
import io.alauda.kubernetes.api.model.ServiceFluent;
import io.alauda.kubernetes.client.utils.ResourceCompare;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class ResourceCompareTest {
    private Pod pod;
    private Service service;
    private KubernetesList kubeList;

    @Before
    public void setup() {
        this.pod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("test")).and()).build();
        this.service = ((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName("service1")).withNamespace("test")).and()).build();
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withNamespace("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).endSpec()).build();
        this.kubeList = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{this.pod, this.service, rc})).build();
    }

    @Test
    public void testResourceCompareEqualsTrue() throws Exception {
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.kubeList, (Object)this.kubeList), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testResourceCompareEqualsFalse() throws Exception {
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName("repl1")).withNamespace("test")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(2))).endSpec()).build();
        KubernetesList kubeList2 = ((KubernetesListBuilder)new KubernetesListBuilder(this.kubeList).withItems(new HasMetadata[]{this.pod, this.service, rc})).build();
        MatcherAssert.assertThat((Object)ResourceCompare.equals((Object)this.kubeList, (Object)kubeList2), (Matcher)CoreMatchers.is((Object)false));
    }
}

