/*
 * Decompiled with CFR 0.152.
 */
package io.amient.affinity.kafka;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.amient.affinity.avro.record.AvroSerde;
import io.amient.affinity.avro.record.AvroSerde$;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.kafka.common.serialization.Serializer;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u0017\t\u00192*\u00194lC\u00063(o\\*fe&\fG.\u001b>fe*\u00111\u0001B\u0001\u0006W\u000647.\u0019\u0006\u0003\u000b\u0019\t\u0001\"\u00194gS:LG/\u001f\u0006\u0003\u000f!\ta!Y7jK:$(\"A\u0005\u0002\u0005%|7\u0001A\n\u0004\u00011!\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007Uy\u0012%D\u0001\u0017\u0015\t9\u0002$A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u00033i\taaY8n[>t'BA\u0002\u001c\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\n\u0005\u00012\"AC*fe&\fG.\u001b>feB\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t\u0019\u0011I\\=\t\u000b!\u0002A\u0011A\u0015\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0016\u0001\u001b\u0005\u0011\u0001bB\u0017\u0001\u0001\u0004%\tAL\u0001\u0006SN\\U-_\u000b\u0002_A\u0011!\u0005M\u0005\u0003c\r\u0012qAQ8pY\u0016\fg\u000eC\u00044\u0001\u0001\u0007I\u0011\u0001\u001b\u0002\u0013%\u001c8*Z=`I\u0015\fHCA\u001b9!\t\u0011c'\u0003\u00028G\t!QK\\5u\u0011\u001dI$'!AA\u0002=\n1\u0001\u001f\u00132\u0011\u0019Y\u0004\u0001)Q\u0005_\u00051\u0011n]&fs\u0002Bq!\u0010\u0001A\u0002\u0013\u0005a(A\u0003tKJ$W-F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003\t\u0012\tA!\u0019<s_&\u0011a)\u0011\u0002\n\u0003Z\u0014xnU3sI\u0016Dq\u0001\u0013\u0001A\u0002\u0013\u0005\u0011*A\u0005tKJ$Wm\u0018\u0013fcR\u0011QG\u0013\u0005\bs\u001d\u000b\t\u00111\u0001@\u0011\u0019a\u0005\u0001)Q\u0005\u007f\u000511/\u001a:eK\u0002BQA\u0014\u0001\u0005B=\u000b\u0011bY8oM&<WO]3\u0015\u0007U\u0002F\u000eC\u0003R\u001b\u0002\u0007!+A\u0004d_:4\u0017nZ:1\u0005M3\u0007\u0003\u0002+X3\u0012l\u0011!\u0016\u0006\u0003-B\tA!\u001e;jY&\u0011\u0001,\u0016\u0002\u0004\u001b\u0006\u0004\bC\u0001.b\u001d\tYv\f\u0005\u0002]G5\tQL\u0003\u0002_\u0015\u00051AH]8pizJ!\u0001Y\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003A\u000e\u0002\"!\u001a4\r\u0001\u0011Iq\rUA\u0001\u0002\u0003\u0015\t\u0001\u001b\u0002\u0004?\u0012\n\u0014CA5\"!\t\u0011#.\u0003\u0002lG\t9aj\u001c;iS:<\u0007\"B\u0017N\u0001\u0004y\u0003\"\u00028\u0001\t\u0003z\u0017!C:fe&\fG.\u001b>f)\r\u0001h\u000f\u001f\t\u0004EE\u001c\u0018B\u0001:$\u0005\u0015\t%O]1z!\t\u0011C/\u0003\u0002vG\t!!)\u001f;f\u0011\u00159X\u000e1\u0001Z\u0003\u0015!x\u000e]5d\u0011\u0015IX\u000e1\u0001\"\u0003\u0011!\u0017\r^1\t\u000bm\u0004A\u0011\t?\u0002\u000b\rdwn]3\u0015\u0003U\u0002")
public class KafkaAvroSerializer
implements Serializer<Object> {
    private boolean isKey = false;
    private AvroSerde serde = null;

    public boolean isKey() {
        return this.isKey;
    }

    public void isKey_$eq(boolean x$1) {
        this.isKey = x$1;
    }

    public AvroSerde serde() {
        return this.serde;
    }

    public void serde_$eq(AvroSerde x$1) {
        this.serde = x$1;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        Config config = ConfigFactory.parseMap(configs).getConfig("schema").atKey("schema").atPath(AvroSerde.AbsConf$.MODULE$.Avro().path());
        this.serde_$eq(AvroSerde$.MODULE$.create(config));
        this.isKey_$eq(isKey);
    }

    public byte[] serialize(String topic, Object data) {
        Predef$.MODULE$.require(this.serde() != null, (Function0 & java.io.Serializable & Serializable)() -> "AvroSerde not configured");
        String subject = new StringBuilder(1).append(topic).append("-").append((Object)(this.isKey() ? "key" : "value")).toString();
        Tuple2 tuple2 = this.serde().from(data, subject);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int schemaId = tuple2._1$mcI$sp();
        Schema objSchema = (Schema)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)schemaId), (Object)objSchema);
        Tuple2 tuple23 = tuple22;
        int schemaId2 = tuple23._1$mcI$sp();
        Schema objSchema2 = (Schema)tuple23._2();
        return this.serde().write(data, objSchema2, schemaId2);
    }

    public void close() {
        block0: {
            if (this.serde() == null) break block0;
            this.serde().close();
        }
    }
}

