/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import java.util.regex.Pattern;

@ComponentName(value="Discard Text")
@ComponentDescription(value="Discard text content if it matches a regular expression")
@SettingsClass(value=Settings.class)
public class Discard
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getDiscardOn(), settings.isInverse());
    }

    public Capabilities capabilities() {
        SimpleCapabilities.Builder builder = new SimpleCapabilities.Builder().withDeletesContent(Text.class);
        return builder.build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Pattern discardOn;
        private boolean inverse;

        public Settings() {
            this.discardOn = Pattern.compile(".*discard me.*", 34);
            this.inverse = false;
        }

        @JsonbCreator
        public Settings(@JsonbProperty(value="discardOn") Pattern discardOn, @JsonbProperty(value="inverse") boolean inverse) {
            this.discardOn = discardOn;
            this.inverse = inverse;
        }

        public boolean validate() {
            return this.discardOn != null;
        }

        @Description(value="The pattern to match to determine whether text should be discarded")
        public Pattern getDiscardOn() {
            return this.discardOn;
        }

        public void setDiscardOn(Pattern discardOn) {
            this.discardOn = discardOn;
        }

        @Description(value="If true, then text that doesn't match will be discarded (rather than text that does match)")
        public boolean isInverse() {
            return this.inverse;
        }

        public void setInverse(boolean inverse) {
            this.inverse = inverse;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final Pattern discardOn;
        private final boolean inverse;

        public Processor(Pattern discardOn, boolean inverse) {
            this.discardOn = discardOn;
            this.inverse = inverse;
        }

        protected void process(Text content) {
            Item item = content.getItem();
            if (this.discardOn.matcher((CharSequence)content.getData()).matches() ^ this.inverse) {
                item.removeContent((Content)content);
            }
        }
    }
}

