/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.tck.impl;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.exceptions.UnsupportedContentException;
import io.annot8.api.helpers.WithDescription;
import io.annot8.common.data.content.Text;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractItemTest {
    protected abstract Item getItem();

    @Test
    public void testGetContent() {
        Item item = this.getItem();
        try {
            ((Content.Builder)item.createContent(Text.class).withData(() -> "test").withId("testContentId")).withDescription("testContentDescription").save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test should not fail here", (Throwable)e);
        }
        Optional optional = item.getContent("testContentId");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)optional.isPresent());
        Content content = (Content)optional.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testContentId", (Object)content.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testContentDescription", (Object)content.getDescription());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)content.getData());
    }

    @Test
    public void testGetContents() {
        Item item = this.getItem();
        try {
            item.createContent(Text.class).withData(() -> "test").withDescription("testContentDescription").save();
            item.createContent(Text.class).withData(() -> "test2").withDescription("content2").save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test should not error here", (Throwable)e);
        }
        Assertions.assertThat(item.getContents().map(Content::getData).map(String.class::cast)).containsExactlyInAnyOrder((Object[])new String[]{"test", "test2"});
        Assertions.assertThat(item.getContents().map(WithDescription::getDescription)).containsExactlyInAnyOrder((Object[])new String[]{"testContentDescription", "content2"});
    }

    @Test
    public void testCreate() {
        Item item = this.getItem();
        Text test = null;
        try {
            test = (Text)item.createContent(Text.class).withDescription("testContentDescription").withData((Object)"test").save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test should not throw an exception.", (Throwable)e);
        }
        org.junit.jupiter.api.Assertions.assertNotNull(test);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testContentDescription", (Object)test.getDescription());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)test.getData());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)test.getId());
    }

    @Test
    public void testRemoveContent() {
        Item item = this.getItem();
        try {
            ((Content.Builder)item.createContent(Text.class).withData(() -> "test").withId("testContentId")).withDescription("testContentDescription").save();
        }
        catch (IncompleteException | UnsupportedContentException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test should not fail here", (Throwable)e);
        }
        Assertions.assertThat((Stream)item.getContents()).isNotEmpty();
        item.removeContent("testContentId");
        Assertions.assertThat((Stream)item.getContents()).isEmpty();
    }

    @Test
    public void testDiscard() {
        Item item = this.getItem();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)item.isDiscarded());
        item.discard();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)item.isDiscarded());
    }
}

