/*
 * Decompiled with CFR 0.152.
 */
package io.anontech.vizivault;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.anontech.vizivault.schema.InvalidSchemaException;
import io.anontech.vizivault.schema.PrimitiveSchema;
import io.anontech.vizivault.schema.SchemaIgnore;
import io.anontech.vizivault.schema.SchemaOverride;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AttributeDefinition {
    private String key;
    private String name;
    private String hint;
    private boolean repeatable;
    private boolean indexed;
    private Date createdDate;
    private Date modifiedDate;
    private List<String> tags;
    private Object schema;

    public AttributeDefinition(String name) {
        this.setName(name);
        this.setSchema(PrimitiveSchema.STRING);
    }

    public void setSchema(PrimitiveSchema schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
        this.key = name;
    }

    private void addFieldSchema(JsonObject schemaObject, Field f) {
        Annotation[] annotations;
        for (Annotation a : annotations = f.getAnnotations()) {
            if (a instanceof SchemaIgnore) {
                return;
            }
            if (!(a instanceof SchemaOverride)) continue;
            schemaObject.addProperty(f.getName(), ((SchemaOverride)a).value().toString());
            return;
        }
        if (f.getType().isArray()) {
            schemaObject.add('[' + f.getName() + ']', this.constructSchema(f.getType().getComponentType()));
        } else {
            Type fieldType = f.getGenericType();
            if (fieldType instanceof ParameterizedType && ((ParameterizedType)fieldType).getRawType().equals(List.class)) {
                Type listElementType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
                schemaObject.add('[' + f.getName() + ']', this.constructSchema(listElementType));
            } else {
                schemaObject.add(f.getName(), this.constructSchema(f.getType()));
            }
        }
    }

    private JsonElement constructSchema(Type type) {
        if (type.equals(String.class)) {
            return new JsonPrimitive("string");
        }
        if (type.equals(Date.class)) {
            return new JsonPrimitive("date");
        }
        if (type.equals(Integer.class)) {
            return new JsonPrimitive("int");
        }
        if (type.equals(Double.class) || type.equals(Float.class)) {
            return new JsonPrimitive("float");
        }
        if (type.equals(Boolean.class)) {
            return new JsonPrimitive("boolean");
        }
        if (!(type instanceof Class)) {
            return new JsonPrimitive(type.getTypeName());
        }
        Class typeClass = (Class)type;
        if (typeClass.isPrimitive()) {
            if (type.equals(Float.TYPE) || type.equals(Double.TYPE)) {
                return new JsonPrimitive("float");
            }
            if (type.equals(Boolean.TYPE)) {
                return new JsonPrimitive("boolean");
            }
            return new JsonPrimitive("int");
        }
        if (typeClass.isEnum()) {
            return new JsonPrimitive("string");
        }
        JsonObject schemaObject = new JsonObject();
        while (!typeClass.equals(Object.class)) {
            for (Field f : typeClass.getDeclaredFields()) {
                this.addFieldSchema(schemaObject, f);
            }
            typeClass = typeClass.getSuperclass();
        }
        return schemaObject;
    }

    public void schemaFromClass(Class<?> schemaClass) {
        this.schema = this.constructSchema(schemaClass);
    }

    private void validateSchema(JsonObject jsonSchema) {
        for (Map.Entry entry : jsonSchema.entrySet()) {
            if (!((String)entry.getKey()).matches("\\w+") && !((String)entry.getKey()).matches("\\[\\w+\\]")) {
                throw new InvalidSchemaException("Sub-attribute key contains unusable characters: " + this.key);
            }
            if (((JsonElement)entry.getValue()).isJsonArray() || ((JsonElement)entry.getValue()).isJsonNull()) {
                throw new InvalidSchemaException(String.format("Schema for sub-attribute %s must be an object or string", entry.getKey()));
            }
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            this.validateSchema(((JsonElement)entry.getValue()).getAsJsonObject());
        }
    }

    public void setSchema(JsonObject jsonSchema) {
        this.validateSchema(jsonSchema);
        this.schema = jsonSchema;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getHint() {
        return this.hint;
    }

    @Generated
    public boolean isRepeatable() {
        return this.repeatable;
    }

    @Generated
    public boolean isIndexed() {
        return this.indexed;
    }

    @Generated
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public Object getSchema() {
        return this.schema;
    }

    @Generated
    public void setHint(String hint) {
        this.hint = hint;
    }

    @Generated
    public void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }

    @Generated
    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    @Generated
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeDefinition)) {
            return false;
        }
        AttributeDefinition other = (AttributeDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$hint = this.getHint();
        String other$hint = other.getHint();
        if (this$hint == null ? other$hint != null : !this$hint.equals(other$hint)) {
            return false;
        }
        if (this.isRepeatable() != other.isRepeatable()) {
            return false;
        }
        if (this.isIndexed() != other.isIndexed()) {
            return false;
        }
        Date this$createdDate = this.getCreatedDate();
        Date other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Date this$modifiedDate = this.getModifiedDate();
        Date other$modifiedDate = other.getModifiedDate();
        if (this$modifiedDate == null ? other$modifiedDate != null : !((Object)this$modifiedDate).equals(other$modifiedDate)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Object this$schema = this.getSchema();
        Object other$schema = other.getSchema();
        return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AttributeDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $hint = this.getHint();
        result = result * 59 + ($hint == null ? 43 : $hint.hashCode());
        result = result * 59 + (this.isRepeatable() ? 79 : 97);
        result = result * 59 + (this.isIndexed() ? 79 : 97);
        Date $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Date $modifiedDate = this.getModifiedDate();
        result = result * 59 + ($modifiedDate == null ? 43 : ((Object)$modifiedDate).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Object $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AttributeDefinition(key=" + this.key + ", name=" + this.getName() + ", hint=" + this.getHint() + ", repeatable=" + this.isRepeatable() + ", indexed=" + this.isIndexed() + ", createdDate=" + this.getCreatedDate() + ", modifiedDate=" + this.getModifiedDate() + ", tags=" + this.getTags() + ", schema=" + this.getSchema() + ")";
    }

    @Generated
    AttributeDefinition() {
    }
}

