/*
 * Decompiled with CFR 0.152.
 */
package io.anontech.vizivault;

import io.anontech.vizivault.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class Entity {
    private Map<String, Attribute> attributes;
    private Map<String, List<Attribute>> repeatedAttributes;
    private Set<Attribute> changedAttributes = new HashSet<Attribute>();
    private Set<String> deletedAttributes;
    private String id;
    private List<String> tags;
    private Date created;
    private Date updated;

    Entity() {
        this.attributes = new HashMap<String, Attribute>();
        this.repeatedAttributes = new HashMap<String, List<Attribute>>();
        this.deletedAttributes = new HashSet<String>();
        this.tags = new ArrayList<String>();
    }

    public Entity(String id) {
        this();
        this.id = id;
    }

    void purge() {
        this.attributes.clear();
    }

    Set<Attribute> getChangedAttributes() {
        return this.changedAttributes;
    }

    Set<String> getDeletedAttributes() {
        return this.deletedAttributes;
    }

    public void addAttribute(String attributeKey, Object value) {
        Attribute attribute = new Attribute();
        attribute.setAttribute(attributeKey);
        attribute.setValue(value);
        this.addAttribute(attribute);
    }

    public void addAttribute(Attribute attribute) {
        this.addAttributeWithoutPendingChange(attribute);
        this.changedAttributes.add(attribute);
    }

    void addAttributeWithoutPendingChange(Attribute attribute) {
        String attributeKey = attribute.getAttribute();
        if (this.repeatedAttributes.containsKey(attributeKey)) {
            this.repeatedAttributes.get(attributeKey).add(attribute);
        } else if (this.attributes.containsKey(attributeKey)) {
            ArrayList<Attribute> repeatableValues = new ArrayList<Attribute>();
            repeatableValues.add(this.attributes.get(attributeKey));
            repeatableValues.add(attribute);
            this.attributes.remove(attributeKey);
            this.repeatedAttributes.put(attributeKey, repeatableValues);
        } else {
            this.attributes.put(attributeKey, attribute);
        }
    }

    public Attribute getAttribute(String attributeKey) {
        if (this.repeatedAttributes.containsKey(attributeKey)) {
            if (this.repeatedAttributes.get(attributeKey).size() == 1) {
                return this.repeatedAttributes.get(attributeKey).get(0);
            }
            throw new RuntimeException("Attribute has multiple values");
        }
        return this.attributes.get(attributeKey);
    }

    public List<Attribute> getAttributes(String attributeKey) {
        if (this.attributes.containsKey(attributeKey)) {
            return List.of(this.attributes.get(attributeKey));
        }
        return this.repeatedAttributes.getOrDefault(attributeKey, List.of());
    }

    public List<Attribute> getAttributes() {
        return Stream.concat(this.attributes.values().stream(), this.repeatedAttributes.values().stream().flatMap(Collection::stream)).collect(Collectors.toList());
    }

    public void clearAttribute(String attributeKey) {
        this.attributes.remove(attributeKey);
        this.repeatedAttributes.remove(attributeKey);
        this.deletedAttributes.add(attributeKey);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public Date getUpdated() {
        return this.updated;
    }
}

