/*
 * Decompiled with CFR 0.152.
 */
package io.anontech.vizivault;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.anontech.vizivault.tagging.AttributeRule;
import io.anontech.vizivault.tagging.ConjunctiveRule;
import io.anontech.vizivault.tagging.DisjunctiveRule;
import io.anontech.vizivault.tagging.RegulationRule;
import io.anontech.vizivault.tagging.TagRule;
import io.anontech.vizivault.tagging.UserRule;
import java.lang.reflect.Type;

class RegulationRuleDeserializer
implements JsonDeserializer<RegulationRule>,
JsonSerializer<RegulationRule> {
    RegulationRuleDeserializer() {
    }

    public RegulationRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String ruleType;
        switch (ruleType = json.getAsJsonObject().get("type").getAsString()) {
            case "all": {
                return (RegulationRule)context.deserialize(json, ConjunctiveRule.class);
            }
            case "any": {
                return (RegulationRule)context.deserialize(json, DisjunctiveRule.class);
            }
            case "tag": {
                return (RegulationRule)context.deserialize(json, TagRule.class);
            }
            case "attribute": {
                return (RegulationRule)context.deserialize(json, AttributeRule.class);
            }
            case "user": {
                return (RegulationRule)context.deserialize(json, UserRule.class);
            }
        }
        throw new JsonParseException(String.format("Unknown rule type %s", ruleType));
    }

    public JsonElement serialize(RegulationRule src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src, src.getClass());
    }
}

