/*
 * Decompiled with CFR 0.152.
 */
package io.anontech.vizivault;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.anontech.vizivault.Attribute;
import io.anontech.vizivault.AttributeDefinition;
import io.anontech.vizivault.Entity;
import io.anontech.vizivault.MissingKeyException;
import io.anontech.vizivault.Regulation;
import io.anontech.vizivault.RegulationRuleDeserializer;
import io.anontech.vizivault.SearchRequest;
import io.anontech.vizivault.Tag;
import io.anontech.vizivault.User;
import io.anontech.vizivault.VaultCommunicationException;
import io.anontech.vizivault.VaultResponseException;
import io.anontech.vizivault.tagging.RegulationRule;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ViziVault {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private URL baseUrl;
    private String apiKey;
    private String encryptionKey;
    private String decryptionKey;
    private OkHttpClient httpClient = new OkHttpClient();
    private Gson gson = new GsonBuilder().registerTypeAdapter(RegulationRule.class, (Object)new RegulationRuleDeserializer()).create();

    public ViziVault(URL url) {
        this.baseUrl = url;
    }

    public ViziVault withApiKey(String apiKey) {
        this.apiKey = String.format("Bearer %s", apiKey);
        return this;
    }

    public ViziVault withEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public ViziVault withDecryptionKey(String decryptionKey) {
        this.decryptionKey = decryptionKey;
        return this;
    }

    private JsonElement post(String url, Object body, Headers headers) {
        try {
            Response response = this.httpClient.newCall(new Request.Builder().url(new URL(this.baseUrl, url)).headers(new Headers.Builder().addAll(headers).add("Authorization", this.apiKey).build()).post(RequestBody.create((String)this.gson.toJson(body), (MediaType)JSON)).build()).execute();
            JsonObject responseData = ((JsonElement)this.gson.fromJson(response.body().string(), JsonElement.class)).getAsJsonObject();
            if (!response.isSuccessful()) {
                throw new VaultResponseException(responseData.get("message").getAsString(), response.code());
            }
            return responseData.get("data");
        }
        catch (IOException e) {
            throw new VaultCommunicationException(e);
        }
    }

    private JsonElement get(String url, Headers headers) {
        try {
            Response response = this.httpClient.newCall(new Request.Builder().url(new URL(this.baseUrl, url)).headers(new Headers.Builder().addAll(headers).add("Authorization", this.apiKey).build()).get().build()).execute();
            JsonObject responseData = ((JsonElement)this.gson.fromJson(response.body().string(), JsonElement.class)).getAsJsonObject();
            if (!response.isSuccessful()) {
                throw new VaultResponseException(responseData.get("message").getAsString(), response.code());
            }
            return responseData.get("data");
        }
        catch (IOException e) {
            throw new VaultCommunicationException(e);
        }
    }

    private JsonElement delete(String url) {
        try {
            Response response = this.httpClient.newCall(new Request.Builder().url(new URL(this.baseUrl, url)).headers(new Headers.Builder().add("Authorization", this.apiKey).build()).delete().build()).execute();
            JsonElement responseData = (JsonElement)this.gson.fromJson(response.body().string(), JsonElement.class);
            if (!response.isSuccessful()) {
                String errorMessage = responseData == null ? "No message provided" : responseData.getAsJsonObject().get("message").getAsString();
                throw new VaultResponseException(errorMessage, response.code());
            }
            return responseData.getAsJsonObject().get("data");
        }
        catch (IOException e) {
            throw new VaultCommunicationException(e);
        }
    }

    private JsonElement get(String url) {
        return this.get(url, new Headers.Builder().build());
    }

    private JsonElement post(String url, Object body) {
        return this.post(url, body, new Headers.Builder().build());
    }

    private JsonElement getWithDecryptionKey(String url) {
        if (this.decryptionKey == null) {
            throw new MissingKeyException("Cannot read data from the vault, as no decryption key was provided");
        }
        return this.get(url, new Headers.Builder().add("X-Decryption-Key", this.decryptionKey).build());
    }

    private JsonElement postWithEncryptionKey(String url, Object body) {
        if (this.encryptionKey == null) {
            throw new MissingKeyException("Cannot write data to the vault, as no encryption key was provided");
        }
        return this.post(url, body, new Headers.Builder().add("X-Encryption-Key", this.encryptionKey).build());
    }

    public Entity findByEntity(String entityId) {
        List data = (List)this.gson.fromJson(this.getWithDecryptionKey(String.format("/entities/%s/attributes", entityId)), new TypeToken<List<Attribute>>(){}.getType());
        Entity entity = (Entity)this.gson.fromJson(this.get(String.format("/entities/%s", entityId)), Entity.class);
        for (Attribute attr : data) {
            entity.addAttributeWithoutPendingChange(attr);
        }
        return entity;
    }

    public User findByUser(String userId) {
        List data = (List)this.gson.fromJson(this.getWithDecryptionKey(String.format("/users/%s/attributes", userId)), new TypeToken<List<Attribute>>(){}.getType());
        User user = (User)this.gson.fromJson(this.get(String.format("/users/%s", userId)), User.class);
        for (Attribute attr : data) {
            user.addAttributeWithoutPendingChange(attr);
        }
        return user;
    }

    public List<Attribute> getUserAttribute(String userId, String attribute) {
        return (List)this.gson.fromJson(this.getWithDecryptionKey(String.format("/users/%s/attributes/%s", userId, attribute)), new TypeToken<List<Attribute>>(){}.getType());
    }

    public void save(Entity entity) {
        for (String attribute : entity.getDeletedAttributes()) {
            this.delete(String.format("/users/%s/attributes/%s", entity.getId(), attribute));
        }
        entity.getDeletedAttributes().clear();
        this.post(entity instanceof User ? "/users" : "/entities", new EntityDefinitionDTO(entity));
        if (!entity.getChangedAttributes().isEmpty()) {
            JsonObject storageRequest = new JsonObject();
            JsonArray pointsList = new JsonArray();
            for (Attribute attribute : entity.getChangedAttributes()) {
                pointsList.add(this.gson.toJsonTree((Object)attribute));
            }
            storageRequest.add("data", (JsonElement)pointsList);
            this.postWithEncryptionKey(String.format("/users/%s/attributes", entity.getId()), storageRequest);
        }
        entity.getChangedAttributes().clear();
    }

    public void purge(String userid) {
        this.delete(String.format("/users/%s/data", userid));
    }

    public void storeAttributeDefinition(AttributeDefinition attribute) {
        this.post("/attributes", attribute);
    }

    public AttributeDefinition getAttributeDefinition(String attributeKey) {
        return (AttributeDefinition)this.gson.fromJson(this.get(String.format("/attributes/%s", attributeKey)), AttributeDefinition.class);
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return (List)this.gson.fromJson(this.get("/attributes/"), new TypeToken<List<AttributeDefinition>>(){}.getType());
    }

    public void deleteAttributeDefinition(String attributeKey) {
        this.delete(String.format("/attributes/%s", attributeKey));
    }

    public void storeTag(Tag tag) {
        this.post("/tags", tag);
    }

    public Tag getTag(String tag) {
        return (Tag)this.gson.fromJson(this.get(String.format("/tags/%s", tag)), Tag.class);
    }

    public List<Tag> getTags() {
        return (List)this.gson.fromJson(this.get("/tags/"), new TypeToken<List<Tag>>(){}.getType());
    }

    public boolean deleteTag(String tag) {
        try {
            this.delete(String.format("/tags/%s", tag));
            return true;
        }
        catch (VaultResponseException e) {
            return false;
        }
    }

    public void storeRegulation(Regulation regulation) {
        this.post("/regulations", regulation);
    }

    public List<Regulation> getRegulations() {
        return (List)this.gson.fromJson(this.get("/regulations/"), new TypeToken<List<Regulation>>(){}.getType());
    }

    public Regulation getRegulation(String key) {
        return (Regulation)this.gson.fromJson(this.get(String.format("/regulations/%s", key)), new TypeToken<Regulation>(){}.getType());
    }

    public boolean deleteRegulation(String regulation) {
        try {
            this.delete(String.format("/regulations/%s", regulation));
            return true;
        }
        catch (VaultResponseException e) {
            return false;
        }
    }

    public List<Attribute> search(SearchRequest searchRequest, int page, int count) {
        JsonObject paginatedSearchRequest = new JsonObject();
        paginatedSearchRequest.add("query", this.gson.toJsonTree((Object)searchRequest));
        paginatedSearchRequest.addProperty("page", (Number)page);
        paginatedSearchRequest.addProperty("count", (Number)count);
        return (List)this.gson.fromJson(this.post("/search", paginatedSearchRequest), new TypeToken<List<Attribute>>(){}.getType());
    }

    public Attribute getDataPoint(String dataPointId) {
        return (Attribute)this.gson.fromJson(this.getWithDecryptionKey(String.format("/data/%s", dataPointId)), Attribute.class);
    }

    private static class EntityDefinitionDTO {
        private String id;
        private List<String> tags;

        EntityDefinitionDTO(Entity entity) {
            this.id = entity.getId();
            this.tags = entity.getTags();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public List<String> getTags() {
            return this.tags;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityDefinitionDTO)) {
                return false;
            }
            EntityDefinitionDTO other = (EntityDefinitionDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            List<String> this$tags = this.getTags();
            List<String> other$tags = other.getTags();
            return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EntityDefinitionDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            List<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ViziVault.EntityDefinitionDTO(id=" + this.getId() + ", tags=" + this.getTags() + ")";
        }
    }
}

