/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.test;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.build.JwtClaimsBuilder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKSMockServer
implements QuarkusTestResourceLifecycleManager {
    static final Logger LOGGER = LoggerFactory.getLogger(JWKSMockServer.class);
    private WireMockServer server;
    public String authServerUrl;
    public String realm = "test";
    public String tokenEndpoint;
    public static String ADMIN_CLIENT_ID = "admin-client";
    public static String DEVELOPER_CLIENT_ID = "developer-client";
    public static String DEVELOPER_2_CLIENT_ID = "developer-2-client";
    public static String READONLY_CLIENT_ID = "readonly-client";
    public static String NO_ROLE_CLIENT_ID = "no-role-client";
    public static String WRONG_CREDS_CLIENT_ID = "wrong-creds-client";
    public static String BASIC_USER = "sr-test-user";
    public static String BASIC_PASSWORD = "sr-test-password";

    public Map<String, String> start() {
        this.server = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        this.server.start();
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)("/auth/realms/" + this.realm + "/.well-known/uma2-configuration"))).willReturn(this.wellKnownResponse()));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)("/auth/realms/" + this.realm + "/.well-known/openid-configuration"))).willReturn(this.wellKnownResponse()));
        this.server.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/auth/realms/" + this.realm + "/protocol/openid-connect/certs"))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"keys\" : [\n    {\n      \"kid\": \"1\",\n      \"kty\":\"RSA\",\n      \"n\":\"iJw33l1eVAsGoRlSyo-FCimeOc-AaZbzQ2iESA3Nkuo3TFb1zIkmt0kzlnWVGt48dkaIl13Vdefh9hqw_r9yNF8xZqX1fp0PnCWc5M_TX_ht5fm9y0TpbiVmsjeRMWZn4jr3DsFouxQ9aBXUJiu26V0vd2vrECeeAreFT4mtoHY13D2WVeJvboc5mEJcp50JNhxRCJ5UkY8jR_wfUk2Tzz4-fAj5xQaBccXnqJMu_1C6MjoCEiB7G1d13bVPReIeAGRKVJIF6ogoCN8JbrOhc_48lT4uyjbgnd24beatuKWodmWYhactFobRGYo5551cgMe8BoxpVQ4to30cGA0qjQ\",\n      \"e\":\"AQAB\"\n    }\n  ]\n}")));
        this.stubForClient(ADMIN_CLIENT_ID);
        this.stubForClient(DEVELOPER_CLIENT_ID);
        this.stubForClient(DEVELOPER_2_CLIENT_ID);
        this.stubForClient(READONLY_CLIENT_ID);
        this.stubForClient(NO_ROLE_CLIENT_ID);
        this.server.stubFor(WireMock.post((String)("/auth/realms/" + this.realm + "/protocol/openid-connect/token/")).withRequestBody((ContentPattern)WireMock.containing((String)"grant_type=client_credentials")).withRequestBody((ContentPattern)WireMock.containing((String)("client_id=" + BASIC_USER))).withRequestBody((ContentPattern)WireMock.containing((String)("client_secret=" + BASIC_PASSWORD))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"access_token\": \"" + this.generateJwtToken(ADMIN_CLIENT_ID) + "\",\n  \"refresh_token\": \"07e08903-1263-4dd1-9fd1-4a59b0db5283\",\n  \"token_type\": \"bearer\"\n}")));
        this.server.stubFor(WireMock.post((String)("/auth/realms/" + this.realm + "/protocol/openid-connect/token/")).withRequestBody((ContentPattern)WireMock.containing((String)"grant_type=client_credentials")).withRequestBody((ContentPattern)WireMock.containing((String)("client_id=" + WRONG_CREDS_CLIENT_ID))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(401)));
        this.authServerUrl = this.server.baseUrl() + "/auth";
        LOGGER.info("Keycloak started in mock mode: {}", (Object)this.authServerUrl);
        this.tokenEndpoint = this.authServerUrl + "/realms/" + this.realm + "/protocol/openid-connect/token";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("registry.keycloak.url", this.authServerUrl);
        props.put("tenant-manager.keycloak.url.configured", this.tokenEndpoint);
        props.put("registry.keycloak.realm", this.realm);
        props.put("registry.auth.enabled", "true");
        props.put("registry.auth.role-based-authorization", "true");
        props.put("registry.auth.owner-only-authorization", "true");
        props.put("registry.auth.admin-override.enabled", "true");
        props.put("registry.auth.basic-auth-client-credentials.enabled", "true");
        return props;
    }

    private ResponseDefinitionBuilder wellKnownResponse() {
        return WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n    \"jwks_uri\": \"" + this.server.baseUrl() + "/auth/realms/" + this.realm + "/protocol/openid-connect/certs\",\n \"token_endpoint\": \"" + this.server.baseUrl() + "/auth/realms/" + this.realm + "/protocol/openid-connect/token\" }");
    }

    private String generateJwtToken(String userName) {
        JwtClaimsBuilder b = Jwt.preferredUserName((String)userName);
        if (userName.equals(ADMIN_CLIENT_ID)) {
            b.claim("groups", (Object)"sr-admin");
        } else if (userName.equals(DEVELOPER_CLIENT_ID)) {
            b.claim("groups", (Object)"sr-developer");
        } else if (userName.equals(DEVELOPER_2_CLIENT_ID)) {
            b.claim("groups", (Object)"sr-developer");
        } else if (userName.equals(READONLY_CLIENT_ID)) {
            b.claim("groups", (Object)"sr-readonly");
        }
        return b.jws().keyId("1").sign();
    }

    private void stubForClient(String client) {
        this.server.stubFor(WireMock.post((String)("/auth/realms/" + this.realm + "/protocol/openid-connect/token/")).withRequestBody((ContentPattern)WireMock.containing((String)"grant_type=client_credentials")).withRequestBody((ContentPattern)WireMock.containing((String)("client_id=" + client))).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\n  \"access_token\": \"" + this.generateJwtToken(client) + "\",\n  \"refresh_token\": \"07e08903-1263-4dd1-9fd1-4a59b0db5283\",\n  \"token_type\": \"bearer\"\n}")));
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.server.stop();
            LOGGER.info("Keycloak was shut down");
            this.server = null;
        }
    }
}

