/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.auth.IAccessController;
import io.apicurio.registry.storage.NotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.types.Current;
import io.quarkus.security.identity.SecurityIdentity;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;

public abstract class AbstractAccessController
implements IAccessController {
    @Inject
    AuthConfig authConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    @Current
    RegistryStorage storage;

    protected boolean isOwner(InvocationContext context) {
        Authorized annotation = context.getMethod().getAnnotation(Authorized.class);
        AuthorizedStyle style = annotation.style();
        if (style == AuthorizedStyle.GroupAndArtifact) {
            String groupId = this.getStringParam(context, 0);
            String artifactId = this.getStringParam(context, 1);
            return this.verifyArtifactCreatedBy(groupId, artifactId);
        }
        if (style == AuthorizedStyle.GroupOnly && this.authConfig.ownerOnlyAuthorizationLimitGroupAccess.get().booleanValue()) {
            String groupId = this.getStringParam(context, 0);
            return this.verifyGroupCreatedBy(groupId);
        }
        if (style == AuthorizedStyle.ArtifactOnly) {
            String artifactId = this.getStringParam(context, 0);
            return this.verifyArtifactCreatedBy(null, artifactId);
        }
        if (style == AuthorizedStyle.GlobalId) {
            long globalId = this.getLongParam(context, 0);
            return this.verifyArtifactCreatedBy(globalId);
        }
        return true;
    }

    private boolean verifyGroupCreatedBy(String groupId) {
        try {
            GroupMetaDataDto dto = this.storage.getGroupMetaData(groupId);
            String createdBy = dto.getCreatedBy();
            return createdBy == null || createdBy.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    private boolean verifyArtifactCreatedBy(String groupId, String artifactId) {
        try {
            ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(groupId, artifactId, RegistryStorage.ArtifactRetrievalBehavior.DEFAULT);
            String createdBy = dto.getCreatedBy();
            return createdBy == null || createdBy.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    private boolean verifyArtifactCreatedBy(long globalId) {
        try {
            ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(globalId);
            String createdBy = dto.getCreatedBy();
            return createdBy == null || createdBy.equals(this.securityIdentity.getPrincipal().getName());
        }
        catch (NotFoundException nfe) {
            return true;
        }
    }

    protected String getStringParam(InvocationContext context, int index) {
        return (String)context.getParameters()[index];
    }

    protected Long getLongParam(InvocationContext context, int index) {
        return (Long)context.getParameters()[index];
    }
}

