/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.RoleProvider;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RoleType;
import io.quarkus.security.identity.SecurityIdentity;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class StorageRoleProvider
implements RoleProvider {
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    Instance<JsonWebToken> identityToken;
    private static final String AZP_CLAIM = "azp";
    @Inject
    @Current
    RegistryStorage storage;

    private boolean hasRole(String role) {
        String role4principal = this.storage.getRoleForPrincipal(this.securityIdentity.getPrincipal().getName());
        boolean hasRole = role.equals(role4principal);
        if (!hasRole && this.tokenHasAzpClaim()) {
            hasRole = role.equals(this.storage.getRoleForPrincipal((String)((JsonWebToken)this.identityToken.get()).getClaim(AZP_CLAIM)));
        }
        return hasRole;
    }

    private boolean tokenHasAzpClaim() {
        return this.identityToken.isResolvable() && ((JsonWebToken)this.identityToken.get()).getClaim(AZP_CLAIM) != null;
    }

    @Override
    public boolean isDeveloper() {
        return this.hasRole(RoleType.DEVELOPER.name());
    }

    @Override
    public boolean isReadOnly() {
        return this.hasRole(RoleType.READ_ONLY.name());
    }

    @Override
    public boolean isAdmin() {
        return this.hasRole(RoleType.ADMIN.name());
    }
}

