/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonValue;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.Optional;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE)
@RegisterForReflection
public class CompatibilityLevelDto {
    private Level compatibility;

    public static CompatibilityLevelDto create(Optional<CompatibilityLevel> source) {
        return new CompatibilityLevelDto(Level.create(source));
    }

    public CompatibilityLevelDto() {
    }

    public CompatibilityLevelDto(Level compatibility) {
        this.compatibility = compatibility;
    }

    public Level getCompatibility() {
        return this.compatibility;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompatibilityLevelDto)) {
            return false;
        }
        CompatibilityLevelDto other = (CompatibilityLevelDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Level this$compatibility = this.getCompatibility();
        Level other$compatibility = other.getCompatibility();
        return !(this$compatibility == null ? other$compatibility != null : !((Object)((Object)this$compatibility)).equals((Object)other$compatibility));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompatibilityLevelDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Level $compatibility = this.getCompatibility();
        result = result * 59 + ($compatibility == null ? 43 : ((Object)((Object)$compatibility)).hashCode());
        return result;
    }

    public String toString() {
        return "CompatibilityLevelDto(compatibility=" + this.getCompatibility() + ")";
    }

    public static enum Level {
        BACKWARD("BACKWARD"),
        BACKWARD_TRANSITIVE("BACKWARD_TRANSITIVE"),
        FORWARD("FORWARD"),
        FORWARD_TRANSITIVE("FORWARD_TRANSITIVE"),
        FULL("FULL"),
        FULL_TRANSITIVE("FULL_TRANSITIVE"),
        NONE("NONE");

        @JsonValue
        private final String stringValue;

        public static Level create(Optional<CompatibilityLevel> source) {
            return source.map(c -> {
                switch (c) {
                    case BACKWARD: {
                        return BACKWARD;
                    }
                    case BACKWARD_TRANSITIVE: {
                        return BACKWARD_TRANSITIVE;
                    }
                    case FORWARD: {
                        return FORWARD;
                    }
                    case FORWARD_TRANSITIVE: {
                        return FORWARD_TRANSITIVE;
                    }
                    case FULL: {
                        return FULL;
                    }
                    case FULL_TRANSITIVE: {
                        return FULL_TRANSITIVE;
                    }
                    case NONE: {
                        return NONE;
                    }
                }
                return null;
            }).orElse(NONE);
        }

        private Level(String level) {
            this.stringValue = level;
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }
}

