/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v6;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaId;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/apis/ccompat/v6/subjects/{subject}/versions")
@Consumes(value={"application/json", "application/octet-stream", "application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json"})
@Produces(value={"application/json", "application/octet-stream", "application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json"})
public interface SubjectVersionsResource {
    @GET
    public List<Integer> listVersions(@PathParam(value="subject") String var1) throws Exception;

    @POST
    @Authorized(style=AuthorizedStyle.ArtifactOnly)
    public SchemaId register(@PathParam(value="subject") String var1, @NotNull SchemaInfo var2) throws Exception;

    @GET
    @Path(value="/{version}")
    public Schema getSchemaByVersion(@PathParam(value="subject") String var1, @PathParam(value="version") String var2) throws Exception;

    @DELETE
    @Path(value="/{version}")
    @Authorized(style=AuthorizedStyle.ArtifactOnly)
    public int deleteSchemaVersion(@PathParam(value="subject") String var1, @PathParam(value="version") String var2) throws Exception;

    @GET
    @Path(value="/{version}/schema")
    public String getSchemaOnly(@PathParam(value="subject") String var1, @PathParam(value="version") String var2) throws Exception;

    @GET
    @Path(value="/{version}/referencedby")
    public List<Long> getSchemasReferencedBy(@PathParam(value="subject") String var1, @PathParam(value="version") String var2) throws Exception;
}

