/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7.impl;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.ccompat.rest.v7.SchemasResource;
import io.apicurio.registry.ccompat.rest.v7.impl.AbstractResource;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import java.util.Arrays;
import java.util.List;
import javax.interceptor.Interceptors;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SchemasResourceImpl
extends AbstractResource
implements SchemasResource {
    @Override
    @Authorized(style=AuthorizedStyle.GlobalId, level=AuthorizedLevel.Read)
    public SchemaInfo getSchema(int id, String subject, String groupId) {
        return this.facade.getSchemaById(id);
    }

    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<String> getRegisteredTypes() {
        return Arrays.asList("JSON", "PROTOBUF", "AVRO");
    }

    @Override
    @Authorized(style=AuthorizedStyle.GlobalId, level=AuthorizedLevel.Read)
    public List<SubjectVersion> getSubjectVersions(int id) {
        return this.facade.getSubjectVersions(id);
    }
}

