/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.store;

import io.apicurio.registry.ccompat.dto.CompatibilityCheckResponse;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.dto.SchemaReference;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.types.RuleType;
import java.util.List;
import java.util.function.Function;

public interface RegistryStorageFacade {
    default public List<String> getSubjects(boolean deleted) {
        return this.getSubjects(deleted, null);
    }

    public List<SubjectVersion> getSubjectVersions(int var1);

    default public List<Integer> deleteSubject(String subject, boolean permanent) throws ArtifactNotFoundException, RegistryStorageException {
        return this.deleteSubject(subject, permanent, null);
    }

    default public Long createSchema(String subject, String schema, String schemaType, List<SchemaReference> references, boolean normalize) throws ArtifactAlreadyExistsException, ArtifactNotFoundException, RegistryStorageException {
        return this.createSchema(subject, schema, schemaType, references, normalize, null);
    }

    public SchemaInfo getSchemaById(int var1) throws RegistryStorageException;

    default public Schema getSchema(String subject, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.getSchema(subject, version, null);
    }

    default public List<Integer> getVersions(String subject) throws ArtifactNotFoundException, RegistryStorageException {
        return this.getVersions(subject, null);
    }

    default public Schema getSchemaNormalize(String subject, SchemaInfo schema, boolean normalize) throws ArtifactNotFoundException, RegistryStorageException {
        return this.getSchemaNormalize(subject, schema, normalize, null);
    }

    default public int deleteSchema(String subject, String version, boolean permanent) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.deleteSchema(subject, version, permanent, null);
    }

    default public void createOrUpdateArtifactRule(String subject, RuleType type, RuleConfigurationDto dto) {
        this.createOrUpdateArtifactRule(subject, type, dto, null);
    }

    public void createOrUpdateGlobalRule(RuleType var1, RuleConfigurationDto var2);

    default public CompatibilityCheckResponse testCompatibilityBySubjectName(String subject, SchemaContent request, boolean verbose) {
        return this.testCompatibilityBySubjectName(subject, request, verbose, null);
    }

    default public CompatibilityCheckResponse testCompatibilityByVersion(String subject, String version, SchemaContent request, boolean verbose) {
        return this.testCompatibilityByVersion(subject, version, request, verbose, null);
    }

    public <T> T parseVersionString(String var1, String var2, String var3, Function<String, T> var4);

    public RuleConfigurationDto getGlobalRule(RuleType var1);

    public void deleteGlobalRule(RuleType var1);

    default public void deleteArtifactRule(String subject, RuleType ruleType) {
        this.deleteArtifactRule(subject, ruleType, null);
    }

    default public RuleConfigurationDto getArtifactRule(String subject, RuleType ruleType) {
        return this.getArtifactRule(subject, ruleType, null);
    }

    default public List<Long> getContentIdsReferencingArtifact(String subject, String version) {
        return this.getContentIdsReferencingArtifact(subject, version, null);
    }

    public CompatibilityCheckResponse testCompatibilityBySubjectName(String var1, SchemaContent var2, boolean var3, String var4);

    public CompatibilityCheckResponse testCompatibilityByVersion(String var1, String var2, SchemaContent var3, boolean var4, String var5);

    public void createOrUpdateArtifactRule(String var1, RuleType var2, RuleConfigurationDto var3, String var4);

    public void deleteArtifactRule(String var1, RuleType var2, String var3);

    public RuleConfigurationDto getArtifactRule(String var1, RuleType var2, String var3);

    public int deleteSchema(String var1, String var2, boolean var3, String var4);

    public Schema getSchema(String var1, String var2, String var3);

    public List<Long> getContentIdsReferencingArtifact(String var1, String var2, String var3);

    public List<String> getSubjects(boolean var1, String var2);

    public Schema getSchemaNormalize(String var1, SchemaInfo var2, boolean var3, String var4);

    public List<Integer> deleteSubject(String var1, boolean var2, String var3);

    public List<Integer> getVersions(String var1, String var2);

    public Long createSchema(String var1, String var2, String var3, List<SchemaReference> var4, boolean var5, String var6);
}

