/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.store;

import io.apicurio.registry.ccompat.dto.CompatibilityCheckResponse;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.dto.SchemaReference;
import io.apicurio.registry.ccompat.dto.SubjectVersion;
import io.apicurio.registry.ccompat.rest.error.ConflictException;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.ccompat.store.CCompatConfig;
import io.apicurio.registry.ccompat.store.FacadeConverter;
import io.apicurio.registry.ccompat.store.RegistryStorageFacade;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.rules.UnprocessableSchemaException;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchedArtifactDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.ArtifactTypeUtil;
import io.apicurio.registry.util.VersionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryStorageFacadeImpl
implements RegistryStorageFacade {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesService rulesService;
    @Inject
    FacadeConverter converter;
    @Inject
    CCompatConfig cconfig;
    @Inject
    Logger log;
    @Inject
    ArtifactTypeUtilProviderFactory factory;

    @Override
    public List<String> getSubjects(boolean deleted, String groupId) {
        return this.storage.searchArtifacts(Set.of(SearchFilter.ofGroup(groupId)), OrderBy.createdOn, OrderDirection.asc, 0, this.cconfig.maxSubjects.get()).getArtifacts().stream().filter(searchedArtifactDto -> this.isCcompatManagedType(searchedArtifactDto.getType()) && this.shouldFilterState(deleted, searchedArtifactDto.getState())).map(SearchedArtifactDto::getId).collect(Collectors.toList());
    }

    private boolean shouldFilterState(boolean deleted, ArtifactState state) {
        if (deleted) {
            return true;
        }
        return state.equals((Object)ArtifactState.ENABLED);
    }

    @Override
    public List<SubjectVersion> getSubjectVersions(int contentId) {
        if (this.cconfig.legacyIdModeEnabled.get().booleanValue()) {
            ArtifactMetaDataDto artifactMetaData2 = this.storage.getArtifactMetaData(contentId);
            return Collections.singletonList(this.converter.convert(artifactMetaData2.getId(), artifactMetaData2.getVersionId()));
        }
        return this.storage.getArtifactVersionsByContentId(contentId).stream().map(artifactMetaData -> this.converter.convert(artifactMetaData.getId(), artifactMetaData.getVersionId())).collect(Collectors.toList());
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean permanent, String groupId) throws ArtifactNotFoundException, RegistryStorageException {
        if (permanent) {
            return this.storage.deleteArtifact(groupId, subject).stream().map(VersionUtil::toInteger).map(this.converter::convertUnsigned).collect(Collectors.toList());
        }
        this.storage.updateArtifactState(groupId, subject, ArtifactState.DISABLED);
        return this.storage.getArtifactVersions(groupId, subject).stream().map(VersionUtil::toLong).map(this.converter::convertUnsigned).sorted().collect(Collectors.toList());
    }

    @Override
    public SchemaInfo getSchemaById(int contentId) throws ArtifactNotFoundException, RegistryStorageException {
        List<ArtifactReferenceDto> references;
        ContentHandle contentHandle;
        if (this.cconfig.legacyIdModeEnabled.get().booleanValue()) {
            StoredArtifactDto artifactVersion = this.storage.getArtifactVersion(contentId);
            contentHandle = artifactVersion.getContent();
            references = artifactVersion.getReferences();
        } else {
            ContentWrapperDto contentWrapper = this.storage.getArtifactByContentId(contentId);
            contentHandle = this.storage.getArtifactByContentId(contentId).getContent();
            references = contentWrapper.getReferences();
            List<ArtifactMetaDataDto> artifacts = this.storage.getArtifactVersionsByContentId(contentId);
            if (artifacts == null || artifacts.isEmpty()) {
                throw new ArtifactNotFoundException("ContentId: " + contentId);
            }
        }
        return this.converter.convert(contentHandle, ArtifactTypeUtil.determineArtifactType(contentHandle, null, null, this.storage.resolveReferences(references), this.factory.getAllArtifactTypes()), references);
    }

    @Override
    public Schema getSchema(String subject, String versionString, String groupId) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return this.parseVersionString(subject, versionString, groupId, version -> {
            ArtifactVersionMetaDataDto artifactVersionMetaDataDto = this.storage.getArtifactVersionMetaData(groupId, subject, (String)version);
            StoredArtifactDto storedArtifact = this.storage.getArtifactVersion(groupId, subject, (String)version);
            return this.converter.convert(subject, storedArtifact, artifactVersionMetaDataDto.getType());
        });
    }

    @Override
    public List<Integer> getVersions(String subject, String groupId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.storage.getArtifactVersions(groupId, subject).stream().map(VersionUtil::toLong).map(this.converter::convertUnsigned).sorted().collect(Collectors.toList());
    }

    @Override
    public Schema getSchemaNormalize(String subject, SchemaInfo schema, boolean normalize, String groupId) throws ArtifactNotFoundException, RegistryStorageException {
        List<ArtifactReferenceDto> artifactReferenceDtos = this.parseReferences(schema.getReferences(), groupId);
        ArtifactVersionMetaDataDto amd = this.cconfig.canonicalHashModeEnabled.get() != false || normalize ? this.storage.getArtifactVersionMetaData(groupId, subject, true, ContentHandle.create((String)schema.getSchema()), artifactReferenceDtos) : this.storage.getArtifactVersionMetaData(groupId, subject, false, ContentHandle.create((String)schema.getSchema()), artifactReferenceDtos);
        StoredArtifactDto storedArtifact = this.storage.getArtifactVersion(groupId, subject, amd.getVersion());
        return this.converter.convert(subject, storedArtifact);
    }

    @Override
    public Long createSchema(String subject, String schema, String schemaType, List<SchemaReference> references, boolean normalize, String groupId) throws ArtifactAlreadyExistsException, ArtifactNotFoundException, RegistryStorageException {
        if (null == schema) {
            throw new UnprocessableEntityException("The schema provided is null.");
        }
        List<ArtifactReferenceDto> artifactReferences = this.parseReferences(references, groupId);
        try {
            ContentHandle content = ContentHandle.create((String)schema);
            ArtifactVersionMetaDataDto dto = this.cconfig.canonicalHashModeEnabled.get() != false || normalize ? this.storage.getArtifactVersionMetaData(groupId, subject, true, content, artifactReferences) : this.storage.getArtifactVersionMetaData(groupId, subject, false, content, artifactReferences);
            return this.cconfig.legacyIdModeEnabled.get() != false ? dto.getGlobalId() : dto.getContentId();
        }
        catch (ArtifactNotFoundException content) {
            try {
                Map<String, ContentHandle> resolvedReferences = this.resolveReferences(references);
                String artifactType = ArtifactTypeUtil.determineArtifactType(ContentHandle.create((String)schema), null, null, resolvedReferences, this.factory.getAllArtifactTypes());
                if (schemaType != null && !artifactType.equals(schemaType)) {
                    throw new UnprocessableEntityException(String.format("Given schema is not from type: %s", schemaType));
                }
                ArtifactMetaDataDto artifactMeta = this.createOrUpdateArtifact(subject, schema, artifactType, references, normalize, groupId);
                return this.cconfig.legacyIdModeEnabled.get() != false ? artifactMeta.getGlobalId() : artifactMeta.getContentId();
            }
            catch (InvalidArtifactTypeException ex) {
                throw new UnprocessableEntityException(ex.getMessage());
            }
        }
    }

    private Map<String, ContentHandle> resolveReferences(List<SchemaReference> references) {
        Map<String, ContentHandle> resolvedReferences = Collections.emptyMap();
        if (references != null && !references.isEmpty()) {
            List<ArtifactReferenceDto> referencesAsDtos = references.stream().map(schemaReference -> {
                ArtifactReferenceDto artifactReferenceDto = new ArtifactReferenceDto();
                artifactReferenceDto.setArtifactId(schemaReference.getSubject());
                artifactReferenceDto.setVersion(String.valueOf(schemaReference.getVersion()));
                artifactReferenceDto.setName(schemaReference.getName());
                artifactReferenceDto.setGroupId(null);
                return artifactReferenceDto;
            }).collect(Collectors.toList());
            resolvedReferences = this.storage.resolveReferences(referencesAsDtos);
        }
        return resolvedReferences;
    }

    @Override
    public int deleteSchema(String subject, String versionString, boolean permanent, String groupId) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        return VersionUtil.toInteger(this.parseVersionString(subject, versionString, groupId, version -> {
            if (permanent) {
                this.storage.deleteArtifactVersion(groupId, subject, (String)version);
            } else {
                this.storage.updateArtifactState(groupId, subject, (String)version, ArtifactState.DISABLED);
            }
            return version;
        }));
    }

    @Override
    public void createOrUpdateArtifactRule(String subject, RuleType type, RuleConfigurationDto dto, String groupId) {
        if (!this.doesArtifactRuleExist(subject, RuleType.COMPATIBILITY, groupId)) {
            this.storage.createArtifactRule(groupId, subject, RuleType.COMPATIBILITY, dto);
        } else {
            this.storage.updateArtifactRule(groupId, subject, RuleType.COMPATIBILITY, dto);
        }
    }

    @Override
    public void createOrUpdateGlobalRule(RuleType type, RuleConfigurationDto dto) {
        if (!this.doesGlobalRuleExist(RuleType.COMPATIBILITY)) {
            this.storage.createGlobalRule(RuleType.COMPATIBILITY, dto);
        } else {
            this.storage.updateGlobalRule(RuleType.COMPATIBILITY, dto);
        }
    }

    @Override
    public CompatibilityCheckResponse testCompatibilityByVersion(String subject, String version, SchemaContent request, boolean verbose, String groupId) {
        return this.parseVersionString(subject, version, groupId, v -> {
            try {
                ArtifactVersionMetaDataDto artifact = this.storage.getArtifactVersionMetaData(groupId, subject, (String)v);
                this.rulesService.applyRules(groupId, subject, (String)v, artifact.getType(), ContentHandle.create((String)request.getSchema()), Collections.emptyList(), Collections.emptyMap());
                return CompatibilityCheckResponse.IS_COMPATIBLE;
            }
            catch (RuleViolationException ex) {
                if (verbose) {
                    return new CompatibilityCheckResponse(false, ex.getMessage());
                }
                return CompatibilityCheckResponse.IS_NOT_COMPATIBLE;
            }
            catch (UnprocessableSchemaException ex) {
                throw new UnprocessableEntityException(ex.getMessage(), ex);
            }
        });
    }

    @Override
    public CompatibilityCheckResponse testCompatibilityBySubjectName(String subject, SchemaContent request, boolean verbose, String groupId) {
        try {
            List<String> versions = this.storage.getArtifactVersions(groupId, subject);
            for (String version : versions) {
                ArtifactVersionMetaDataDto artifactVersionMetaData = this.storage.getArtifactVersionMetaData(groupId, subject, version);
                this.rulesService.applyRules(groupId, subject, version, artifactVersionMetaData.getType(), ContentHandle.create((String)request.getSchema()), Collections.emptyList(), Collections.emptyMap());
            }
            return CompatibilityCheckResponse.IS_COMPATIBLE;
        }
        catch (RuleViolationException ex) {
            if (verbose) {
                return new CompatibilityCheckResponse(false, ex.getMessage());
            }
            return CompatibilityCheckResponse.IS_NOT_COMPATIBLE;
        }
        catch (UnprocessableSchemaException ex) {
            throw new UnprocessableEntityException(ex.getMessage(), ex);
        }
    }

    private ArtifactMetaDataDto createOrUpdateArtifact(String subject, String schema, String artifactType, List<SchemaReference> references, boolean normalize, String groupId) {
        ArtifactMetaDataDto res;
        List<ArtifactReferenceDto> parsedReferences = this.parseReferences(references, groupId);
        List<ArtifactReference> artifactReferences = parsedReferences.stream().map(dto -> ArtifactReference.builder().name(dto.getName()).groupId(dto.getGroupId()).artifactId(dto.getArtifactId()).version(dto.getVersion()).build()).collect(Collectors.toList());
        Map<String, ContentHandle> resolvedReferences = this.storage.resolveReferences(parsedReferences);
        try {
            ContentHandle schemaContent = normalize ? this.canonicalizeContent(artifactType, ContentHandle.create((String)schema), references) : ContentHandle.create((String)schema);
            if (!this.doesArtifactExist(subject, groupId)) {
                this.rulesService.applyRules(groupId, subject, artifactType, schemaContent, RuleApplicationType.CREATE, artifactReferences, resolvedReferences);
                res = this.storage.createArtifact(groupId, subject, null, artifactType, schemaContent, parsedReferences);
            } else {
                this.rulesService.applyRules(groupId, subject, artifactType, schemaContent, RuleApplicationType.UPDATE, artifactReferences, resolvedReferences);
                res = this.storage.updateArtifact(groupId, subject, null, artifactType, schemaContent, parsedReferences);
            }
        }
        catch (RuleViolationException ex) {
            if (ex.getRuleType() == RuleType.VALIDITY) {
                throw new UnprocessableEntityException(ex.getMessage(), ex);
            }
            throw new ConflictException(ex.getMessage(), ex);
        }
        return res;
    }

    @Override
    public <T> T parseVersionString(String subject, String versionString, String groupId, Function<String, T> then) {
        String version;
        block6: {
            if ("latest".equals(versionString)) {
                version = this.getLatestArtifactVersionForSubject(subject, groupId);
            } else {
                try {
                    int numericVersion = Integer.parseInt(versionString);
                    if (numericVersion >= 0) {
                        version = versionString;
                        break block6;
                    }
                    if (numericVersion == -1) {
                        version = this.getLatestArtifactVersionForSubject(subject, groupId);
                        break block6;
                    }
                    throw new ArtifactNotFoundException("Illegal version format: " + versionString);
                }
                catch (NumberFormatException e) {
                    throw new ArtifactNotFoundException("Illegal version format: " + versionString);
                }
            }
        }
        return then.apply(version);
    }

    private String getLatestArtifactVersionForSubject(String subject, String groupId) {
        try {
            ArtifactMetaDataDto latest = this.storage.getArtifactMetaData(groupId, subject);
            return latest.getVersion();
        }
        catch (ArtifactNotFoundException ex) {
            throw new VersionNotFoundException(groupId, subject, "latest");
        }
    }

    @Override
    public RuleConfigurationDto getGlobalRule(RuleType ruleType) {
        return this.storage.getGlobalRule(ruleType);
    }

    @Override
    public void deleteGlobalRule(RuleType ruleType) {
        this.storage.deleteGlobalRule(ruleType);
    }

    @Override
    public void deleteArtifactRule(String subject, RuleType ruleType, String groupId) {
        try {
            this.storage.deleteArtifactRule(groupId, subject, ruleType);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public RuleConfigurationDto getArtifactRule(String subject, RuleType ruleType, String groupId) {
        return this.storage.getArtifactRule(groupId, subject, ruleType);
    }

    @Override
    public List<Long> getContentIdsReferencingArtifact(String subject, String versionString, String groupId) {
        if (this.cconfig.legacyIdModeEnabled.get().booleanValue()) {
            return this.parseVersionString(subject, versionString, groupId, version -> this.storage.getGlobalIdsReferencingArtifact(groupId, subject, (String)version));
        }
        return this.parseVersionString(subject, versionString, groupId, version -> this.storage.getContentIdsReferencingArtifact(groupId, subject, (String)version));
    }

    private boolean doesArtifactExist(String artifactId, String groupId) {
        try {
            this.storage.getArtifact(groupId, artifactId, RegistryStorage.ArtifactRetrievalBehavior.DEFAULT);
            return true;
        }
        catch (ArtifactNotFoundException ignored) {
            return false;
        }
    }

    private boolean doesArtifactRuleExist(String artifactId, RuleType type, String groupId) {
        try {
            this.storage.getArtifactRule(groupId, artifactId, type);
            return true;
        }
        catch (ArtifactNotFoundException | RuleNotFoundException ignored) {
            return false;
        }
    }

    private boolean doesGlobalRuleExist(RuleType type) {
        try {
            this.storage.getGlobalRule(type);
            return true;
        }
        catch (RuleNotFoundException ignored) {
            return false;
        }
    }

    private List<ArtifactReferenceDto> parseReferences(List<SchemaReference> references, String groupId) {
        if (references != null) {
            return references.stream().map(schemaReference -> {
                this.storage.getArtifactVersionMetaData(groupId, schemaReference.getSubject(), String.valueOf(schemaReference.getVersion()));
                return new ArtifactReferenceDto(groupId, schemaReference.getSubject(), String.valueOf(schemaReference.getVersion()), schemaReference.getName());
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isCcompatManagedType(String artifactType) {
        return artifactType.equals("AVRO") || artifactType.equals("PROTOBUF") || artifactType.equals("JSON");
    }

    private ContentHandle canonicalizeContent(String artifactType, ContentHandle content, List<SchemaReference> references) {
        try {
            ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(artifactType);
            ContentCanonicalizer canonicalizer = provider.getContentCanonicalizer();
            return canonicalizer.canonicalize(content, this.resolveReferences(references));
        }
        catch (Exception e) {
            this.log.debug("Failed to canonicalize content of type: {}", (Object)artifactType);
            return content;
        }
    }
}

