/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.cncf.schemaregistry;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.cncf.schemaregistry.beans.SchemaGroup;
import io.apicurio.registry.cncf.schemaregistry.beans.SchemaId;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/apis/cncf/v0/schemagroups")
public interface SchemagroupsResource {
    @GET
    @Produces(value={"application/json"})
    public List<String> getGroups();

    @Path(value="/{group-id}")
    @GET
    @Produces(value={"application/json"})
    public SchemaGroup getGroup(@PathParam(value="group-id") String var1);

    @Path(value="/{group-id}")
    @PUT
    @Consumes(value={"application/json"})
    @Authorized(style=AuthorizedStyle.GroupOnly)
    public void createGroup(@PathParam(value="group-id") String var1, SchemaGroup var2);

    @Path(value="/{group-id}")
    @DELETE
    @Authorized(style=AuthorizedStyle.GroupOnly)
    public void deleteGroup(@PathParam(value="group-id") String var1);

    @Path(value="/{group-id}/schemas")
    @GET
    @Produces(value={"application/json"})
    public List<String> getSchemasByGroup(@PathParam(value="group-id") String var1);

    @Path(value="/{group-id}/schemas")
    @DELETE
    @Authorized(style=AuthorizedStyle.GroupOnly)
    public void deleteSchemasByGroup(@PathParam(value="group-id") String var1);

    @Path(value="/{group-id}/schemas/{schema-id}")
    @GET
    @Produces(value={"application/json;format=avro"})
    public Response getLatestSchema(@PathParam(value="group-id") String var1, @PathParam(value="schema-id") String var2);

    @Path(value="/{group-id}/schemas/{schema-id}")
    @POST
    @Produces(value={"application/json;format=avro", "application/json;format=protobuf"})
    @Consumes(value={"application/json;format=avro"})
    @Authorized
    public SchemaId createSchema(@PathParam(value="group-id") String var1, @PathParam(value="schema-id") String var2, InputStream var3);

    @Path(value="/{group-id}/schemas/{schema-id}")
    @DELETE
    @Authorized
    public void deleteSchema(@PathParam(value="group-id") String var1, @PathParam(value="schema-id") String var2);

    @Path(value="/{group-id}/schemas/{schema-id}/versions")
    @GET
    @Produces(value={"application/json;format=avro"})
    public List<Integer> getSchemaVersions(@PathParam(value="group-id") String var1, @PathParam(value="schema-id") String var2);

    @Path(value="/{group-id}/schemas/{schema-id}/versions/{version-number}")
    @GET
    @Produces(value={"application/json;format=avro"})
    public Response getSchemaVersion(@PathParam(value="group-id") String var1, @PathParam(value="schema-id") String var2, @PathParam(value="version-number") Integer var3);

    @Path(value="/{group-id}/schemas/{schema-id}/versions/{version-number}")
    @DELETE
    @Authorized
    public void deleteSchemaVersion(@PathParam(value="group-id") String var1, @PathParam(value="schema-id") String var2, @PathParam(value="version-number") Integer var3);
}

