/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events.http;

import io.apicurio.registry.events.EventSink;
import io.apicurio.registry.events.http.HttpSinkConfiguration;
import io.apicurio.registry.events.http.HttpSinksConfiguration;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class HttpEventSink
implements EventSink {
    private HttpClient httpClient;
    @Inject
    Logger log;
    @Inject
    HttpSinksConfiguration sinksConfiguration;

    @Override
    public String name() {
        return "HTTP Sink";
    }

    @Override
    public boolean isConfigured() {
        return this.sinksConfiguration.isConfigured();
    }

    @Override
    public void handle(Message<Buffer> message) {
        String type = message.headers().get("type");
        this.log.info("Firing event " + type);
        for (HttpSinkConfiguration httpSink : this.sinksConfiguration.httpSinks()) {
            this.sendEventHttp(type, httpSink, (Buffer)message.body());
        }
    }

    private void sendEventHttp(String type, HttpSinkConfiguration httpSink, Buffer data) {
        try {
            this.log.debug("Sending event to sink " + httpSink.getName());
            HttpRequest eventRequest = HttpRequest.newBuilder().uri(URI.create(httpSink.getEndpoint())).version(HttpClient.Version.HTTP_1_1).header("ce-id", UUID.randomUUID().toString()).header("ce-specversion", "1.0").header("ce-source", "apicurio-registry").header("ce-type", type).header("content-type", "application/json").POST(HttpRequest.BodyPublishers.ofByteArray(data.getBytes())).build();
            HttpResponse<String> eventResponse = this.getHttpClient().send(eventRequest, HttpResponse.BodyHandlers.ofString());
            if (eventResponse.statusCode() != 200) {
                this.log.warn("Error sending http event: {}", (Object)eventResponse.body());
            }
        }
        catch (Exception e) {
            this.log.error("Error sending http event", (Throwable)e);
        }
    }

    private synchronized HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClient.newBuilder().build();
        }
        return this.httpClient;
    }
}

