/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.metrics.health.liveness;

import io.apicurio.registry.metrics.health.liveness.LivenessUtil;
import io.apicurio.registry.metrics.health.liveness.PersistenceExceptionLivenessApply;
import io.apicurio.registry.metrics.health.liveness.PersistenceExceptionLivenessCheck;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@Priority(value=2000)
@PersistenceExceptionLivenessApply
public class PersistenceExceptionLivenessInterceptor {
    @Inject
    PersistenceExceptionLivenessCheck check;
    @Inject
    LivenessUtil livenessUtil;

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        try {
            return context.proceed();
        }
        catch (Exception ex) {
            if (!this.livenessUtil.isIgnoreError(ex)) {
                this.check.suspectWithException(ex);
            }
            throw ex;
        }
    }
}

