/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.common.apps.multitenancy.TenantContextLoader;
import io.apicurio.common.apps.multitenancy.TenantManagerService;
import io.apicurio.common.apps.util.OptionalBean;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.rest.client.auth.exception.AuthException;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenantList;
import io.apicurio.tenantmanager.api.datamodel.SortBy;
import io.apicurio.tenantmanager.api.datamodel.SortOrder;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import io.apicurio.tenantmanager.client.TenantManagerClient;
import io.quarkus.scheduler.Scheduled;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.slf4j.Logger;

@ApplicationScoped
public class TenantReaper {
    @Inject
    Logger log;
    @Inject
    MultitenancyProperties properties;
    @Inject
    TenantManagerService tenantService;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    TenantContextLoader tcl;
    @Inject
    TenantContext tctx;
    @Inject
    OptionalBean<TenantManagerClient> tenantManagerClient;
    Instant next;
    @ConfigProperty(name="registry.multitenancy.reaper.max-tenants-reaped", defaultValue="100")
    @Info(category="mt", description="Multitenancy reaper max tenants reaped", availableSince="2.1.0.Final")
    int maxTenantsReaped;

    @PostConstruct
    void init() {
        if (!this.properties.isMultitenancyEnabled()) {
            return;
        }
        int stagger = 0;
        if (this.properties.getReaperPeriod().compareTo(Duration.ofSeconds(60L)) >= 0) {
            stagger = new Random().nextInt(30) + 1;
            this.log.debug("Staggering tenant reaper job by {} minutes", (Object)stagger);
        }
        this.next = Instant.now().plus(Duration.ofSeconds((long)stagger * 60L));
    }

    @Scheduled(concurrentExecution=Scheduled.ConcurrentExecution.SKIP, every="{registry.multitenancy.reaper.every}")
    void run() {
        if (!this.properties.isMultitenancyEnabled()) {
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(this.next)) {
            try {
                this.log.debug("Running tenant reaper job at {}", (Object)now);
                this.reap();
                if (this.properties.getReaperPeriod().compareTo(Duration.ofSeconds(60L)) < 0) {
                    this.tcl.invalidateTenantCache();
                }
            }
            catch (Exception ex) {
                this.log.error("Exception thrown when running tenant reaper job", (Throwable)ex);
            }
            finally {
                this.next = now.plus(this.properties.getReaperPeriod());
                this.log.debug("Running next tenant reaper job at around {}", (Object)this.next);
            }
        }
    }

    @Retry(retryOn={AuthException.class})
    void reap() {
        List page;
        int tenantsProcessed = 0;
        do {
            ApicurioTenantList tenants = ((TenantManagerClient)this.tenantManagerClient.get()).listTenants(TenantStatusValue.TO_BE_DELETED, Integer.valueOf(0), Integer.valueOf(10), SortOrder.asc, SortBy.tenantId);
            page = tenants.getItems();
            for (ApicurioTenant tenant : page) {
                String tenantId = tenant.getTenantId();
                try {
                    this.log.debug("Deleting tenant '{}' data", (Object)tenantId);
                    this.tcl.invalidateTenantInCache(tenantId);
                    this.tctx.setContext(this.tcl.loadBatchJobContext(tenantId));
                    if (tenant.getStatus() != TenantStatusValue.TO_BE_DELETED || !tenantId.equals(this.tctx.tenantId())) {
                        this.log.debug("Safety: tenant.getStatus() = {}, tenantId = {}, ctx.tenantId() = {}", new Object[]{tenant.getStatus(), tenantId, this.tctx.tenantId()});
                        throw new IllegalStateException("Safety check failed when attempting to delete tenant data.");
                    }
                    this.storage.deleteAllUserData();
                    this.tenantService.markTenantAsDeleted(tenantId);
                    this.tcl.invalidateTenantInCache(tenantId);
                }
                catch (Exception ex) {
                    this.log.warn("Exception thrown when reaping tenant '" + tenantId + "'", (Throwable)ex);
                }
            }
        } while (!page.isEmpty() && (tenantsProcessed += page.size()) < this.maxTenantsReaped);
    }
}

