/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;

@PreMatching
@Priority(value=5000)
@Provider
public class CompatibilityV1ApiRequestFilter
implements ContainerRequestFilter {
    @Inject
    Logger log;
    public static final String V1_API_OLD_PATH = "/api/";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        URI reqUri = requestContext.getUriInfo().getRequestUri();
        String uri = reqUri.getPath();
        if (uri.startsWith(V1_API_OLD_PATH)) {
            this.log.warn("Rewriting request to v1 API old path, it's recommended to update your clients to the new version and use the \"/apis/registry/v2\" api or at least update your clients configuration to use the new path for the v1 api \"/apis/registry/v1\"");
            String newUri = uri.replaceFirst(V1_API_OLD_PATH, "/apis/registry/v1/");
            this.log.debug("New uri {}", (Object)newUri);
            requestContext.setRequestUri(UriBuilder.fromUri((URI)reqUri).replacePath(newUri).build(new Object[0]));
        }
    }
}

