/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v1;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.v1.SearchResource;
import io.apicurio.registry.rest.v1.V1ApiUtil;
import io.apicurio.registry.rest.v1.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v1.beans.SearchOver;
import io.apicurio.registry.rest.v1.beans.SortOrder;
import io.apicurio.registry.rest.v1.beans.VersionSearchResults;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchFilterType;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.types.Current;
import java.util.HashSet;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.Interceptors;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
@Deprecated
public class SearchResourceImpl
implements SearchResource {
    @Inject
    @Current
    RegistryStorage registryStorage;

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public ArtifactSearchResults searchArtifacts(String search, Integer offset, Integer limit, SearchOver searchOver, SortOrder sortOrder) {
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = 10;
        }
        OrderBy orderBy = OrderBy.name;
        OrderDirection orderDir = sortOrder == null || sortOrder == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        SearchOver over = searchOver == null ? SearchOver.everything : searchOver;
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        if (search != null && !search.trim().isEmpty()) {
            SearchFilter filter = new SearchFilter();
            filter.setStringValue(search);
            filters.add(filter);
            switch (over) {
                case description: {
                    filter.setType(SearchFilterType.description);
                    break;
                }
                case labels: {
                    filter.setType(SearchFilterType.labels);
                    break;
                }
                case name: {
                    filter.setType(SearchFilterType.name);
                    break;
                }
                default: {
                    filter.setType(SearchFilterType.everything);
                }
            }
        }
        ArtifactSearchResultsDto results = this.registryStorage.searchArtifacts(filters, orderBy, orderDir, offset, limit);
        return V1ApiUtil.dtoToSearchResults(results);
    }

    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public VersionSearchResults searchVersions(String artifactId, Integer offset, Integer limit) {
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = 10;
        }
        VersionSearchResultsDto results = this.registryStorage.searchVersions(null, artifactId, offset, limit);
        return V1ApiUtil.dtoToSearchResults(results);
    }
}

