/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2.shared;

import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.utils.impexp.EntityWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipOutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;

@ApplicationScoped
public class DataExporter {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;

    public Response exportData() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                try {
                    ZipOutputStream zip = new ZipOutputStream(os, StandardCharsets.UTF_8);
                    EntityWriter writer = new EntityWriter(zip);
                    AtomicInteger errorCounter = new AtomicInteger(0);
                    DataExporter.this.storage.exportData(entity -> {
                        try {
                            writer.writeEntity(entity);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errorCounter.incrementAndGet();
                        }
                        return null;
                    });
                    zip.flush();
                    zip.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
        return Response.ok((Object)stream).type("application/zip").build();
    }
}

