/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleApplicationType;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleExecutor;
import io.apicurio.registry.rules.RuleExecutorFactory;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.RulesProperties;
import io.apicurio.registry.rules.RulesService;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.LazyContentList;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class RulesServiceImpl
implements RulesService {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RuleExecutorFactory factory;
    @Inject
    RulesProperties rulesProperties;

    @Override
    public void applyRules(String groupId, String artifactId, String artifactType, ContentHandle artifactContent, RuleApplicationType ruleApplicationType, List<ArtifactReference> references, Map<String, ContentHandle> resolvedReferences) throws RuleViolationException {
        List<RuleType> rules = Collections.EMPTY_LIST;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            rules = this.storage.getArtifactRules(groupId, artifactId);
        }
        LazyContentList currentContent = null;
        currentContent = ruleApplicationType == RuleApplicationType.UPDATE ? new LazyContentList(this.storage, this.storage.getArtifactContentIds(groupId, artifactId)) : new LazyContentList(this.storage, Collections.emptyList());
        this.applyGlobalAndArtifactRules(groupId, artifactId, artifactType, currentContent, artifactContent, rules, references, resolvedReferences);
    }

    private void applyGlobalAndArtifactRules(String groupId, String artifactId, String artifactType, List<ContentHandle> currentArtifactContent, ContentHandle updatedArtifactContent, List<RuleType> artifactRules, List<ArtifactReference> references, Map<String, ContentHandle> resolvedReferences) {
        Map<RuleType, RuleConfigurationDto> globalOrArtifactRulesMap = artifactRules.stream().collect(Collectors.toMap(ruleType -> ruleType, ruleType -> this.storage.getArtifactRule(groupId, artifactId, (RuleType)ruleType)));
        if (globalOrArtifactRulesMap.isEmpty()) {
            List<RuleType> globalRules = this.storage.getGlobalRules();
            globalOrArtifactRulesMap = globalRules.stream().collect(Collectors.toMap(ruleType -> ruleType, this.storage::getGlobalRule));
            Map<RuleType, RuleConfigurationDto> filteredDefaultGlobalRulesMap = this.rulesProperties.getFilteredDefaultGlobalRules(globalRules).stream().collect(Collectors.toMap(ruleType -> ruleType, this.rulesProperties::getDefaultGlobalRuleConfiguration));
            globalOrArtifactRulesMap.putAll(filteredDefaultGlobalRulesMap);
        }
        if (globalOrArtifactRulesMap.isEmpty()) {
            return;
        }
        for (RuleType ruleType2 : globalOrArtifactRulesMap.keySet()) {
            this.applyRule(groupId, artifactId, artifactType, currentArtifactContent, updatedArtifactContent, ruleType2, globalOrArtifactRulesMap.get(ruleType2).getConfiguration(), references, resolvedReferences);
        }
    }

    @Override
    public void applyRule(String groupId, String artifactId, String artifactType, ContentHandle artifactContent, RuleType ruleType, String ruleConfiguration, RuleApplicationType ruleApplicationType, List<ArtifactReference> references, Map<String, ContentHandle> resolvedReferences) throws RuleViolationException {
        LazyContentList currentContent = null;
        if (ruleApplicationType == RuleApplicationType.UPDATE) {
            currentContent = new LazyContentList(this.storage, this.storage.getArtifactContentIds(groupId, artifactId));
        }
        this.applyRule(groupId, artifactId, artifactType, currentContent, artifactContent, ruleType, ruleConfiguration, references, resolvedReferences);
    }

    private void applyRule(String groupId, String artifactId, String artifactType, List<ContentHandle> currentContent, ContentHandle updatedContent, RuleType ruleType, String ruleConfiguration, List<ArtifactReference> references, Map<String, ContentHandle> resolvedReferences) {
        RuleExecutor executor = this.factory.createExecutor(ruleType);
        RuleContext context = new RuleContext(groupId, artifactId, artifactType, ruleConfiguration, currentContent, updatedContent, references, resolvedReferences);
        executor.execute(context);
    }

    @Override
    public void applyRules(String groupId, String artifactId, String artifactVersion, String artifactType, ContentHandle updatedContent, List<ArtifactReference> references, Map<String, ContentHandle> resolvedReferences) throws RuleViolationException {
        StoredArtifactDto versionContent = this.storage.getArtifactVersion(groupId, artifactId, artifactVersion);
        this.applyGlobalAndArtifactRules(groupId, artifactId, artifactType, Collections.singletonList(versionContent.getContent()), updatedContent, this.storage.getArtifactRules(groupId, artifactId), references, resolvedReferences);
    }
}

