/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services;

import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.quarkus.runtime.StartupEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class DisabledApisMatcherService {
    @Inject
    Logger log;
    private static final String UI_PATTERN = "/ui/.*";
    private final List<Pattern> disabledPatternsList = new ArrayList<Pattern>();
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    @ConfigProperty(name="registry.disable.apis")
    @Info(category="api", description="Disable APIs", availableSince="2.0.0.Final")
    Optional<List<String>> disableRegexps;

    public void init(@Observes StartupEvent ev) {
        ArrayList<String> regexps = new ArrayList<String>();
        if (this.mtProperties.isMultitenancyEnabled()) {
            this.log.debug("Adding UI to disabled APIs, direct access to UI is disabled in multitenancy deployments");
            regexps.add(UI_PATTERN);
        }
        this.disableRegexps.ifPresent(regexps::addAll);
        for (String regexp : regexps) {
            try {
                Pattern p = Pattern.compile(regexp);
                this.disabledPatternsList.add(p);
            }
            catch (PatternSyntaxException e) {
                this.log.error("An error occurred parsing a regexp for disabling APIs: " + regexp, (Throwable)e);
            }
        }
    }

    public boolean isDisabled(String requestPath) {
        for (Pattern pattern : this.disabledPatternsList) {
            if (!pattern.matcher(requestPath).matches()) continue;
            this.log.warn("Request {} is rejected because it's disabled by pattern {}", (Object)requestPath, (Object)pattern.pattern());
            return true;
        }
        return false;
    }
}

