/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.services;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.storage.LogConfigurationNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.LogConfigurationDto;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.LogLevel;
import io.quarkus.scheduler.Scheduled;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class LogConfigurationService {
    @Inject
    Logger LOGGER;
    @Inject
    @Current
    RegistryStorage storage;
    @ConfigProperty(name="quarkus.log.level")
    @Info(category="log", description="Log level", availableSince="2.0.0.Final")
    String defaultLogLevel;

    @Scheduled(concurrentExecution=Scheduled.ConcurrentExecution.SKIP, delayed="{registry.logconfigjob.delayed}", every="{registry.logconfigjob.every}")
    public void checkLogLevel() {
        if (!this.storage.isAlive() || !this.storage.isReady()) {
            return;
        }
        this.LOGGER.trace("Running periodic log configuration process");
        for (LogConfigurationDto logConfig : this.storage.listLogConfigurations()) {
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(logConfig.getLogger());
            Level expectedLevel = Level.parse(logConfig.getLogLevel().value());
            if (!this.getLogLevel(logger).equals(expectedLevel)) {
                this.LOGGER.info(String.format("Updating logger %s to log level %s", logConfig.getLogger(), logConfig.getLogLevel().value()));
                logger.setLevel(expectedLevel);
            }
            if (!logConfig.getLogLevel().value().equals(this.defaultLogLevel)) continue;
            this.LOGGER.info(String.format("Cleaning persisted config for logger %s because default log level is configured %s", logConfig.getLogger(), logConfig.getLogLevel().value()));
            this.storage.removeLogConfiguration(logConfig.getLogger());
        }
    }

    public List<NamedLogConfiguration> listLogConfigurations() {
        return this.storage.listLogConfigurations().stream().map(c -> {
            NamedLogConfiguration lc = new NamedLogConfiguration();
            lc.setName(c.getLogger());
            lc.setLevel(c.getLogLevel());
            return lc;
        }).collect(Collectors.toList());
    }

    public NamedLogConfiguration getLogConfiguration(String loggerName) {
        LogConfigurationDto logConfig = null;
        try {
            logConfig = this.storage.getLogConfiguration(loggerName);
        }
        catch (LogConfigurationNotFoundException logConfigurationNotFoundException) {
            // empty catch block
        }
        java.util.logging.Logger targetLogger = java.util.logging.Logger.getLogger(loggerName);
        Level actualLevel = this.getLogLevel(targetLogger);
        if (logConfig == null) {
            NamedLogConfiguration named = new NamedLogConfiguration();
            named.setName(loggerName);
            named.setLevel(LogLevel.fromValue((String)actualLevel.getName()));
            return named;
        }
        Level expectedLevel = Level.parse(logConfig.getLogLevel().value());
        if (!actualLevel.equals(expectedLevel)) {
            this.LOGGER.info(String.format("Log configuration not applied, forcing logger update, logger %s to log level %s", logConfig.getLogger(), logConfig.getLogLevel().value()));
            targetLogger.setLevel(expectedLevel);
        }
        NamedLogConfiguration named = new NamedLogConfiguration();
        named.setName(loggerName);
        named.setLevel(logConfig.getLogLevel());
        return named;
    }

    public NamedLogConfiguration setLogLevel(String loggerName, LogLevel logLevel) {
        try {
            this.LOGGER.info("Changing log level for logger " + loggerName + " to " + logLevel);
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(loggerName);
            logger.setLevel(Level.parse(logLevel.value()));
        }
        catch (Exception e) {
            throw new BadRequestException("level is not a valid log level");
        }
        this.storage.setLogConfiguration(new LogConfigurationDto(loggerName, logLevel));
        NamedLogConfiguration named = new NamedLogConfiguration();
        named.setName(loggerName);
        named.setLevel(logLevel);
        return named;
    }

    public NamedLogConfiguration removeLogLevelConfiguration(String loggerName) {
        return this.setLogLevel(loggerName, LogLevel.fromValue((String)this.defaultLogLevel));
    }

    private Level getLogLevel(java.util.logging.Logger logger) {
        for (java.util.logging.Logger current = logger; current != null; current = current.getParent()) {
            Level level = current.getLevel();
            if (level == null) continue;
            return level;
        }
        return Level.parse(this.defaultLogLevel);
    }
}

