/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.common.apps.config.DynamicConfigStorage;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RegistryStorageProvider;
import io.apicurio.registry.storage.decorator.RegistryStorageDecorator;
import io.apicurio.registry.storage.impl.sql.InMemoryRegistryStorage;
import io.apicurio.registry.types.Current;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryStorageProducer {
    @Inject
    Logger log;
    @Inject
    Instance<InMemoryRegistryStorage> defaultStorage;
    @Inject
    Instance<RegistryStorageProvider> provider;
    @Inject
    Instance<RegistryStorageDecorator> decorators;
    private RegistryStorage cachedImpl;

    @Produces
    @ApplicationScoped
    @Current
    public RegistryStorage realImpl() {
        if (this.cachedImpl != null) {
            return this.cachedImpl;
        }
        this.cachedImpl = this.provider.isResolvable() ? ((RegistryStorageProvider)this.provider.get()).storage() : (RegistryStorage)this.defaultStorage.get();
        if (this.cachedImpl != null) {
            this.log.info(String.format("Using RegistryStore: %s", this.cachedImpl.getClass().getName()));
            Comparator<RegistryStorageDecorator> decoratorsComparator = Comparator.comparing(RegistryStorageDecorator::order);
            List<RegistryStorageDecorator> declist = this.decorators.stream().filter(RegistryStorageDecorator::isEnabled).sorted(decoratorsComparator).collect(Collectors.toList());
            if (!declist.isEmpty()) {
                this.log.debug("RegistryStorage decorators");
                declist.forEach(d -> this.log.debug(d.getClass().getName()));
            }
            for (int i = declist.size() - 1; i >= 0; --i) {
                RegistryStorageDecorator decorator = (RegistryStorageDecorator)declist.get(i);
                decorator.setDelegate(this.cachedImpl);
                this.cachedImpl = decorator;
            }
            return this.cachedImpl;
        }
        throw new IllegalStateException("No RegistryStorage available on the classpath!");
    }

    @Produces
    @ApplicationScoped
    public DynamicConfigStorage configStorage() {
        return this.realImpl();
    }
}

