/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.dto;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.RegistryStorage;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class LazyContentList
implements List<ContentHandle> {
    private final RegistryStorage storage;
    private final List<Long> contentIds;

    public LazyContentList(RegistryStorage storage, List<Long> contentIds) {
        this.storage = storage;
        this.contentIds = contentIds;
    }

    @Override
    public int size() {
        return this.contentIds.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contentIds.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContentHandle get(int index) {
        return this.storage.getArtifactByContentId(this.contentIds.get(index)).getContent();
    }

    @Override
    public ContentHandle set(int index, ContentHandle element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, ContentHandle element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContentHandle remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ListIterator<ContentHandle> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ListIterator<ContentHandle> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<ContentHandle> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Iterator<ContentHandle> iterator() {
        return new LazyContentListIterator(this, this.contentIds.iterator());
    }

    @Override
    @NotNull
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(ContentHandle contentHandle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends ContentHandle> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends ContentHandle> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<ContentHandle> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(Consumer<? super ContentHandle> action) {
        for (Long contentId : this.contentIds) {
            ContentHandle retrievedContent = this.storage.getArtifactByContentId(contentId).getContent();
            action.accept((ContentHandle)retrievedContent);
        }
    }

    public List<Long> getContentIds() {
        return this.contentIds;
    }

    public ContentHandle getContentById(long contentId) {
        if (this.contentIds.contains(contentId)) {
            return this.storage.getArtifactByContentId(contentId).getContent();
        }
        throw new NoSuchElementException(String.format("No content found with id %d", contentId));
    }

    private static class LazyContentListIterator
    implements Iterator<ContentHandle> {
        private final LazyContentList lazyContentList;
        private final Iterator<Long> contentIdsIterator;

        private LazyContentListIterator(LazyContentList lazyContentList, Iterator<Long> contentIdsIterator) {
            this.lazyContentList = lazyContentList;
            this.contentIdsIterator = contentIdsIterator;
        }

        @Override
        public boolean hasNext() {
            return this.contentIdsIterator.hasNext();
        }

        @Override
        public ContentHandle next() {
            Long nextContentId = this.contentIdsIterator.next();
            return this.lazyContentList.getContentById(nextContentId);
        }

        @Override
        public void remove() {
            this.contentIdsIterator.remove();
        }
    }
}

