/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.content.extract.ContentExtractor;
import io.apicurio.registry.content.extract.ExtractedMetaData;
import io.apicurio.registry.exception.UnreachableCodeException;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ArtifactStateExt;
import io.apicurio.registry.storage.CommentNotFoundException;
import io.apicurio.registry.storage.ContentNotFoundException;
import io.apicurio.registry.storage.DownloadNotFoundException;
import io.apicurio.registry.storage.GroupAlreadyExistsException;
import io.apicurio.registry.storage.GroupNotFoundException;
import io.apicurio.registry.storage.LogConfigurationNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.RoleMappingAlreadyExistsException;
import io.apicurio.registry.storage.RoleMappingNotFoundException;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.StorageBehaviorProperties;
import io.apicurio.registry.storage.StorageEvent;
import io.apicurio.registry.storage.StorageEventType;
import io.apicurio.registry.storage.StorageException;
import io.apicurio.registry.storage.VersionAlreadyExistsException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactOwnerDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.LogConfigurationDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.SearchFilterType;
import io.apicurio.registry.storage.dto.SearchedArtifactDto;
import io.apicurio.registry.storage.dto.SearchedGroupDto;
import io.apicurio.registry.storage.dto.SearchedVersionDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.impexp.EntityInputStream;
import io.apicurio.registry.storage.impl.sql.ContentIdNotPreserveSqlDataImporter;
import io.apicurio.registry.storage.impl.sql.HandleFactory;
import io.apicurio.registry.storage.impl.sql.IDbUpgrader;
import io.apicurio.registry.storage.impl.sql.IdGenerator;
import io.apicurio.registry.storage.impl.sql.SqlDataImporter;
import io.apicurio.registry.storage.impl.sql.SqlStatementVariableBinder;
import io.apicurio.registry.storage.impl.sql.SqlStatements;
import io.apicurio.registry.storage.impl.sql.SqlStorageEvent;
import io.apicurio.registry.storage.impl.sql.SqlStorageEventType;
import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.storage.impl.sql.jdb.Query;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.storage.impl.sql.jdb.Update;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactMetaDataDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactReferenceDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactRuleEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactVersionEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ArtifactVersionMetaDataDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.CommentDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.CommentEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ContentEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.ContentMapper;
import io.apicurio.registry.storage.impl.sql.mappers.DynamicConfigPropertyDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.GlobalRuleEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.GroupEntityMapper;
import io.apicurio.registry.storage.impl.sql.mappers.GroupMetaDataDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.LogConfigurationMapper;
import io.apicurio.registry.storage.impl.sql.mappers.RoleMappingDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.RuleConfigurationDtoMapper;
import io.apicurio.registry.storage.impl.sql.mappers.SearchedArtifactMapper;
import io.apicurio.registry.storage.impl.sql.mappers.SearchedGroupMapper;
import io.apicurio.registry.storage.impl.sql.mappers.SearchedVersionMapper;
import io.apicurio.registry.storage.impl.sql.mappers.StoredArtifactMapper;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.DtoUtil;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.StringUtil;
import io.apicurio.registry.utils.impexp.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.CommentEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.GroupEntity;
import io.apicurio.registry.utils.impexp.ManifestEntity;
import io.quarkus.security.identity.SecurityIdentity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

public abstract class AbstractSqlRegistryStorage
implements RegistryStorage {
    private static int DB_VERSION = Integer.valueOf(IoUtil.toString((InputStream)AbstractSqlRegistryStorage.class.getResourceAsStream("db-version")));
    private static final Object inmemorySequencesMutex = new Object();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String GLOBAL_ID_SEQUENCE = "globalId";
    private static final String CONTENT_ID_SEQUENCE = "contentId";
    private static final String COMMENT_ID_SEQUENCE = "commentId";
    @Inject
    Logger log;
    @Inject
    TenantContext tenantContext;
    @Inject
    io.apicurio.common.apps.core.System system;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Inject
    SqlStatements sqlStatements;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    ArtifactStateExt artifactStateEx;
    @Inject
    HandleFactory handles;
    @Inject
    StorageBehaviorProperties storageBehaviorProps;
    @ConfigProperty(name="registry.sql.init", defaultValue="true")
    @Info(category="store", description="SQL init", availableSince="2.0.0.Final")
    boolean initDB;
    @ConfigProperty(name="quarkus.datasource.jdbc.url")
    @Info(category="store", description="Datasource jdbc URL", availableSince="2.1.0.Final")
    String jdbcUrl;
    @Inject
    Event<SqlStorageEvent> sqlStorageEvent;
    @Inject
    Event<StorageEvent> storageEvent;
    private volatile boolean isReady = false;
    private volatile Instant isAliveLastCheck = Instant.MIN;
    private volatile boolean isAliveCached = false;
    private boolean emitStorageReadyEvent;

    protected TenantContext tenantContext() {
        return this.tenantContext;
    }

    protected SqlStatements sqlStatements() {
        return this.sqlStatements;
    }

    protected AbstractSqlRegistryStorage(boolean emitStorageReadyEvent) {
        this.emitStorageReadyEvent = emitStorageReadyEvent;
    }

    @PostConstruct
    @Transactional
    void initialize() {
        this.log.info("SqlRegistryStorage constructed successfully.  JDBC URL: " + this.jdbcUrl);
        this.handles.withHandleNoException(handle -> {
            if (this.initDB) {
                if (!this.isDatabaseInitialized(handle)) {
                    this.log.info("Database not initialized.");
                    this.initializeDatabase(handle);
                } else {
                    this.log.info("Database was already initialized, skipping.");
                }
                if (!this.isDatabaseCurrent(handle)) {
                    this.log.info("Old database version detected, upgrading.");
                    this.upgradeDatabase(handle);
                }
            } else {
                if (!this.isDatabaseInitialized(handle)) {
                    this.log.error("Database not initialized.  Please use the DDL scripts to initialize the database before starting the application.");
                    throw new RuntimeException("Database not initialized.");
                }
                if (!this.isDatabaseCurrent(handle)) {
                    this.log.error("Detected an old version of the database.  Please use the DDL upgrade scripts to bring your database up to date.");
                    throw new RuntimeException("Database not upgraded.");
                }
            }
            return null;
        });
        this.isReady = true;
        SqlStorageEvent initializeEvent = new SqlStorageEvent();
        initializeEvent.setType(SqlStorageEventType.READY);
        this.sqlStorageEvent.fire((Object)initializeEvent);
        if (this.emitStorageReadyEvent) {
            this.storageEvent.fireAsync((Object)StorageEvent.builder().type(StorageEventType.READY).build());
        }
    }

    private boolean isDatabaseInitialized(Handle handle) {
        this.log.info("Checking to see if the DB is initialized.");
        int count = handle.createQuery(this.sqlStatements.isDatabaseInitialized()).mapTo(Integer.class).one();
        return count > 0;
    }

    private boolean isDatabaseCurrent(Handle handle) {
        this.log.info("Checking to see if the DB is up-to-date.");
        this.log.info("Build's DB version is {}", (Object)DB_VERSION);
        int version = this.getDatabaseVersion(handle);
        return version == DB_VERSION;
    }

    private void initializeDatabase(Handle handle) {
        this.log.info("Initializing the Apicurio Registry database.");
        this.log.info("\tDatabase type: " + this.sqlStatements.dbType());
        List<String> statements = this.sqlStatements.databaseInitialization();
        this.log.debug("---");
        statements.forEach(statement -> {
            this.log.debug(statement);
            handle.createUpdate((String)statement).execute();
        });
        this.log.debug("---");
    }

    private void upgradeDatabase(Handle handle) {
        this.log.info("Upgrading the Apicurio Hub API database.");
        int fromVersion = this.getDatabaseVersion(handle);
        int toVersion = DB_VERSION;
        this.log.info("\tDatabase type: {}", (Object)this.sqlStatements.dbType());
        this.log.info("\tFrom Version:  {}", (Object)fromVersion);
        this.log.info("\tTo Version:    {}", (Object)toVersion);
        List<String> statements = this.sqlStatements.databaseUpgrade(fromVersion, toVersion);
        this.log.debug("---");
        statements.forEach(statement -> {
            this.log.debug(statement);
            if (statement.startsWith("UPGRADER:")) {
                String cname = statement.substring(9).trim();
                this.applyUpgrader(handle, cname);
            } else {
                handle.createUpdate((String)statement).execute();
            }
        });
        this.log.debug("---");
    }

    private void applyUpgrader(Handle handle, String cname) {
        try {
            Class<?> upgraderClass = Class.forName(cname);
            IDbUpgrader upgrader = (IDbUpgrader)upgraderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            upgrader.upgrade(handle);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int getDatabaseVersion(Handle handle) {
        try {
            int version = ((Query)handle.createQuery(this.sqlStatements.getDatabaseVersion()).bind(0, "db_version")).mapTo(Integer.class).one();
            return version;
        }
        catch (Exception e) {
            this.log.error("Error getting DB version.", (Throwable)e);
            return 0;
        }
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public boolean isAlive() {
        if (!this.isReady) {
            return false;
        }
        if (Instant.now().isAfter(this.isAliveLastCheck.plus(Duration.ofSeconds(2L)))) {
            this.isAliveLastCheck = Instant.now();
            try {
                this.getGlobalRules();
                this.isAliveCached = true;
            }
            catch (Exception ex) {
                this.isAliveCached = false;
            }
        }
        return this.isAliveCached;
    }

    @Override
    public String storageName() {
        return "sql";
    }

    @Override
    public boolean supportsMultiTenancy() {
        return true;
    }

    @Override
    public ContentWrapperDto getArtifactByContentId(long contentId) throws ContentNotFoundException, RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectContentById();
            Optional<ContentWrapperDto> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, contentId)).map(ContentMapper.instance).findFirst();
            return res.orElseThrow(() -> new ContentNotFoundException("contentId-" + contentId));
        });
    }

    @Override
    public ContentWrapperDto getArtifactByContentHash(String contentHash) throws ContentNotFoundException, RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectContentByContentHash();
            Optional<ContentWrapperDto> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, contentHash)).map(ContentMapper.instance).findFirst();
            return res.orElseThrow(() -> new ContentNotFoundException("contentHash-" + contentHash));
        });
    }

    @Override
    public List<ArtifactMetaDataDto> getArtifactVersionsByContentId(long contentId) {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectArtifactVersionMetaDataByContentId();
            List<ArtifactMetaDataDto> dtos = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, contentId)).map(ArtifactMetaDataDtoMapper.instance).list();
            if (dtos.isEmpty()) {
                throw new ContentNotFoundException("contentId-" + contentId);
            }
            return dtos;
        });
    }

    @Override
    public List<Long> getArtifactContentIds(String groupId, String artifactId) {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectArtifactContentIds();
            return ((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).mapTo(Long.class).list();
        });
    }

    @Override
    @Transactional
    public void updateArtifactState(String groupId, String artifactId, ArtifactState state) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Updating the state of artifact {} {} to {}", new Object[]{groupId, artifactId, state.name()});
        ArtifactMetaDataDto dto = this.getLatestArtifactMetaDataInternal(groupId, artifactId, RegistryStorage.ArtifactRetrievalBehavior.DEFAULT);
        this.handles.withHandleNoException(handle -> {
            long globalId = dto.getGlobalId();
            ArtifactState oldState = dto.getState();
            ArtifactState newState = state;
            this.artifactStateEx.applyState(s -> {
                String sql = this.sqlStatements.updateArtifactVersionState();
                int rowCount = ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, s.name())).bind(1, this.tenantContext.tenantId())).bind(2, globalId)).execute();
                if (rowCount == 0) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
            }, oldState, newState);
            return null;
        });
    }

    @Override
    @Transactional
    public void updateArtifactState(String groupId, String artifactId, String version, ArtifactState state) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Updating the state of artifact {} {}, version {} to {}", new Object[]{groupId, artifactId, version, state.name()});
        ArtifactVersionMetaDataDto dto = this.getArtifactVersionMetaData(groupId, artifactId, version);
        this.handles.withHandleNoException(handle -> {
            ArtifactState newState;
            long globalId = dto.getGlobalId();
            ArtifactState oldState = dto.getState();
            if (oldState != (newState = state)) {
                this.artifactStateEx.applyState(s -> {
                    String sql = this.sqlStatements.updateArtifactVersionState();
                    int rowCount = ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, s.name())).bind(1, this.tenantContext.tenantId())).bind(2, globalId)).execute();
                    if (rowCount == 0) {
                        throw new VersionNotFoundException(groupId, artifactId, dto.getVersion());
                    }
                }, oldState, newState);
            }
            return null;
        });
    }

    @Override
    @Transactional
    public ArtifactMetaDataDto createArtifact(String groupId, String artifactId, String version, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) throws ArtifactAlreadyExistsException, ArtifactNotFoundException, RegistryStorageException {
        return this.createArtifact(groupId, artifactId, version, artifactType, content, references, null);
    }

    protected ArtifactMetaDataDto createArtifact(String groupId, String artifactId, String version, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references, IdGenerator globalIdGenerator) throws ArtifactAlreadyExistsException, ArtifactNotFoundException, RegistryStorageException {
        return this.createArtifactWithMetadata(groupId, artifactId, version, artifactType, content, null, references, globalIdGenerator);
    }

    private ArtifactVersionMetaDataDto createArtifactVersion(Handle handle, String artifactType, boolean firstVersion, String groupId, String artifactId, String version, String name, String description, List<String> labels, Map<String, String> properties, String createdBy, Date createdOn, Long contentId, IdGenerator globalIdGenerator) {
        ArtifactState state = ArtifactState.ENABLED;
        String labelsStr = SqlUtil.serializeLabels(labels);
        String propertiesStr = SqlUtil.serializeProperties(properties);
        if (globalIdGenerator == null) {
            globalIdGenerator = new IdGenerator(){

                @Override
                public Long generate(Handle handle) {
                    return AbstractSqlRegistryStorage.this.nextGlobalId(handle);
                }
            };
        }
        Long globalId = globalIdGenerator.generate(handle);
        String sql = this.sqlStatements.insertVersion(firstVersion);
        if (firstVersion) {
            if (version == null) {
                version = "1";
            }
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, globalId)).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).bind(4, version)).bind(5, (Enum<?>)state)).bind(6, AbstractSqlRegistryStorage.limitStr(name, 512))).bind(7, AbstractSqlRegistryStorage.limitStr(description, 1024, true))).bind(8, createdBy)).bind(9, createdOn)).bind(10, labelsStr)).bind(11, propertiesStr)).bind(12, contentId)).execute();
        } else {
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, globalId)).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).bind(4, version)).bind(5, this.tenantContext.tenantId())).bind(6, SqlUtil.normalizeGroupId(groupId))).bind(7, artifactId)).bind(8, (Enum<?>)state)).bind(9, AbstractSqlRegistryStorage.limitStr(name, 512))).bind(10, AbstractSqlRegistryStorage.limitStr(description, 1024, true))).bind(11, createdBy)).bind(12, createdOn)).bind(13, labelsStr)).bind(14, propertiesStr)).bind(15, contentId)).execute();
            if (version == null) {
                sql = this.sqlStatements.autoUpdateVersionForGlobalId();
                ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).bind(2, this.tenantContext.tenantId())).bind(3, globalId)).execute();
            }
        }
        if (labels != null && !labels.isEmpty()) {
            labels.forEach(label -> {
                String sqli = this.sqlStatements.insertLabel();
                ((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).bind(2, AbstractSqlRegistryStorage.limitStr(label.toLowerCase(), 256))).execute();
            });
        }
        if (properties != null && !properties.isEmpty()) {
            properties.forEach((k, v) -> {
                String sqli = this.sqlStatements.insertProperty();
                ((Update)((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).bind(2, AbstractSqlRegistryStorage.limitStr(k.toLowerCase(), 256))).bind(3, AbstractSqlRegistryStorage.limitStr(v.toLowerCase(), 1024))).execute();
            });
        }
        sql = this.sqlStatements.updateArtifactLatest();
        ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, globalId)).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).execute();
        sql = this.sqlStatements.selectArtifactVersionMetaDataByGlobalId();
        return ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).map(ArtifactVersionMetaDataDtoMapper.instance).one();
    }

    protected Long createOrUpdateContent(Handle handle, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) throws IOException {
        String canonicalContentHash;
        String contentHash;
        byte[] contentBytes = content.bytes();
        ContentHandle canonicalContent = this.canonicalizeContent(artifactType, content, references);
        byte[] canonicalContentBytes = canonicalContent.bytes();
        String referencesSerialized = SqlUtil.serializeReferences(references);
        if (referencesSerialized != null) {
            contentHash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(contentBytes, referencesSerialized));
            canonicalContentHash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(canonicalContentBytes, referencesSerialized));
        } else {
            contentHash = DigestUtils.sha256Hex((byte[])contentBytes);
            canonicalContentHash = DigestUtils.sha256Hex((byte[])canonicalContentBytes);
        }
        return this.createOrUpdateContent(handle, content, contentHash, canonicalContentHash, references, referencesSerialized);
    }

    private byte[] concatContentAndReferences(byte[] contentBytes, String references) throws IOException {
        if (references != null) {
            byte[] referencesBytes = references.getBytes(StandardCharsets.UTF_8);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(contentBytes.length + referencesBytes.length);
            outputStream.write(contentBytes);
            outputStream.write(referencesBytes);
            return outputStream.toByteArray();
        }
        return contentBytes;
    }

    protected Long createOrUpdateContent(Handle handle, ContentHandle content, String contentHash, String canonicalContentHash, List<ArtifactReferenceDto> references, String referencesSerialized) {
        Long contentId;
        byte[] contentBytes = content.bytes();
        boolean insertReferences = true;
        if (Set.of("mysql", "mssql", "postgresql").contains(this.sqlStatements.dbType())) {
            String sql = this.sqlStatements.upsertContent();
            ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.nextContentId(handle))).bind(2, canonicalContentHash)).bind(3, contentHash)).bind(4, contentBytes)).bind(5, referencesSerialized)).execute();
            sql = this.sqlStatements.selectContentIdByHash();
            contentId = ((Query)((Query)handle.createQuery(sql).bind(0, contentHash)).bind(1, this.tenantContext.tenantId())).mapTo(Long.class).one();
        } else if ("h2".equals(this.sqlStatements.dbType())) {
            String sql = this.sqlStatements.selectContentIdByHash();
            Optional<Long> contentIdOptional = ((Query)((Query)handle.createQuery(sql).bind(0, contentHash)).bind(1, this.tenantContext.tenantId())).mapTo(Long.class).findOne();
            if (contentIdOptional.isPresent()) {
                contentId = contentIdOptional.get();
                insertReferences = false;
            } else {
                sql = this.sqlStatements.upsertContent();
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.nextContentId(handle))).bind(2, canonicalContentHash)).bind(3, contentHash)).bind(4, contentBytes)).bind(5, referencesSerialized)).execute();
                sql = this.sqlStatements.selectContentIdByHash();
                contentId = ((Query)((Query)handle.createQuery(sql).bind(0, contentHash)).bind(1, this.tenantContext.tenantId())).mapTo(Long.class).one();
            }
        } else {
            throw new UnsupportedOperationException("Unsupported database type: " + this.sqlStatements.dbType());
        }
        if (insertReferences) {
            this.insertReferences(handle, contentId, references);
        }
        return contentId;
    }

    protected void insertReferences(Handle handle, Long contentId, List<ArtifactReferenceDto> references) {
        if (references != null && !references.isEmpty()) {
            references.forEach(reference -> {
                block2: {
                    try {
                        String sqli = this.sqlStatements.upsertReference();
                        ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, this.tenantContext.tenantId())).bind(1, contentId)).bind(2, SqlUtil.normalizeGroupId(reference.getGroupId()))).bind(3, reference.getArtifactId())).bind(4, reference.getVersion())).bind(5, reference.getName())).execute();
                    }
                    catch (Exception e) {
                        if (this.sqlStatements.isPrimaryKeyViolation(e)) break block2;
                        throw new RegistryStorageException(e);
                    }
                }
            });
        }
    }

    @Override
    @Transactional
    public ArtifactMetaDataDto createArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData, List<ArtifactReferenceDto> references) throws ArtifactNotFoundException, ArtifactAlreadyExistsException, RegistryStorageException {
        return this.createArtifactWithMetadata(groupId, artifactId, version, artifactType, content, metaData, references, null);
    }

    protected ArtifactMetaDataDto createArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData, List<ArtifactReferenceDto> references, IdGenerator globalIdGenerator) throws ArtifactNotFoundException, ArtifactAlreadyExistsException, RegistryStorageException {
        String createdBy = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        if (groupId != null && !this.isGroupExists(groupId)) {
            this.createGroup(GroupMetaDataDto.builder().groupId(groupId).createdOn(createdOn.getTime()).modifiedOn(createdOn.getTime()).createdBy(createdBy).modifiedBy(createdBy).build());
        }
        long contentId = this.handles.withHandleNoException(handle -> this.createOrUpdateContent(handle, artifactType, content, references));
        EditableArtifactMetaDataDto md = metaData;
        if (md == null) {
            md = this.extractMetaData(artifactType, content);
        }
        return this.createArtifactWithMetadata(groupId, artifactId, version, artifactType, contentId, createdBy, createdOn, md, globalIdGenerator);
    }

    protected ArtifactMetaDataDto createArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, long contentId, String createdBy, Date createdOn, EditableArtifactMetaDataDto metaData, IdGenerator globalIdGenerator) {
        this.log.debug("Inserting an artifact row for: {} {}", (Object)groupId, (Object)artifactId);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.insertArtifact();
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, artifactType)).bind(4, createdBy)).bind(5, createdOn)).execute();
                ArtifactVersionMetaDataDto vmdd = this.createArtifactVersion(handle, artifactType, true, groupId, artifactId, version, metaData.getName(), metaData.getDescription(), metaData.getLabels(), metaData.getProperties(), createdBy, createdOn, contentId, globalIdGenerator);
                ContentWrapperDto contentDto = this.getArtifactByContentId(contentId);
                ArtifactMetaDataDto amdd = this.versionToArtifactDto(groupId, artifactId, vmdd);
                amdd.setCreatedBy(createdBy);
                amdd.setCreatedOn(createdOn.getTime());
                amdd.setLabels(metaData.getLabels());
                amdd.setProperties(metaData.getProperties());
                amdd.setReferences(contentDto.getReferences());
                return amdd;
            });
        }
        catch (Exception e) {
            if (this.sqlStatements.isPrimaryKeyViolation(e)) {
                throw new ArtifactAlreadyExistsException(groupId, artifactId);
            }
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public List<String> deleteArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Deleting an artifact: {} {}", (Object)groupId, (Object)artifactId);
        try {
            List res = this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersions();
                List<String> versions = ((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).mapTo(String.class).list();
                sql = this.sqlStatements.deleteLabels();
                ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).execute();
                sql = this.sqlStatements.deleteProperties();
                ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).execute();
                sql = this.sqlStatements.deleteVersions();
                ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).execute();
                sql = this.sqlStatements.deleteArtifactRules();
                ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).execute();
                sql = this.sqlStatements.deleteArtifact();
                int rowCount = ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).execute();
                if (rowCount == 0) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                return versions;
            });
            this.deleteAllOrphanedContent();
            return res;
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public void deleteArtifacts(String groupId) throws RegistryStorageException {
        this.log.debug("Deleting all artifacts in group: {}", (Object)groupId);
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.deleteLabelsByGroupId();
                ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).execute();
                sql = this.sqlStatements.deletePropertiesByGroupId();
                ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).execute();
                sql = this.sqlStatements.deleteVersionsByGroupId();
                ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).execute();
                sql = this.sqlStatements.deleteArtifactRulesByGroupId();
                ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).execute();
                sql = this.sqlStatements.deleteArtifactsByGroupId();
                int rowCount = ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).execute();
                if (rowCount == 0) {
                    throw new ArtifactNotFoundException(groupId, null);
                }
                return null;
            });
            this.deleteAllOrphanedContent();
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public StoredArtifactDto getArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.getArtifact(groupId, artifactId, this.storageBehaviorProps.getDefaultArtifactRetrievalBehavior());
    }

    @Override
    public StoredArtifactDto getArtifact(String groupId, String artifactId, RegistryStorage.ArtifactRetrievalBehavior behavior) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single artifact (latest version) by artifactId: {} {} (behavior = {})", new Object[]{groupId, artifactId, behavior});
        try {
            switch (behavior) {
                case DEFAULT: {
                    return this.handles.withHandle(handle -> {
                        Optional<StoredArtifactDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectLatestArtifactContent()).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).map(StoredArtifactMapper.instance).findOne();
                        return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
                    });
                }
                case SKIP_DISABLED_LATEST: {
                    return this.handles.withHandle(handle -> {
                        Optional<StoredArtifactDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectLatestArtifactContentSkipDisabledState()).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).map(StoredArtifactMapper.instance).findOne();
                        if (res.isEmpty()) {
                            res = ((Query)((Query)((Query)((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectLatestArtifactContentWithMaxGlobalIDSkipDisabledState()).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, this.tenantContext.tenantId())).bind(4, SqlUtil.normalizeGroupId(groupId))).bind(5, artifactId)).map(StoredArtifactMapper.instance).findOne();
                        }
                        return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
                    });
                }
            }
            throw new UnreachableCodeException();
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public ArtifactMetaDataDto updateArtifact(String groupId, String artifactId, String version, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) throws ArtifactNotFoundException, RegistryStorageException {
        return this.updateArtifact(groupId, artifactId, version, artifactType, content, references, null);
    }

    protected ArtifactMetaDataDto updateArtifact(String groupId, String artifactId, String version, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references, IdGenerator globalIdGenerator) throws ArtifactNotFoundException, RegistryStorageException {
        return this.updateArtifactWithMetadata(groupId, artifactId, version, artifactType, content, null, references, globalIdGenerator);
    }

    @Override
    @Transactional
    public ArtifactMetaDataDto updateArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData, List<ArtifactReferenceDto> references) throws ArtifactNotFoundException, RegistryStorageException {
        return this.updateArtifactWithMetadata(groupId, artifactId, version, artifactType, content, metaData, references, null);
    }

    protected ArtifactMetaDataDto updateArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData, List<ArtifactReferenceDto> references, IdGenerator globalIdGenerator) throws ArtifactNotFoundException, RegistryStorageException {
        String createdBy = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        long contentId = this.handles.withHandleNoException(handle -> this.createOrUpdateContent(handle, artifactType, content, references));
        if (metaData == null) {
            metaData = this.extractMetaData(artifactType, content);
        }
        return this.updateArtifactWithMetadata(groupId, artifactId, version, artifactType, contentId, createdBy, createdOn, metaData, globalIdGenerator);
    }

    protected ArtifactMetaDataDto updateArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, long contentId, String createdBy, Date createdOn, EditableArtifactMetaDataDto metaData, IdGenerator globalIdGenerator) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Updating artifact {} {} with a new version (content).", (Object)groupId, (Object)artifactId);
        ArtifactMetaDataDto latest = this.getLatestArtifactMetaDataInternal(groupId, artifactId, this.storageBehaviorProps.getDefaultArtifactRetrievalBehavior());
        try {
            return this.handles.withHandle(handle -> {
                String name = latest.getName();
                String description = latest.getDescription();
                List<String> labels = latest.getLabels();
                Map<String, String> properties = latest.getProperties();
                if (metaData.getName() != null) {
                    name = metaData.getName();
                }
                if (metaData.getDescription() != null) {
                    description = metaData.getDescription();
                }
                if (metaData.getLabels() != null) {
                    labels = metaData.getLabels();
                }
                if (metaData.getProperties() != null) {
                    properties = metaData.getProperties();
                }
                ArtifactVersionMetaDataDto versionDto = this.createArtifactVersion(handle, artifactType, false, groupId, artifactId, version, name, description, labels, properties, createdBy, createdOn, contentId, globalIdGenerator);
                ArtifactMetaDataDto dto = this.versionToArtifactDto(groupId, artifactId, versionDto);
                dto.setCreatedOn(latest.getCreatedOn());
                dto.setCreatedBy(latest.getCreatedBy());
                dto.setLabels(labels);
                dto.setProperties(properties);
                return dto;
            });
        }
        catch (Exception e) {
            if (this.sqlStatements.isPrimaryKeyViolation(e)) {
                throw new VersionAlreadyExistsException(groupId, artifactId, version);
            }
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public Set<String> getArtifactIds(Integer limit) {
        Integer adjustedLimit = limit == null ? Integer.MAX_VALUE : limit;
        this.log.debug("Getting the set of all artifact IDs");
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.selectArtifactIds();
            Query query = handle.createQuery(sql);
            if ("mssql".equals(this.sqlStatements.dbType())) {
                ((Query)query.bind(0, adjustedLimit)).bind(1, this.tenantContext.tenantId());
            } else {
                ((Query)query.bind(0, this.tenantContext.tenantId())).bind(1, adjustedLimit);
            }
            List<String> ids = query.mapTo(String.class).list();
            return new TreeSet<String>(ids);
        });
    }

    @Override
    @Transactional
    public ArtifactSearchResultsDto searchArtifacts(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, int offset, int limit) {
        return this.handles.withHandleNoException(handle -> {
            LinkedList<SqlStatementVariableBinder> binders = new LinkedList<SqlStatementVariableBinder>();
            StringBuilder select = new StringBuilder();
            StringBuilder where = new StringBuilder();
            StringBuilder orderByQuery = new StringBuilder();
            StringBuilder limitOffset = new StringBuilder();
            boolean joinContentTable = AbstractSqlRegistryStorage.hasContentFilter(filters);
            select.append("SELECT a.*, v.globalId, v.version, v.state, v.name, v.description, v.labels, v.properties, v.createdBy AS modifiedBy, v.createdOn AS modifiedOn FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.latest = v.globalId ");
            if (joinContentTable) {
                select.append("JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId ");
            }
            where.append("WHERE a.tenantId = ?");
            binders.add((query, idx) -> query.bind(idx, this.tenantContext.tenantId()));
            for (SearchFilter filter : filters) {
                where.append(" AND (");
                switch (filter.getType()) {
                    case description: {
                        where.append("v.description LIKE ?");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        break;
                    }
                    case everything: {
                        where.append("(v.name LIKE ? OR v.groupId LIKE ? OR a.artifactId LIKE ? OR v.description LIKE ? OR EXISTS(SELECT l.globalId FROM labels l WHERE l.label = ? AND l.globalId = v.globalId AND l.tenantId = v.tenantId) OR EXISTS(SELECT p.globalId FROM properties p WHERE p.pkey = ? AND p.globalId = v.globalId AND p.tenantId = v.tenantId))");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue().toLowerCase()));
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue().toLowerCase()));
                        break;
                    }
                    case labels: {
                        where.append("EXISTS(SELECT l.globalId FROM labels l WHERE l.label = ? AND l.globalId = v.globalId AND l.tenantId = v.tenantId)");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue().toLowerCase()));
                        break;
                    }
                    case name: {
                        where.append("(v.name LIKE ?) OR (a.artifactId LIKE ?)");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        break;
                    }
                    case group: {
                        where.append("(v.groupId = ?)");
                        binders.add((query, idx) -> query.bind(idx, SqlUtil.normalizeGroupId(filter.getStringValue())));
                        break;
                    }
                    case contentHash: {
                        where.append("(c.contentHash = ?)");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        break;
                    }
                    case canonicalHash: {
                        where.append("(c.canonicalHash = ?)");
                        binders.add((query, idx) -> query.bind(idx, filter.getStringValue()));
                        break;
                    }
                    case properties: {
                        Pair<String, String> property = filter.getPropertyFilterValue();
                        String propKey = ((String)property.getKey()).toLowerCase();
                        where.append("EXISTS(SELECT p.globalId FROM properties p WHERE p.pkey = ? ");
                        binders.add((query, idx) -> query.bind(idx, propKey));
                        if (property.getValue() != null) {
                            String propValue = ((String)property.getValue()).toLowerCase();
                            where.append("AND p.pvalue = ? ");
                            binders.add((query, idx) -> query.bind(idx, propValue));
                        }
                        where.append("AND p.globalId = v.globalId AND p.tenantId = v.tenantId)");
                        break;
                    }
                    case globalId: {
                        where.append("(v.globalId = ?)");
                        binders.add((query, idx) -> query.bind(idx, filter.getNumberValue().longValue()));
                        break;
                    }
                    case contentId: {
                        where.append("(v.contentId = ?)");
                        binders.add((query, idx) -> query.bind(idx, filter.getNumberValue().longValue()));
                        break;
                    }
                }
                where.append(")");
            }
            switch (orderBy) {
                case name: {
                    orderByQuery.append(" ORDER BY coalesce(v." + orderBy.name() + ", a.artifactId) ");
                    break;
                }
                case createdOn: {
                    orderByQuery.append(" ORDER BY v." + orderBy.name() + " ");
                    break;
                }
            }
            orderByQuery.append(orderDirection.name());
            if ("mssql".equals(this.sqlStatements.dbType())) {
                limitOffset.append(" OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
            } else {
                limitOffset.append(" LIMIT ? OFFSET ?");
            }
            String artifactsQuerySql = select.toString() + where.toString() + orderByQuery.toString() + limitOffset.toString();
            Query artifactsQuery = handle.createQuery(artifactsQuerySql);
            Object countSelect = "SELECT count(a.artifactId) FROM artifacts a JOIN versions v ON a.tenantId = v.tenantId AND a.latest = v.globalId ";
            if (joinContentTable) {
                countSelect = (String)countSelect + "JOIN content c ON v.contentId = c.contentId AND v.tenantId = c.tenantId ";
            }
            Query countQuery = handle.createQuery((String)countSelect + where.toString());
            int idx2 = 0;
            for (SqlStatementVariableBinder binder : binders) {
                binder.bind(artifactsQuery, idx2);
                binder.bind(countQuery, idx2);
                ++idx2;
            }
            if ("mssql".equals(this.sqlStatements.dbType())) {
                artifactsQuery.bind(idx2++, offset);
                artifactsQuery.bind(idx2++, limit);
            } else {
                artifactsQuery.bind(idx2++, limit);
                artifactsQuery.bind(idx2++, offset);
            }
            List<SearchedArtifactDto> artifacts = artifactsQuery.map(SearchedArtifactMapper.instance).list();
            Integer count = countQuery.mapTo(Integer.class).one();
            ArtifactSearchResultsDto results = new ArtifactSearchResultsDto();
            results.setArtifacts(artifacts);
            results.setCount(count.intValue());
            return results;
        });
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        return this.getArtifactMetaData(groupId, artifactId, this.storageBehaviorProps.getDefaultArtifactRetrievalBehavior());
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(String groupId, String artifactId, RegistryStorage.ArtifactRetrievalBehavior behavior) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Selecting artifact (latest version) meta-data: {} {} (behavior = {})", new Object[]{groupId, artifactId, behavior});
        return this.getLatestArtifactMetaDataInternal(groupId, artifactId, behavior);
    }

    private ArtifactMetaDataDto getLatestArtifactMetaDataInternal(String groupId, String artifactId, RegistryStorage.ArtifactRetrievalBehavior behavior) {
        try {
            switch (behavior) {
                case DEFAULT: {
                    return this.handles.withHandle(handle -> {
                        Optional<ArtifactMetaDataDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectLatestArtifactMetaData()).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).map(ArtifactMetaDataDtoMapper.instance).findOne();
                        return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
                    });
                }
                case SKIP_DISABLED_LATEST: {
                    return this.handles.withHandle(handle -> {
                        Optional<ArtifactMetaDataDto> res = ((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectLatestArtifactMetaDataSkipDisabledState()).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).map(ArtifactMetaDataDtoMapper.instance).findOne();
                        if (res.isEmpty()) {
                            res = ((Query)((Query)((Query)((Query)((Query)((Query)handle.createQuery(this.sqlStatements.selectLatestArtifactMetaDataWithMaxGlobalIDSkipDisabledState()).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, this.tenantContext.tenantId())).bind(4, SqlUtil.normalizeGroupId(groupId))).bind(5, artifactId)).map(ArtifactMetaDataDtoMapper.instance).findOne();
                        }
                        return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
                    });
                }
            }
            throw new UnreachableCodeException();
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String groupId, String artifactId, boolean canonical, ContentHandle content, List<ArtifactReferenceDto> artifactReferences) throws ArtifactNotFoundException, RegistryStorageException {
        String hash;
        String referencesSerialized = SqlUtil.serializeReferences(artifactReferences);
        try {
            if (canonical) {
                ArtifactMetaDataDto artifactMetaData = this.getArtifactMetaData(groupId, artifactId);
                ContentWrapperDto contentWrapperDto = this.getArtifactByContentId(artifactMetaData.getContentId());
                String type = artifactMetaData.getType();
                ContentHandle canonicalContent = this.canonicalizeContent(type, content, contentWrapperDto.getReferences());
                hash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(canonicalContent.bytes(), referencesSerialized));
            } else {
                hash = DigestUtils.sha256Hex((byte[])this.concatContentAndReferences(content.bytes(), referencesSerialized));
            }
        }
        catch (IOException e) {
            throw new RegistryStorageException(e);
        }
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersionMetaDataByContentHash();
                if (canonical) {
                    sql = this.sqlStatements.selectArtifactVersionMetaDataByCanonicalHash();
                }
                Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, hash)).map(ArtifactVersionMetaDataDtoMapper.instance).findFirst();
                return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
            });
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public ArtifactMetaDataDto getArtifactMetaData(long globalId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Getting meta-data for globalId: {}", (Object)globalId);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactMetaDataByGlobalId();
                Optional<ArtifactMetaDataDto> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).map(ArtifactMetaDataDtoMapper.instance).findOne();
                return res.orElseThrow(() -> new ArtifactNotFoundException(null, String.valueOf(globalId)));
            });
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Updating meta-data for an artifact: {} {}", (Object)groupId, (Object)artifactId);
        ArtifactMetaDataDto dto = this.getLatestArtifactMetaDataInternal(groupId, artifactId, this.storageBehaviorProps.getDefaultArtifactRetrievalBehavior());
        this.internalUpdateArtifactVersionMetadata(dto.getGlobalId(), groupId, artifactId, dto.getVersion(), metaData);
    }

    @Override
    @Transactional
    public void updateArtifactOwner(String groupId, String artifactId, ArtifactOwnerDto owner) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Updating ownership of an artifact: {} {}", (Object)groupId, (Object)artifactId);
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.updateArtifactOwner();
                int rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, owner.getOwner())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).execute();
                if (rowCount == 0 && !this.isArtifactExists(groupId, artifactId)) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                return null;
            });
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public List<RuleType> getArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Getting a list of all artifact rules for: {} {}", (Object)groupId, (Object)artifactId);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactRules();
                List<RuleType> rules = ((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).map(new RowMapper<RuleType>(){

                    @Override
                    public RuleType map(ResultSet rs) throws SQLException {
                        return RuleType.fromValue((String)rs.getString("type"));
                    }
                }).list();
                if (rules.isEmpty() && !this.isArtifactExists(groupId, artifactId)) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                return rules;
            });
        }
        catch (ArtifactNotFoundException anfe) {
            throw anfe;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void createArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException {
        this.log.debug("Inserting an artifact rule row for artifact: {} {} rule: {}", new Object[]{groupId, artifactId, rule.name()});
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.insertArtifactRule();
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, rule.name())).bind(4, config.getConfiguration())).execute();
                return null;
            });
        }
        catch (Exception e) {
            if (this.sqlStatements.isPrimaryKeyViolation(e)) {
                throw new RuleAlreadyExistsException(rule);
            }
            if (this.sqlStatements.isForeignKeyViolation(e)) {
                throw new ArtifactNotFoundException(groupId, artifactId, e);
            }
            throw new RegistryStorageException(e);
        }
        this.log.debug("Artifact rule row successfully inserted.");
    }

    @Override
    @Transactional
    public void deleteArtifactRules(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Deleting all artifact rules for artifact: {} {}", (Object)groupId, (Object)artifactId);
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.deleteArtifactRules();
                int count = ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).execute();
                if (count == 0 && !this.isArtifactExists(groupId, artifactId)) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                return null;
            });
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public RuleConfigurationDto getArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single artifact rule for artifact: {} {} and rule: {}", new Object[]{groupId, artifactId, rule.name()});
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactRuleByType();
                Optional<RuleConfigurationDto> res = ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, rule.name())).map(RuleConfigurationDtoMapper.instance).findOne();
                return res.orElseThrow(() -> {
                    if (!this.isArtifactExists(groupId, artifactId)) {
                        return new ArtifactNotFoundException(groupId, artifactId);
                    }
                    return new RuleNotFoundException(rule);
                });
            });
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (RuleNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void updateArtifactRule(String groupId, String artifactId, RuleType rule, RuleConfigurationDto config) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.log.debug("Updating an artifact rule for artifact: {} {} and rule: {}::{}", new Object[]{groupId, artifactId, rule.name(), config.getConfiguration()});
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.updateArtifactRule();
                int rowCount = ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, config.getConfiguration())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).bind(4, rule.name())).execute();
                if (rowCount == 0) {
                    if (!this.isArtifactExists(groupId, artifactId)) {
                        throw new ArtifactNotFoundException(groupId, artifactId);
                    }
                    throw new RuleNotFoundException(rule);
                }
                return null;
            });
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void deleteArtifactRule(String groupId, String artifactId, RuleType rule) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException {
        this.log.debug("Deleting an artifact rule for artifact: {} {} and rule: {}", new Object[]{groupId, artifactId, rule.name()});
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.deleteArtifactRule();
                int rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, rule.name())).execute();
                if (rowCount == 0) {
                    if (!this.isArtifactExists(groupId, artifactId)) {
                        throw new ArtifactNotFoundException(groupId, artifactId);
                    }
                    throw new RuleNotFoundException(rule);
                }
                return null;
            });
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public List<String> getArtifactVersions(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Getting a list of versions for artifact: {} {}", (Object)groupId, (Object)artifactId);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersions();
                List<String> versions = ((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).mapTo(String.class).list();
                if (versions.isEmpty()) {
                    throw new ArtifactNotFoundException(groupId, artifactId);
                }
                return versions;
            });
        }
        catch (ArtifactNotFoundException anfe) {
            throw anfe;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public VersionSearchResultsDto searchVersions(String groupId, String artifactId, int offset, int limit) {
        this.log.debug("Searching for versions of artifact {} {}", (Object)groupId, (Object)artifactId);
        return this.handles.withHandleNoException(handle -> {
            VersionSearchResultsDto rval = new VersionSearchResultsDto();
            String sql = this.sqlStatements.selectAllArtifactVersionsCount();
            Integer count = ((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).mapTo(Integer.class).one();
            rval.setCount(count.intValue());
            if (!this.isArtifactExists(groupId, artifactId)) {
                throw new ArtifactNotFoundException(groupId, artifactId);
            }
            sql = this.sqlStatements.selectAllArtifactVersions();
            Query query = (Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId);
            if ("mssql".equals(this.sqlStatements.dbType())) {
                ((Query)query.bind(3, offset)).bind(4, limit);
            } else {
                ((Query)query.bind(3, limit)).bind(4, offset);
            }
            List<SearchedVersionDto> versions = query.map(SearchedVersionMapper.instance).list();
            rval.setVersions(versions);
            return rval;
        });
    }

    @Override
    public StoredArtifactDto getArtifactVersion(long globalId) throws ArtifactNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single artifact version by globalId: {}", (Object)globalId);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersionContentByGlobalId();
                Optional<StoredArtifactDto> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).map(StoredArtifactMapper.instance).findOne();
                return res.orElseThrow(() -> new ArtifactNotFoundException(null, "gid-" + globalId));
            });
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public StoredArtifactDto getArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single artifact version by artifactId: {} {} and version {}", new Object[]{groupId, artifactId, version});
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersionContent();
                Optional<StoredArtifactDto> res = ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).map(StoredArtifactMapper.instance).findOne();
                return res.orElseThrow(() -> new ArtifactNotFoundException(groupId, artifactId));
            });
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void deleteArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Deleting version {} of artifact {} {}", new Object[]{version, groupId, artifactId});
        List<String> versions = this.getArtifactVersions(groupId, artifactId);
        if (versions.size() == 1 && versions.iterator().next().equals(version)) {
            this.deleteArtifact(groupId, artifactId);
            return;
        }
        if (versions.size() == 1 && !versions.iterator().next().equals(version)) {
            throw new VersionNotFoundException(groupId, artifactId, version);
        }
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.updateArtifactLatest();
                ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, (Long)null)).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).execute();
                sql = this.sqlStatements.deleteVersionLabels();
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).bind(4, version)).execute();
                sql = this.sqlStatements.deleteVersionProperties();
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).bind(4, version)).execute();
                sql = this.sqlStatements.deleteVersionComments();
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).bind(4, version)).execute();
                sql = this.sqlStatements.deleteVersion();
                int rows = ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).execute();
                if (rows == 1) {
                    versions.remove(version);
                    String latestVersion = (String)versions.get(versions.size() - 1);
                    sql = this.sqlStatements.updateArtifactLatestGlobalId();
                    int latestUpdateRows = ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, latestVersion)).bind(4, this.tenantContext.tenantId())).bind(5, SqlUtil.normalizeGroupId(groupId))).bind(6, artifactId)).execute();
                    if (latestUpdateRows == 0) {
                        throw new RegistryStorageException("latest column was not updated");
                    }
                }
                if (rows == 0) {
                    throw new VersionNotFoundException(groupId, artifactId, version);
                }
                if (rows > 1) {
                    throw new RegistryStorageException("Multiple versions deleted, artifact latest column left null");
                }
                return null;
            });
            this.deleteAllOrphanedContent();
        }
        catch (VersionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Selecting artifact version meta-data: {} {} version {}", new Object[]{groupId, artifactId, version});
        return this.getArtifactVersionMetaDataInternal(groupId, artifactId, version);
    }

    private ArtifactVersionMetaDataDto getArtifactVersionMetaDataInternal(String groupId, String artifactId, String version) {
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersionMetaData();
                Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).map(ArtifactVersionMetaDataDtoMapper.instance).findOne();
                return res.orElseThrow(() -> new VersionNotFoundException(groupId, artifactId, version));
            });
        }
        catch (VersionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Updating meta-data for an artifact version: {} {}", (Object)groupId, (Object)artifactId);
        ArtifactVersionMetaDataDto dto = this.getArtifactVersionMetaDataInternal(groupId, artifactId, version);
        this.internalUpdateArtifactVersionMetadata(dto.getGlobalId(), groupId, artifactId, dto.getVersion(), metaData);
    }

    private void internalUpdateArtifactVersionMetadata(long globalId, String groupId, String artifactId, String version, EditableArtifactMetaDataDto metaData) {
        try {
            this.handles.withHandle(handle -> {
                Map<String, String> properties;
                String sql = this.sqlStatements.updateArtifactVersionMetaData();
                int rowCount = ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, AbstractSqlRegistryStorage.limitStr(metaData.getName(), 512))).bind(1, AbstractSqlRegistryStorage.limitStr(metaData.getDescription(), 1024, true))).bind(2, SqlUtil.serializeLabels(metaData.getLabels()))).bind(3, SqlUtil.serializeProperties(metaData.getProperties()))).bind(4, this.tenantContext.tenantId())).bind(5, SqlUtil.normalizeGroupId(groupId))).bind(6, artifactId)).bind(7, version)).execute();
                if (rowCount == 0) {
                    throw new VersionNotFoundException(groupId, artifactId, version);
                }
                sql = this.sqlStatements.deleteLabelsByGlobalId();
                ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).execute();
                sql = this.sqlStatements.deletePropertiesByGlobalId();
                ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).execute();
                List<String> labels = metaData.getLabels();
                if (labels != null && !labels.isEmpty()) {
                    labels.forEach(label -> {
                        String sqli = this.sqlStatements.insertLabel();
                        ((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).bind(2, AbstractSqlRegistryStorage.limitStr(label.toLowerCase(), 256))).execute();
                    });
                }
                if ((properties = metaData.getProperties()) != null && !properties.isEmpty()) {
                    properties.forEach((k, v) -> {
                        String sqli = this.sqlStatements.insertProperty();
                        ((Update)((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, this.tenantContext.tenantId())).bind(1, globalId)).bind(2, AbstractSqlRegistryStorage.limitStr(k.toLowerCase(), 256))).bind(3, AbstractSqlRegistryStorage.limitStr(v.toLowerCase(), 1024))).execute();
                    });
                }
                return null;
            });
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void deleteArtifactVersionMetaData(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.log.debug("Deleting user-defined meta-data for artifact {} {} version {}", new Object[]{groupId, artifactId, version});
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.updateArtifactVersionMetaData();
                int rowCount = ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, (String)null)).bind(1, (String)null)).bind(2, (String)null)).bind(3, (String)null)).bind(4, this.tenantContext.tenantId())).bind(5, SqlUtil.normalizeGroupId(groupId))).bind(6, artifactId)).bind(7, version)).execute();
                sql = this.sqlStatements.deleteVersionLabels();
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).bind(4, version)).execute();
                sql = this.sqlStatements.deleteVersionProperties();
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(groupId))).bind(3, artifactId)).bind(4, version)).execute();
                if (rowCount == 0) {
                    throw new VersionNotFoundException(groupId, artifactId, version);
                }
                return null;
            });
        }
        catch (VersionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public CommentDto createArtifactVersionComment(String groupId, String artifactId, String version, String value) {
        this.log.debug("Inserting an artifact comment row for artifact: {} {} version: {}", new Object[]{groupId, artifactId, version});
        String theVersion = this.resolveVersion(groupId, artifactId, version);
        String createdBy = this.securityIdentity.getPrincipal().getName();
        Date createdOn = new Date();
        return this.createArtifactVersionComment(groupId, artifactId, theVersion, new IdGenerator(){

            @Override
            public Long generate(Handle handle) {
                return AbstractSqlRegistryStorage.this.nextCommentId(handle);
            }
        }, createdBy, createdOn, value);
    }

    protected CommentDto createArtifactVersionComment(String groupId, String artifactId, String version, IdGenerator commentId, String createdBy, Date createdOn, String value) {
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersionMetaData();
                Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).map(ArtifactVersionMetaDataDtoMapper.instance).findOne();
                ArtifactVersionMetaDataDto avmdd = res.orElseThrow(() -> new VersionNotFoundException(groupId, artifactId, version));
                String cid = String.valueOf(commentId.generate(handle));
                sql = this.sqlStatements.insertComment();
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, cid)).bind(2, avmdd.getGlobalId())).bind(3, createdBy)).bind(4, createdOn)).bind(5, value)).execute();
                this.log.debug("Comment row successfully inserted.");
                CommentDto dto = CommentDto.builder().commentId(cid).createdBy(createdBy).createdOn(createdOn.getTime()).value(value).build();
                return dto;
            });
        }
        catch (VersionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.sqlStatements.isForeignKeyViolation(e)) {
                throw new ArtifactNotFoundException(groupId, artifactId, e);
            }
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public List<CommentDto> getArtifactVersionComments(String groupId, String artifactId, String version) {
        this.log.debug("Getting a list of all artifact version comments for: {} {} @ {}", new Object[]{groupId, artifactId, version});
        String theVersion = this.resolveVersion(groupId, artifactId, version);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectComments();
                List<CommentDto> comments = ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, theVersion)).map(CommentDtoMapper.instance).list();
                return comments;
            });
        }
        catch (ArtifactNotFoundException anfe) {
            throw anfe;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void deleteArtifactVersionComment(String groupId, String artifactId, String version, String commentId) {
        this.log.debug("Deleting an artifact rule for artifact: {} {} @ {}", new Object[]{groupId, artifactId, version});
        String theVersion = this.resolveVersion(groupId, artifactId, version);
        String deletedBy = this.securityIdentity.getPrincipal().getName();
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersionMetaData();
                Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, theVersion)).map(ArtifactVersionMetaDataDtoMapper.instance).findOne();
                ArtifactVersionMetaDataDto avmdd = res.orElseThrow(() -> new VersionNotFoundException(groupId, artifactId, version));
                sql = this.sqlStatements.deleteComment();
                int rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, avmdd.getGlobalId())).bind(2, commentId)).bind(3, deletedBy)).execute();
                if (rowCount == 0) {
                    throw new CommentNotFoundException();
                }
                return null;
            });
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void updateArtifactVersionComment(String groupId, String artifactId, String version, String commentId, String value) {
        this.log.debug("Updating a comment for artifact: {} {} @ {}", new Object[]{groupId, artifactId, version});
        String theVersion = this.resolveVersion(groupId, artifactId, version);
        String modifiedBy = this.securityIdentity.getPrincipal().getName();
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectArtifactVersionMetaData();
                Optional<ArtifactVersionMetaDataDto> res = ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, theVersion)).map(ArtifactVersionMetaDataDtoMapper.instance).findOne();
                ArtifactVersionMetaDataDto avmdd = res.orElseThrow(() -> new VersionNotFoundException(groupId, artifactId, version));
                sql = this.sqlStatements.updateComment();
                int rowCount = ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, value)).bind(1, this.tenantContext.tenantId())).bind(2, avmdd.getGlobalId())).bind(3, commentId)).bind(4, modifiedBy)).execute();
                if (rowCount == 0) {
                    throw new CommentNotFoundException();
                }
                return null;
            });
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public List<RuleType> getGlobalRules() throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.selectGlobalRules();
            return ((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).map(new RowMapper<RuleType>(){

                @Override
                public RuleType map(ResultSet rs) throws SQLException {
                    return RuleType.fromValue((String)rs.getString("type"));
                }
            }).list();
        });
    }

    @Override
    @Transactional
    public void createGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleAlreadyExistsException, RegistryStorageException {
        this.log.debug("Inserting a global rule row for: {}", (Object)rule.name());
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.insertGlobalRule();
                ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, rule.name())).bind(2, config.getConfiguration())).execute();
                return null;
            });
        }
        catch (Exception e) {
            if (this.sqlStatements.isPrimaryKeyViolation(e)) {
                throw new RuleAlreadyExistsException(rule);
            }
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void deleteGlobalRules() throws RegistryStorageException {
        this.log.debug("Deleting all Global Rules");
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.deleteGlobalRules();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            return null;
        });
    }

    @Override
    public RuleConfigurationDto getGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        this.log.debug("Selecting a single global rule: {}", (Object)rule.name());
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectGlobalRuleByType();
                Optional<RuleConfigurationDto> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, rule.name())).map(RuleConfigurationDtoMapper.instance).findOne();
                return res.orElseThrow(() -> new RuleNotFoundException(rule));
            });
        }
        catch (RuleNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void updateGlobalRule(RuleType rule, RuleConfigurationDto config) throws RuleNotFoundException, RegistryStorageException {
        this.log.debug("Updating a global rule: {}::{}", (Object)rule.name(), (Object)config.getConfiguration());
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.updateGlobalRule();
                int rowCount = ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, config.getConfiguration())).bind(1, this.tenantContext.tenantId())).bind(2, rule.name())).execute();
                if (rowCount == 0) {
                    throw new RuleNotFoundException(rule);
                }
                return null;
            });
        }
        catch (RuleNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void deleteGlobalRule(RuleType rule) throws RuleNotFoundException, RegistryStorageException {
        this.log.debug("Deleting a global rule: {}", (Object)rule.name());
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.deleteGlobalRule();
                int rowCount = ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, rule.name())).execute();
                if (rowCount == 0) {
                    throw new RuleNotFoundException(rule);
                }
                return null;
            });
        }
        catch (RuleNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    public List<DynamicConfigPropertyDto> getConfigProperties() throws RegistryStorageException {
        this.log.debug("Getting all config properties.");
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.selectConfigProperties();
            return ((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).map(DynamicConfigPropertyDtoMapper.instance).list().stream().filter(item -> item != null).collect(Collectors.toList());
        });
    }

    public DynamicConfigPropertyDto getConfigProperty(String propertyName) throws RegistryStorageException {
        return this.getRawConfigProperty(propertyName);
    }

    @Override
    public DynamicConfigPropertyDto getRawConfigProperty(String propertyName) {
        this.log.debug("Selecting a single config property: {}", (Object)propertyName);
        try {
            return this.handles.withHandle(handle -> {
                String normalizedPropertyName = DtoUtil.appAuthPropertyToRegistry(propertyName);
                String sql = this.sqlStatements.selectConfigPropertyByName();
                Optional<DynamicConfigPropertyDto> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, normalizedPropertyName)).map(DynamicConfigPropertyDtoMapper.instance).findOne();
                return res.orElse(null);
            });
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Transactional
    public void setConfigProperty(DynamicConfigPropertyDto propertyDto) throws RegistryStorageException {
        this.log.debug("Setting a config property with name: {}  and value: {}", (Object)propertyDto.getName(), (Object)propertyDto.getValue());
        this.handles.withHandleNoException(handle -> {
            String propertyName = propertyDto.getName();
            String propertyValue = propertyDto.getValue();
            String sql = this.sqlStatements.deleteConfigProperty();
            ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, propertyName)).execute();
            sql = this.sqlStatements.insertConfigProperty();
            ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, propertyName)).bind(2, propertyValue)).bind(3, System.currentTimeMillis())).execute();
            return null;
        });
    }

    @Transactional
    public void deleteConfigProperty(String propertyName) throws RegistryStorageException {
        this.handles.withHandle(handle -> {
            String sql = this.sqlStatements.deleteConfigProperty();
            ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, propertyName)).execute();
            return null;
        });
    }

    @Override
    public List<String> getTenantsWithStaleConfigProperties(Instant lastRefresh) throws RegistryStorageException {
        this.log.debug("Getting all tenant IDs with stale config properties.");
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.selectTenantIdsByConfigModifiedOn();
            return ((Query)handle.createQuery(sql).bind(0, lastRefresh.toEpochMilli())).mapTo(String.class).list();
        });
    }

    @Override
    public LogConfigurationDto getLogConfiguration(String logger) throws RegistryStorageException, LogConfigurationNotFoundException {
        this.log.debug("Selecting a single log configuration: {}", (Object)logger);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectLogConfigurationByLogger();
                Optional<LogConfigurationDto> res = ((Query)handle.createQuery(sql).bind(0, logger)).map(LogConfigurationMapper.instance).findOne();
                return res.orElseThrow(() -> new LogConfigurationNotFoundException(logger));
            });
        }
        catch (LogConfigurationNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void setLogConfiguration(LogConfigurationDto logConfiguration) throws RegistryStorageException {
        this.log.debug("Upsert log configuration: {}", (Object)logConfiguration.getLogger());
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.upsertLogConfiguration();
            Update query = (Update)((Update)handle.createUpdate(sql).bind(0, logConfiguration.getLogger())).bind(1, logConfiguration.getLogLevel().value());
            if ("postgresql".equals(this.sqlStatements.dbType())) {
                query.bind(2, logConfiguration.getLogLevel().value());
            }
            query.execute();
            return null;
        });
    }

    @Override
    @Transactional
    public void removeLogConfiguration(String logger) throws RegistryStorageException, LogConfigurationNotFoundException {
        this.log.debug("Removing a log configuration: {}", (Object)logger);
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.deleteLogConfiguration();
            int rowCount = ((Update)handle.createUpdate(sql).bind(0, logger)).execute();
            if (rowCount == 0) {
                throw new LogConfigurationNotFoundException(logger);
            }
            return null;
        });
    }

    @Override
    public List<LogConfigurationDto> listLogConfigurations() throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.selectAllLogConfigurations();
            return handle.createQuery(sql).map(LogConfigurationMapper.instance).list();
        });
    }

    @Override
    @Transactional
    public void createGroup(GroupMetaDataDto group) throws GroupAlreadyExistsException, RegistryStorageException {
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.insertGroup();
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, group.getGroupId())).bind(2, group.getDescription())).bind(3, group.getArtifactsType())).bind(4, group.getCreatedBy())).bind(5, group.getCreatedOn() == 0L ? new Date() : new Date(group.getCreatedOn()))).bind(6, group.getModifiedBy())).bind(7, group.getModifiedOn() == 0L ? null : new Date(group.getModifiedOn()))).bind(8, SqlUtil.serializeProperties(group.getProperties()))).execute();
                return null;
            });
        }
        catch (Exception e) {
            if (this.sqlStatements.isPrimaryKeyViolation(e)) {
                throw new GroupAlreadyExistsException(group.getGroupId());
            }
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void updateGroupMetaData(GroupMetaDataDto group) throws GroupNotFoundException, RegistryStorageException {
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.updateGroup();
            int rows = ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, group.getDescription())).bind(1, group.getArtifactsType())).bind(2, group.getModifiedBy())).bind(3, group.getModifiedOn())).bind(4, SqlUtil.serializeProperties(group.getProperties()))).bind(5, this.tenantContext.tenantId())).bind(6, group.getGroupId())).execute();
            if (rows == 0) {
                throw new GroupNotFoundException(group.getGroupId());
            }
            return null;
        });
    }

    @Override
    @Transactional
    public void deleteGroup(String groupId) throws GroupNotFoundException, RegistryStorageException {
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.deleteGroup();
            int rows = ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, groupId)).execute();
            if (rows == 0) {
                throw new GroupNotFoundException(groupId);
            }
            try {
                this.deleteArtifacts(groupId);
            }
            catch (ArtifactNotFoundException artifactNotFoundException) {
                // empty catch block
            }
            return null;
        });
    }

    @Override
    public List<String> getGroupIds(Integer limit) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.selectGroups();
            Query query = handle.createQuery(sql);
            if ("mssql".equals(this.sqlStatements.dbType())) {
                ((Query)query.bind(0, limit)).bind(1, this.tenantContext.tenantId());
            } else {
                ((Query)query.bind(0, this.tenantContext.tenantId())).bind(1, limit);
            }
            List<String> groups = query.map(new RowMapper<String>(){

                @Override
                public String map(ResultSet rs) throws SQLException {
                    return rs.getString("groupId");
                }
            }).list();
            return groups;
        });
    }

    @Override
    public GroupMetaDataDto getGroupMetaData(String groupId) throws GroupNotFoundException, RegistryStorageException {
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectGroupByGroupId();
                Optional<GroupMetaDataDto> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, groupId)).map(GroupMetaDataDtoMapper.instance).findOne();
                return res.orElseThrow(() -> new GroupNotFoundException(groupId));
            });
        }
        catch (GroupNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void exportData(Function<Entity, Void> handler) throws RegistryStorageException {
        try {
            ManifestEntity manifest = new ManifestEntity();
            if (this.securityIdentity != null && this.securityIdentity.getPrincipal() != null) {
                manifest.exportedBy = this.securityIdentity.getPrincipal().getName();
            }
            manifest.systemName = this.system.getName();
            manifest.systemDescription = this.system.getDescription();
            manifest.systemVersion = this.system.getVersion();
            handler.apply((Entity)manifest);
            this.handles.withHandle(handle -> {
                Stream<ContentEntity> stream;
                String sql = this.sqlStatements.exportContent();
                try (Stream<ContentEntity> stream2 = stream = ((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).setFetchSize(50).map(ContentEntityMapper.instance).stream();){
                    stream.forEach(entity -> handler.apply((Entity)entity));
                }
                return null;
            });
            this.handles.withHandle(handle -> {
                Stream<GroupEntity> stream;
                String sql = this.sqlStatements.exportGroups();
                try (Stream<GroupEntity> stream2 = stream = ((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).setFetchSize(50).map(GroupEntityMapper.instance).stream();){
                    stream.forEach(entity -> handler.apply((Entity)entity));
                }
                return null;
            });
            this.handles.withHandle(handle -> {
                Stream<ArtifactVersionEntity> stream;
                String sql = this.sqlStatements.exportArtifactVersions();
                try (Stream<ArtifactVersionEntity> stream2 = stream = ((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).setFetchSize(50).map(ArtifactVersionEntityMapper.instance).stream();){
                    stream.forEach(entity -> handler.apply((Entity)entity));
                }
                return null;
            });
            this.handles.withHandle(handle -> {
                Stream<CommentEntity> stream;
                String sql = this.sqlStatements.exportComments();
                try (Stream<CommentEntity> stream2 = stream = ((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).setFetchSize(50).map(CommentEntityMapper.instance).stream();){
                    stream.forEach(entity -> handler.apply((Entity)entity));
                }
                return null;
            });
            this.handles.withHandle(handle -> {
                Stream<ArtifactRuleEntity> stream;
                String sql = this.sqlStatements.exportArtifactRules();
                try (Stream<ArtifactRuleEntity> stream2 = stream = ((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).setFetchSize(50).map(ArtifactRuleEntityMapper.instance).stream();){
                    stream.forEach(entity -> handler.apply((Entity)entity));
                }
                return null;
            });
            this.handles.withHandle(handle -> {
                Stream<GlobalRuleEntity> stream;
                String sql = this.sqlStatements.exportGlobalRules();
                try (Stream<GlobalRuleEntity> stream2 = stream = ((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).setFetchSize(50).map(GlobalRuleEntityMapper.instance).stream();){
                    stream.forEach(entity -> handler.apply((Entity)entity));
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public void importData(EntityInputStream entities, boolean preserveGlobalId, boolean preserveContentId) throws RegistryStorageException {
        this.handles.withHandleNoException(handle -> {
            SqlDataImporter dataImporter = preserveContentId ? new SqlDataImporter(this.log, handle, this, preserveGlobalId) : new ContentIdNotPreserveSqlDataImporter(this.log, handle, this, preserveGlobalId);
            Entity entity = null;
            while ((entity = entities.nextEntity()) != null) {
                dataImporter.importEntity(entity);
            }
            this.resetContentId(handle);
            this.resetGlobalId(handle);
            this.resetCommentId(handle);
            return null;
        });
    }

    @Override
    public long countArtifacts() throws RegistryStorageException {
        return this.handles.withHandle(handle -> {
            String sql = this.sqlStatements.selectAllArtifactCount();
            Long count = ((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).mapTo(Long.class).one();
            return count;
        });
    }

    @Override
    public long countArtifactVersions(String groupId, String artifactId) throws RegistryStorageException {
        if (!this.isArtifactExists(groupId, artifactId)) {
            throw new ArtifactNotFoundException(groupId, artifactId);
        }
        return this.handles.withHandle(handle -> {
            String sql = this.sqlStatements.selectAllArtifactVersionsCount();
            Long count = ((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).mapTo(Long.class).one();
            return count;
        });
    }

    @Override
    public long countTotalArtifactVersions() throws RegistryStorageException {
        return this.handles.withHandle(handle -> {
            String sql = this.sqlStatements.selectTotalArtifactVersionsCount();
            Long count = ((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).mapTo(Long.class).one();
            return count;
        });
    }

    @Override
    @Transactional
    public void createRoleMapping(String principalId, String role, String principalName) throws RegistryStorageException {
        this.log.debug("Inserting a role mapping row for: {}", (Object)principalId);
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.insertRoleMapping();
                ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, principalId)).bind(2, role)).bind(3, principalName)).execute();
                return null;
            });
        }
        catch (Exception e) {
            if (this.sqlStatements.isPrimaryKeyViolation(e)) {
                throw new RoleMappingAlreadyExistsException();
            }
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void deleteRoleMapping(String principalId) throws RegistryStorageException {
        this.log.debug("Deleting a role mapping row for: {}", (Object)principalId);
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.deleteRoleMapping();
                int rowCount = ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, principalId)).execute();
                if (rowCount == 0) {
                    throw new RoleMappingNotFoundException();
                }
                return null;
            });
        }
        catch (RoleMappingNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public RoleMappingDto getRoleMapping(String principalId) throws RegistryStorageException {
        this.log.debug("Selecting a single role mapping for: {}", (Object)principalId);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectRoleMappingByPrincipalId();
                Optional<RoleMappingDto> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, principalId)).map(RoleMappingDtoMapper.instance).findOne();
                return res.orElseThrow(() -> new RoleMappingNotFoundException());
            });
        }
        catch (RoleMappingNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public String getRoleForPrincipal(String principalId) throws RegistryStorageException {
        this.log.debug("Selecting the role for: {}", (Object)principalId);
        try {
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.selectRoleByPrincipalId();
                Optional<String> res = ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, principalId)).mapTo(String.class).findOne();
                return res.orElse(null);
            });
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    public List<RoleMappingDto> getRoleMappings() throws RegistryStorageException {
        this.log.debug("Getting a list of all role mappings.");
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.selectRoleMappings();
            return ((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).map(RoleMappingDtoMapper.instance).list();
        });
    }

    @Override
    @Transactional
    public void updateRoleMapping(String principalId, String role) throws RegistryStorageException {
        this.log.debug("Updating a role mapping: {}::{}", (Object)principalId, (Object)role);
        try {
            this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.updateRoleMapping();
                int rowCount = ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, role)).bind(1, this.tenantContext.tenantId())).bind(2, principalId)).execute();
                if (rowCount == 0) {
                    throw new RoleMappingNotFoundException();
                }
                return null;
            });
        }
        catch (RoleMappingNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public String createDownload(DownloadContextDto context) throws RegistryStorageException {
        this.log.debug("Inserting a download.");
        try {
            String downloadId = UUID.randomUUID().toString();
            return this.handles.withHandle(handle -> {
                String sql = this.sqlStatements.insertDownload();
                ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, downloadId)).bind(2, context.getExpires())).bind(3, mapper.writeValueAsString((Object)context))).execute();
                return downloadId;
            });
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public DownloadContextDto consumeDownload(String downloadId) throws RegistryStorageException {
        this.log.debug("Consuming a download ID: {}", (Object)downloadId);
        try {
            return this.handles.withHandle(handle -> {
                long now = System.currentTimeMillis();
                String sql = this.sqlStatements.selectDownloadContext();
                Optional<String> res = ((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext.tenantId())).bind(1, downloadId)).bind(2, now)).mapTo(String.class).findOne();
                String downloadContext = res.orElseThrow(() -> new DownloadNotFoundException());
                sql = this.sqlStatements.deleteDownload();
                int rowCount = ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, downloadId)).execute();
                if (rowCount == 0) {
                    throw new DownloadNotFoundException();
                }
                return (DownloadContextDto)mapper.readValue(downloadContext, DownloadContextDto.class);
            });
        }
        catch (DownloadNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryStorageException(e);
        }
    }

    @Override
    @Transactional
    public void deleteAllExpiredDownloads() throws RegistryStorageException {
        this.log.debug("Deleting all expired downloads");
        long now = System.currentTimeMillis();
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.deleteExpiredDownloads();
            ((Update)handle.createUpdate(sql).bind(0, now)).execute();
            return null;
        });
    }

    @Override
    @Transactional
    public void deleteAllUserData() {
        this.log.debug("Deleting all user data");
        this.deleteGlobalRules();
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.deleteAllReferences();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllLabels();
            ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllProperties();
            ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllComments();
            ((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllVersions();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllArtifactRules();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllArtifacts();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllGroups();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllRoleMappings();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllContent();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            sql = this.sqlStatements.deleteAllConfigProperties();
            ((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).execute();
            return null;
        });
    }

    @Override
    public Map<String, ContentHandle> resolveReferences(List<ArtifactReferenceDto> references) {
        if (references == null || references.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, ContentHandle> result = new LinkedHashMap<String, ContentHandle>();
        this.resolveReferences(result, references);
        return result;
    }

    @Override
    public boolean isArtifactExists(String groupId, String artifactId) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectArtifactCountById();
            return ((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).mapTo(Integer.class).one() > 0;
        });
    }

    @Override
    public boolean isGroupExists(String groupId) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectGroupCountById();
            return ((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).mapTo(Integer.class).one() > 0;
        });
    }

    @Override
    public List<Long> getContentIdsReferencingArtifact(String groupId, String artifactId, String version) {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectContentIdsReferencingArtifactBy();
            return ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).mapTo(Long.class).list();
        });
    }

    @Override
    public List<Long> getGlobalIdsReferencingArtifact(String groupId, String artifactId, String version) {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectGlobalIdsReferencingArtifactBy();
            return ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).mapTo(Long.class).list();
        });
    }

    @Override
    public List<ArtifactReferenceDto> getInboundArtifactReferences(String groupId, String artifactId, String version) {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectInboundReferencesByGAV();
            return ((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).bind(1, SqlUtil.normalizeGroupId(groupId))).bind(2, artifactId)).bind(3, version)).map(ArtifactReferenceDtoMapper.instance).list();
        });
    }

    @Override
    public boolean isArtifactVersionExists(String groupId, String artifactId, String version) throws RegistryStorageException {
        try {
            this.getArtifactVersionMetaData(groupId, artifactId, version);
            return true;
        }
        catch (VersionNotFoundException ignored) {
            return false;
        }
    }

    @Override
    public GroupSearchResultsDto searchGroups(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, Integer offset, Integer limit) {
        return this.handles.withHandleNoException(handle -> {
            LinkedList<SqlStatementVariableBinder> binders = new LinkedList<SqlStatementVariableBinder>();
            StringBuilder select = new StringBuilder();
            StringBuilder where = new StringBuilder();
            StringBuilder orderByQuery = new StringBuilder();
            StringBuilder limitOffset = new StringBuilder();
            select.append("SELECT * FROM groups g ");
            where.append("WHERE g.tenantId = ?");
            binders.add((query, idx) -> query.bind(idx, this.tenantContext.tenantId()));
            for (SearchFilter filter : filters) {
                where.append(" AND (");
                switch (filter.getType()) {
                    case description: {
                        where.append("g.description LIKE ?");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        break;
                    }
                    case everything: {
                        where.append("(g.groupId LIKE ? OR g.description LIKE ? )");
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        binders.add((query, idx) -> query.bind(idx, "%" + filter.getStringValue() + "%"));
                        break;
                    }
                    case group: {
                        where.append("(g.groupId = ?)");
                        binders.add((query, idx) -> query.bind(idx, SqlUtil.normalizeGroupId(filter.getStringValue())));
                        break;
                    }
                }
                where.append(")");
            }
            switch (orderBy) {
                case name: {
                    orderByQuery.append(" ORDER BY g.groupId ");
                    break;
                }
                case createdOn: {
                    orderByQuery.append(" ORDER BY g." + orderBy.name() + " ");
                    break;
                }
            }
            orderByQuery.append(orderDirection.name());
            limitOffset.append(" LIMIT ? OFFSET ?");
            String groupsQuerySql = select + where.toString() + orderByQuery + limitOffset.toString();
            Query groupsQuery = handle.createQuery(groupsQuerySql);
            String countSelect = "SELECT count(g.groupId) FROM groups g ";
            Query countQuery = handle.createQuery(countSelect + where.toString());
            int idx2 = 0;
            for (SqlStatementVariableBinder binder : binders) {
                binder.bind(groupsQuery, idx2);
                binder.bind(countQuery, idx2);
                ++idx2;
            }
            groupsQuery.bind(idx2++, limit);
            groupsQuery.bind(idx2++, offset);
            List<SearchedGroupDto> groups = groupsQuery.map(SearchedGroupMapper.instance).list();
            Integer count = countQuery.mapTo(Integer.class).one();
            GroupSearchResultsDto results = new GroupSearchResultsDto();
            results.setGroups(groups);
            results.setCount(count);
            return results;
        });
    }

    private void resolveReferences(Map<String, ContentHandle> resolvedReferences, List<ArtifactReferenceDto> references) {
        if (references != null && !references.isEmpty()) {
            for (ArtifactReferenceDto reference : references) {
                ArtifactVersionMetaDataDto referencedArtifactMetaData;
                if (reference.getArtifactId() == null || reference.getName() == null || reference.getVersion() == null) {
                    throw new IllegalStateException("Invalid reference: " + reference);
                }
                if (resolvedReferences.containsKey(reference.getName()) || (referencedArtifactMetaData = this.lookupForReference(reference)) == null) continue;
                ContentWrapperDto referencedContent = this.getArtifactByContentId(referencedArtifactMetaData.getContentId());
                this.resolveReferences(resolvedReferences, referencedContent.getReferences());
                resolvedReferences.put(reference.getName(), referencedContent.getContent());
            }
        }
    }

    private ArtifactVersionMetaDataDto lookupForReference(ArtifactReferenceDto reference) {
        try {
            return this.getArtifactVersionMetaDataInternal(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
        }
        catch (VersionNotFoundException e) {
            return null;
        }
    }

    protected void deleteAllOrphanedContent() {
        this.log.debug("Deleting all orphaned content");
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements.deleteOrphanedReferences();
            handle.createUpdate(sql).execute();
            sql = this.sqlStatements.deleteAllOrphanedContent();
            handle.createUpdate(sql).execute();
            return null;
        });
    }

    protected void resetGlobalId(Handle handle) {
        this.resetSequence(handle, GLOBAL_ID_SEQUENCE, this.sqlStatements.selectMaxGlobalId());
    }

    protected void resetContentId(Handle handle) {
        this.resetSequence(handle, CONTENT_ID_SEQUENCE, this.sqlStatements.selectMaxContentId());
    }

    protected void resetCommentId(Handle handle) {
        this.resetSequence(handle, COMMENT_ID_SEQUENCE, this.sqlStatements.selectMaxCommentId());
    }

    private void resetSequence(Handle handle, String sequenceName, String sqlMaxIdFromTable) {
        Optional<Long> currentIdSeq;
        Optional<Long> maxIdTable = ((Query)handle.createQuery(sqlMaxIdFromTable).bind(0, this.tenantContext.tenantId())).mapTo(Long.class).findOne();
        Optional<Long> maxId = maxIdTable.map(arg_0 -> AbstractSqlRegistryStorage.lambda$resetSequence$146(currentIdSeq = ((Query)((Query)handle.createQuery(this.sqlStatements.selectCurrentSequenceValue()).bind(0, sequenceName)).bind(1, this.tenantContext.tenantId())).mapTo(Long.class).findOne(), arg_0));
        if (maxId.isPresent()) {
            this.log.info("Resetting {} sequence", (Object)sequenceName);
            long id = maxId.get();
            if ("postgresql".equals(this.sqlStatements.dbType())) {
                ((Update)((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.resetSequenceValue()).bind(0, this.tenantContext.tenantId())).bind(1, sequenceName)).bind(2, id)).bind(3, id)).execute();
            } else {
                ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.resetSequenceValue()).bind(0, this.tenantContext.tenantId())).bind(1, sequenceName)).bind(2, id)).execute();
            }
            this.log.info("Successfully reset {} to {}", (Object)sequenceName, (Object)id);
        }
    }

    protected void importArtifactRule(Handle handle, ArtifactRuleEntity entity) {
        if (this.isArtifactExists(entity.groupId, entity.artifactId)) {
            try {
                String sql = this.sqlStatements.importArtifactRule();
                ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(entity.groupId))).bind(2, entity.artifactId)).bind(3, entity.type.name())).bind(4, entity.configuration)).execute();
                this.log.info("Artifact rule imported successfully.");
            }
            catch (Exception e) {
                this.log.warn("Failed to import content entity (likely it already exists).", (Throwable)e);
            }
        } else {
            this.log.warn("Artifact rule import failed: artifact not found.");
        }
    }

    protected void importArtifactVersion(Handle handle, ArtifactVersionEntity entity) {
        if (!this.isArtifactExists(entity.groupId, entity.artifactId)) {
            try {
                String sql = this.sqlStatements.insertArtifact();
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, SqlUtil.normalizeGroupId(entity.groupId))).bind(2, entity.artifactId)).bind(3, entity.artifactType)).bind(4, entity.createdBy)).bind(5, new Date(entity.createdOn))).execute();
                this.log.info("Artifact entity imported successfully.");
            }
            catch (Exception e) {
                this.log.warn("Failed to import artifact entity.", (Throwable)e);
            }
        }
        if (entity.globalId == -1L || !this.isGlobalIdExists(entity.globalId)) {
            long globalId = this.nextGlobalIdIfInvalid(handle, entity.globalId);
            try {
                String sql = this.sqlStatements.importArtifactVersion();
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, globalId)).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(entity.groupId))).bind(3, entity.artifactId)).bind(4, entity.version)).bind(5, entity.versionId)).bind(6, (Enum<?>)entity.state)).bind(7, entity.name)).bind(8, entity.description)).bind(9, entity.createdBy)).bind(10, new Date(entity.createdOn))).bind(11, SqlUtil.serializeLabels(entity.labels))).bind(12, SqlUtil.serializeProperties(entity.properties))).bind(13, entity.contentId)).execute();
                this.log.info("Artifact version entity imported successfully.");
                if (entity.labels != null && !entity.labels.isEmpty()) {
                    entity.labels.forEach(label -> {
                        String sqli = this.sqlStatements.insertLabel();
                        ((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, this.tenantContext.tenantId())).bind(1, entity.globalId)).bind(2, label.toLowerCase())).execute();
                    });
                }
                if (entity.properties != null && !entity.properties.isEmpty()) {
                    entity.properties.forEach((k, v) -> {
                        String sqli = this.sqlStatements.insertProperty();
                        ((Update)((Update)((Update)((Update)handle.createUpdate(sqli).bind(0, this.tenantContext.tenantId())).bind(1, entity.globalId)).bind(2, k.toLowerCase())).bind(3, v.toLowerCase())).execute();
                    });
                }
                if (entity.isLatest) {
                    sql = this.sqlStatements.updateArtifactLatest();
                    ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, globalId)).bind(1, this.tenantContext.tenantId())).bind(2, SqlUtil.normalizeGroupId(entity.groupId))).bind(3, entity.artifactId)).execute();
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to import content entity.", (Throwable)e);
            }
        } else {
            this.log.info("Duplicate globalId detected, skipping import of artifact version.");
        }
    }

    protected void importContent(Handle handle, ContentEntity entity) {
        try {
            List<ArtifactReferenceDto> references = SqlUtil.deserializeReferences(entity.serializedReferences);
            if (!this.isContentExists(entity.contentId)) {
                String sql = this.sqlStatements.importContent();
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, entity.contentId)).bind(2, entity.canonicalHash)).bind(3, entity.contentHash)).bind(4, entity.contentBytes)).bind(5, entity.serializedReferences)).execute();
                this.insertReferences(handle, entity.contentId, references);
                this.log.info("Content entity imported successfully.");
            } else {
                this.log.info("Duplicate content entity already exists, skipped.");
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to import content entity.", (Throwable)e);
        }
    }

    protected void importGlobalRule(Handle handle, GlobalRuleEntity entity) {
        try {
            String sql = this.sqlStatements.importGlobalRule();
            ((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext().tenantId())).bind(1, entity.ruleType.name())).bind(2, entity.configuration)).execute();
            this.log.info("Global Rule entity imported successfully.");
        }
        catch (Exception e) {
            this.log.warn("Failed to import content entity (likely it already exists).", (Throwable)e);
        }
    }

    protected void importGroup(Handle handle, GroupEntity entity) {
        try {
            String sql = this.sqlStatements.importGroup();
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext().tenantId())).bind(1, SqlUtil.normalizeGroupId(entity.groupId))).bind(2, entity.description)).bind(3, entity.artifactsType)).bind(4, entity.createdBy)).bind(5, new Date(entity.createdOn))).bind(6, entity.modifiedBy)).bind(7, new Date(entity.modifiedOn))).bind(8, SqlUtil.serializeProperties(entity.properties))).execute();
            this.log.info("Group entity imported successfully.");
        }
        catch (Exception e) {
            this.log.warn("Failed to import group entity (likely it already exists).", (Throwable)e);
        }
    }

    protected void importComment(Handle handle, CommentEntity entity) {
        try {
            String sql = this.sqlStatements.insertComment();
            ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext.tenantId())).bind(1, entity.commentId)).bind(2, entity.globalId)).bind(3, entity.createdBy)).bind(4, new Date(entity.createdOn))).bind(5, entity.value)).execute();
            this.log.info("Comment entity imported successfully.");
        }
        catch (Exception e) {
            this.log.warn("Failed to import comment entity.", (Throwable)e);
        }
    }

    public boolean isContentExists(long contentId) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectContentExists();
            return ((Query)((Query)handle.createQuery(sql).bind(0, contentId)).bind(1, this.tenantContext.tenantId())).mapTo(Integer.class).one() > 0;
        });
    }

    protected boolean isGlobalIdExists(long globalId) throws RegistryStorageException {
        return this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectGlobalIdExists();
            return ((Query)((Query)handle.createQuery(sql).bind(0, globalId)).bind(1, this.tenantContext.tenantId())).mapTo(Integer.class).one() > 0;
        });
    }

    private ArtifactMetaDataDto versionToArtifactDto(String groupId, String artifactId, ArtifactVersionMetaDataDto vmdd) {
        ArtifactMetaDataDto amdd = new ArtifactMetaDataDto();
        amdd.setGlobalId(vmdd.getGlobalId());
        amdd.setContentId(vmdd.getContentId());
        amdd.setGroupId(SqlUtil.denormalizeGroupId(groupId));
        amdd.setId(artifactId);
        amdd.setModifiedBy(vmdd.getCreatedBy());
        amdd.setModifiedOn(vmdd.getCreatedOn());
        amdd.setState(vmdd.getState());
        amdd.setName(vmdd.getName());
        amdd.setDescription(vmdd.getDescription());
        amdd.setLabels(vmdd.getLabels());
        amdd.setProperties(vmdd.getProperties());
        amdd.setType(vmdd.getType());
        amdd.setVersion(vmdd.getVersion());
        amdd.setVersionId(vmdd.getVersionId());
        return amdd;
    }

    protected ContentHandle canonicalizeContent(String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) {
        try {
            ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(artifactType);
            ContentCanonicalizer canonicalizer = provider.getContentCanonicalizer();
            ContentHandle canonicalContent = canonicalizer.canonicalize(content, this.resolveReferences(references));
            return canonicalContent;
        }
        catch (Exception e) {
            this.log.debug("Failed to canonicalize content of type: {}", (Object)artifactType);
            return content;
        }
    }

    protected EditableArtifactMetaDataDto extractMetaData(String artifactType, ContentHandle content) {
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(artifactType);
        ContentExtractor extractor = provider.getContentExtractor();
        ExtractedMetaData emd = extractor.extract(content);
        EditableArtifactMetaDataDto metaData = emd != null ? new EditableArtifactMetaDataDto(emd.getName(), emd.getDescription(), emd.getLabels(), emd.getProperties()) : new EditableArtifactMetaDataDto();
        return metaData;
    }

    private static boolean hasContentFilter(Set<SearchFilter> filters) {
        for (SearchFilter searchFilter : filters) {
            if (searchFilter.getType() != SearchFilterType.contentHash && searchFilter.getType() != SearchFilterType.canonicalHash) continue;
            return true;
        }
        return false;
    }

    protected long nextContentId(Handle handle) {
        return this.nextSequenceValue(handle, CONTENT_ID_SEQUENCE);
    }

    protected long nextGlobalId(Handle handle) {
        return this.nextSequenceValue(handle, GLOBAL_ID_SEQUENCE);
    }

    protected long nextCommentId(Handle handle) {
        return this.nextSequenceValue(handle, COMMENT_ID_SEQUENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextSequenceValue(Handle handle, String sequenceName) {
        if (Set.of("mysql", "mssql", "postgresql").contains(this.sqlStatements.dbType())) {
            return ((Query)((Query)handle.createQuery(this.sqlStatements.getNextSequenceValue()).bind(0, this.tenantContext.tenantId())).bind(1, sequenceName)).mapTo(Long.class).one();
        }
        Object object = inmemorySequencesMutex;
        synchronized (object) {
            Optional<Long> seqExists = ((Query)((Query)handle.createQuery(this.sqlStatements.selectCurrentSequenceValue()).bind(0, sequenceName)).bind(1, this.tenantContext.tenantId())).mapTo(Long.class).findOne();
            if (seqExists.isPresent()) {
                Long newValue = seqExists.get() + 1L;
                ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.resetSequenceValue()).bind(0, this.tenantContext.tenantId())).bind(1, sequenceName)).bind(2, newValue)).execute();
                return newValue;
            }
            ((Update)((Update)((Update)handle.createUpdate(this.sqlStatements.insertSequenceValue()).bind(0, this.tenantContext.tenantId())).bind(1, sequenceName)).bind(2, 1)).execute();
            return 1L;
        }
    }

    private static String limitStr(String value, int limit) {
        return AbstractSqlRegistryStorage.limitStr(value, limit, false);
    }

    private static String limitStr(String value, int limit, boolean withEllipsis) {
        if (StringUtil.isEmpty((String)value)) {
            return value;
        }
        if (value.length() > limit) {
            if (withEllipsis) {
                return value.substring(0, limit - 3).concat("...");
            }
            return value.substring(0, limit);
        }
        return value;
    }

    private long nextGlobalIdIfInvalid(Handle handle, long globalId) {
        if (globalId == -1L) {
            return this.nextGlobalId(handle);
        }
        return globalId;
    }

    protected String resolveVersion(String groupId, String artifactId, String version) {
        if ("latest".equalsIgnoreCase(version)) {
            return this.getLatestArtifactMetaDataInternal(groupId, artifactId, RegistryStorage.ArtifactRetrievalBehavior.SKIP_DISABLED_LATEST).getVersion();
        }
        return version;
    }

    private static /* synthetic */ Long lambda$resetSequence$146(Optional currentIdSeq, Long maxIdTableValue) {
        if (currentIdSeq.isPresent() && (Long)currentIdSeq.get() > maxIdTableValue) {
            return (Long)currentIdSeq.get();
        }
        return maxIdTableValue;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, true);
    }
}

