/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.impl.sql.AbstractSqlRegistryStorage;
import io.apicurio.registry.storage.impl.sql.SqlDataImporter;
import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

public class ContentIdNotPreserveSqlDataImporter
extends SqlDataImporter {
    public ContentIdNotPreserveSqlDataImporter(Logger logger, Handle handle, AbstractSqlRegistryStorage registryStorage, boolean preserveGlobalId) {
        super(logger, handle, registryStorage, preserveGlobalId);
    }

    @Override
    public void importContent(ContentEntity entity) {
        List<ArtifactReferenceDto> references = SqlUtil.deserializeReferences(entity.serializedReferences);
        if (entity.canonicalHash == null) {
            if (entity.artifactType != null) {
                ContentHandle canonicalContent = this.getRegistryStorage().canonicalizeContent(entity.artifactType, ContentHandle.create((byte[])entity.contentBytes), references);
                entity.canonicalHash = DigestUtils.sha256Hex((byte[])canonicalContent.bytes());
            } else {
                throw new RegistryStorageException("There is not enough information about content. Artifact Type and CanonicalHash are both missing.");
            }
        }
        long newContentId = this.getRegistryStorage().createOrUpdateContent(this.getHandle(), ContentHandle.create((byte[])entity.contentBytes), entity.contentHash, entity.canonicalHash, references, entity.serializedReferences);
        this.getContentIdMapping().put(entity.contentId, newContentId);
        List<ArtifactVersionEntity> artifactsToImport = this.getWaitingForContent().stream().filter(artifactVersion -> artifactVersion.contentId == entity.contentId).collect(Collectors.toList());
        artifactsToImport.forEach(this::importArtifactVersion);
        this.getWaitingForContent().removeAll(artifactsToImport);
    }
}

