/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.CommonSqlStatements;

public class MySQLSqlStatements
extends CommonSqlStatements {
    @Override
    public String dbType() {
        return "mysql";
    }

    @Override
    public boolean isPrimaryKeyViolation(Exception error) {
        return error.getMessage().contains("Duplicate entry");
    }

    @Override
    public boolean isForeignKeyViolation(Exception error) {
        return error.getMessage().contains("violates foreign key constraint");
    }

    @Override
    public String isDatabaseInitialized() {
        return String.join((CharSequence)" ", "SELECT COUNT(*) AS count", "FROM information_schema.tables", "WHERE table_name = 'artifacts';");
    }

    @Override
    public String upsertContent() {
        return String.join((CharSequence)" ", "INSERT IGNORE INTO content", "(tenantId, contentId, canonicalHash, contentHash, content, artifactreferences)", "VALUES (?, ?, ?, ?, ?, ?);");
    }

    @Override
    public String upsertReference() {
        return String.join((CharSequence)" ", "INSERT IGNORE INTO artifactreferences", "(tenantId, contentId, groupId, artifactId, version, name)", "VALUES (?, ?, ?, ?, ?, ?);");
    }

    @Override
    public String upsertLogConfiguration() {
        return String.join((CharSequence)" ", "INSERT INTO logconfiguration (logger, loglevel)", "VALUES (?, ?)", "ON DUPLICATE KEY UPDATE loglevel = ?;");
    }

    @Override
    public String getNextSequenceValue() {
        return "CALL GetNextSequenceValue(?, ?, 1)";
    }

    @Override
    public String resetSequenceValue() {
        return String.join((CharSequence)" ", "INSERT INTO sequences (tenantId, name, value)", "VALUES (?, ?, ?)", "ON DUPLICATE KEY UPDATE value = ?;");
    }

    @Override
    public String insertVersion(boolean firstVersion) {
        if (firstVersion) {
            return String.join((CharSequence)" ", "INSERT INTO versions", "(globalId, tenantId, groupId, artifactId, version, versionId, state, name, description, createdBy, createdOn, labels, properties, contentId)", "VALUES (?, ?, ?, ?, ?, 1, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        return String.join((CharSequence)" ", String.join((CharSequence)" ", "INSERT INTO versions", "(globalId, tenantId, groupId, artifactId, version, versionId, state, name, description, createdBy, createdOn, labels, properties, contentId)", "SELECT", "? as globalId,", "? as tenantId,", "? as groupId,", "? as artifactId,", "? as version,", "(SELECT MAX(versionId) + 1 FROM versions WHERE tenantId = ? AND groupId = ? AND artifactId = ?) as versionId,", "? as state,", "? as name,", "? as description,", "? as createdBy,", "? as createdOn,", "? as labels,", "? as properties,", "? as contentId"));
    }

    @Override
    public String autoUpdateVersionForGlobalId() {
        return String.join((CharSequence)" ", "WITH v as (SELECT versionId  FROM versions WHERE tenantId = ? AND globalId = ?)", "UPDATE versions SET version = (SELECT versionId FROM v)", "WHERE tenantId = ? AND globalId = ?");
    }

    @Override
    public String selectGroupCountById() {
        return String.join((CharSequence)" ", "SELECT COUNT(g.groupId)", "FROM artifactgroups g", "WHERE g.tenantId = ? AND g.groupId = ?");
    }

    @Override
    public String insertGroup() {
        return String.join((CharSequence)" ", "INSERT INTO artifactgroups", "(tenantId, groupId, description, artifactsType, createdBy, createdOn, modifiedBy, modifiedOn, properties)", "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }

    @Override
    public String updateGroup() {
        return String.join((CharSequence)" ", "UPDATE artifactgroups ", "SET description = ? , artifactsType = ? , modifiedBy = ? , modifiedOn = ? , properties = ? ", "WHERE tenantId = ? AND groupId = ?");
    }

    @Override
    public String deleteGroup() {
        return String.join((CharSequence)" ", "DELETE", "FROM artifactgroups ", "WHERE tenantId = ? AND groupId = ?");
    }

    @Override
    public String deleteAllGroups() {
        return String.join((CharSequence)" ", "DELETE", "FROM artifactgroups", "WHERE tenantId = ?");
    }

    @Override
    public String selectGroups() {
        return String.join((CharSequence)" ", "SELECT g.*", "FROM artifactgroups g", "WHERE g.tenantId = ?", "ORDER BY g.groupId ASC", "LIMIT ?");
    }

    @Override
    public String selectGroupByGroupId() {
        return String.join((CharSequence)" ", "SELECT g.*", "FROM artifactgroups g", "WHERE g.tenantId = ? AND g.groupId = ?");
    }

    @Override
    public String exportGroups() {
        return String.join((CharSequence)" ", "SELECT *", "FROM artifactgroups g", "WHERE g.tenantId = ?");
    }

    @Override
    public String importGroup() {
        return String.join((CharSequence)" ", "INSERT INTO artifactgroups", "(tenantId, groupId, description, artifactsType, createdBy, createdOn, modifiedBy, modifiedOn, properties)", "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }
}

